/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import androidx.collection.LruCache;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapPoolHelper;
import com.datadog.android.sessionreplay.internal.recorder.resources.Cache;
import com.datadog.android.sessionreplay.internal.utils.CacheUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 02\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u00010B\u0091\u0001\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0014\b\u0002\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\b\u0012:\b\u0002\u0010\t\u001a4\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\nj\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r`\f\u0012\u0018\b\u0002\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r\u0012\u0014\b\u0002\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0010\u00a2\u0006\u0002\u0010\u0011J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u0019H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J)\u0010\u001e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0000\u00a2\u0006\u0002\b$J\u0010\u0010%\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0010\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0019H\u0016J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010,\u001a\u00020 H\u0016J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010.\u001a\u00020\u0003H\u0016J\b\u0010/\u001a\u00020 H\u0016R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000RH\u0010\t\u001a4\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u000b0\nj\u001e\u0012\u0004\u0012\u00020\u0002\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r`\f8\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\r8\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00061"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPool;", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/Cache;", "", "Landroid/graphics/Bitmap;", "Landroid/content/ComponentCallbacks2;", "bitmapPoolHelper", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPoolHelper;", "cacheUtils", "Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils;", "bitmapsBySize", "Ljava/util/HashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashMap;", "Lkotlin/collections/HashSet;", "usedBitmaps", "cache", "Landroidx/collection/LruCache;", "(Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPoolHelper;Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils;Ljava/util/HashMap;Ljava/util/HashSet;Landroidx/collection/LruCache;)V", "bitmapIndex", "Ljava/util/concurrent/atomic/AtomicInteger;", "getBitmapsBySize$dd_sdk_android_session_replay_release", "()Ljava/util/HashMap;", "getUsedBitmaps$dd_sdk_android_session_replay_release", "()Ljava/util/HashSet;", "addBitmapToPool", "", "key", "bitmap", "clear", "get", "getBitmapByProperties", "width", "", "height", "config", "Landroid/graphics/Bitmap$Config;", "getBitmapByProperties$dd_sdk_android_session_replay_release", "markBitmapAsFree", "markBitmapAsUsed", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onTrimMemory", "level", "put", "value", "size", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nBitmapPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BitmapPool.kt\ncom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1#2:171\n*E\n"})
public final class BitmapPool
implements Cache<String, Bitmap>,
ComponentCallbacks2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BitmapPoolHelper bitmapPoolHelper;
    @NotNull
    private final CacheUtils<String, Bitmap> cacheUtils;
    @NotNull
    private final HashMap<String, HashSet<Bitmap>> bitmapsBySize;
    @NotNull
    private final HashSet<Bitmap> usedBitmaps;
    @NotNull
    private LruCache<String, Bitmap> cache;
    @NotNull
    private AtomicInteger bitmapIndex;
    private static final int MAX_CACHE_MEMORY_SIZE_BYTES = 0x400000;

    public BitmapPool(@NotNull BitmapPoolHelper bitmapPoolHelper, @NotNull CacheUtils<String, Bitmap> cacheUtils, @NotNull HashMap<String, HashSet<Bitmap>> bitmapsBySize, @NotNull HashSet<Bitmap> usedBitmaps, @NotNull LruCache<String, Bitmap> cache) {
        Intrinsics.checkNotNullParameter((Object)bitmapPoolHelper, (String)"bitmapPoolHelper");
        Intrinsics.checkNotNullParameter(cacheUtils, (String)"cacheUtils");
        Intrinsics.checkNotNullParameter(bitmapsBySize, (String)"bitmapsBySize");
        Intrinsics.checkNotNullParameter(usedBitmaps, (String)"usedBitmaps");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        this.bitmapPoolHelper = bitmapPoolHelper;
        this.cacheUtils = cacheUtils;
        this.bitmapsBySize = bitmapsBySize;
        this.usedBitmaps = usedBitmaps;
        this.cache = cache;
        this.bitmapIndex = new AtomicInteger(0);
    }

    public /* synthetic */ BitmapPool(final BitmapPoolHelper bitmapPoolHelper, CacheUtils cacheUtils, final HashMap hashMap, final HashSet hashSet, LruCache lruCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bitmapPoolHelper = new BitmapPoolHelper(null, 1, null);
        }
        if ((n & 2) != 0) {
            cacheUtils = new CacheUtils<String, Bitmap>(null, 1, null);
        }
        if ((n & 4) != 0) {
            hashMap = new HashMap<String, HashSet<Bitmap>>();
        }
        if ((n & 8) != 0) {
            hashSet = new HashSet<Bitmap>();
        }
        if ((n & 0x10) != 0) {
            int n2 = Companion.getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release();
            lruCache = (LruCache)new LruCache<String, Bitmap>(n2){

                protected int sizeOf(@NotNull String key, @NotNull Bitmap value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return value.getAllocationByteCount();
                }

                protected synchronized void entryRemoved(boolean evicted, @NotNull String key, @NotNull Bitmap oldValue, @Nullable Bitmap newValue) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)oldValue, (String)"oldValue");
                    bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Unit>(this, evicted, key, oldValue, newValue){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ boolean $evicted;
                        final /* synthetic */ String $key;
                        final /* synthetic */ Bitmap $oldValue;
                        final /* synthetic */ Bitmap $newValue;
                        {
                            this.this$0 = $receiver;
                            this.$evicted = $evicted;
                            this.$key = $key;
                            this.$oldValue = $oldValue;
                            this.$newValue = $newValue;
                            super(0);
                        }

                        public final void invoke() {
                            1.access$entryRemoved$s820278579(this.this$0, this.$evicted, this.$key, this.$oldValue, this.$newValue);
                        }
                    });
                    String dimensionsKey = bitmapPoolHelper.generateKey$dd_sdk_android_session_replay_release(oldValue);
                    HashSet<Bitmap> hashSet2 = hashMap.get(dimensionsKey);
                    if (hashSet2 == null) {
                        hashSet2 = new HashSet<Bitmap>();
                    }
                    HashSet<Bitmap> bitmapGroup = hashSet2;
                    bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(bitmapGroup, oldValue){
                        final /* synthetic */ HashSet<Bitmap> $bitmapGroup;
                        final /* synthetic */ Bitmap $oldValue;
                        {
                            this.$bitmapGroup = $bitmapGroup;
                            this.$oldValue = $oldValue;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            return this.$bitmapGroup.remove(this.$oldValue);
                        }
                    });
                    bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(hashSet, oldValue){
                        final /* synthetic */ HashSet<Bitmap> $usedBitmaps;
                        final /* synthetic */ Bitmap $oldValue;
                        {
                            this.$usedBitmaps = $usedBitmaps;
                            this.$oldValue = $oldValue;
                            super(0);
                        }

                        @NotNull
                        public final Boolean invoke() {
                            return this.$usedBitmaps.remove(this.$oldValue);
                        }
                    });
                    oldValue.recycle();
                }

                public static final /* synthetic */ void access$entryRemoved$s820278579(1 $this, boolean p0, Object p1, Object p2, Object p3) {
                    super.entryRemoved(p0, p1, p2, p3);
                }
            };
        }
        this(bitmapPoolHelper, cacheUtils, hashMap, hashSet, (LruCache<String, Bitmap>)lruCache);
    }

    @VisibleForTesting
    @NotNull
    public final HashMap<String, HashSet<Bitmap>> getBitmapsBySize$dd_sdk_android_session_replay_release() {
        return this.bitmapsBySize;
    }

    @VisibleForTesting
    @NotNull
    public final HashSet<Bitmap> getUsedBitmaps$dd_sdk_android_session_replay_release() {
        return this.usedBitmaps;
    }

    @Override
    public synchronized void put(@NotNull Bitmap value) {
        boolean bitmapExistsInPool2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!value.isMutable() || value.isRecycled()) {
            return;
        }
        String key = this.bitmapPoolHelper.generateKey$dd_sdk_android_session_replay_release(value);
        Boolean bl = (Boolean)this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(this, key, value){
            final /* synthetic */ BitmapPool this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ Bitmap $value;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$value = $value;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                HashSet<Bitmap> hashSet = this.this$0.getBitmapsBySize$dd_sdk_android_session_replay_release().get(this.$key);
                return hashSet != null ? hashSet.contains(this.$value) : false;
            }
        });
        boolean bl2 = bitmapExistsInPool2 = bl != null ? bl : false;
        if (!bitmapExistsInPool2) {
            this.addBitmapToPool(key, value);
        }
        this.markBitmapAsFree(value);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public synchronized void clear() {
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Unit>(this){
            final /* synthetic */ BitmapPool this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BitmapPool.access$getCache$p(this.this$0).evictAll();
            }
        });
    }

    @Override
    @Nullable
    public synchronized Bitmap get(@NotNull String key) {
        Bitmap bitmap;
        Object v3;
        block4: {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            HashSet<Bitmap> hashSet = this.bitmapsBySize.get(key);
            if (hashSet == null) {
                return null;
            }
            HashSet<Bitmap> bitmapsWithReqDimensions = hashSet;
            Iterable iterable = bitmapsWithReqDimensions;
            for (Object t : iterable) {
                Bitmap it = (Bitmap)t;
                boolean bl = false;
                Boolean bl2 = (Boolean)this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(this, it){
                    final /* synthetic */ BitmapPool this$0;
                    final /* synthetic */ Bitmap $it;
                    {
                        this.this$0 = $receiver;
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final Boolean invoke() {
                        return !this.this$0.getUsedBitmaps$dd_sdk_android_session_replay_release().contains(this.$it);
                    }
                });
                boolean bl3 = bl2 != null ? bl2 : false;
                if (!bl3) continue;
                v3 = t;
                break block4;
            }
            v3 = null;
        }
        Bitmap bitmap2 = v3;
        if (bitmap2 != null) {
            Bitmap bitmap3;
            Bitmap $this$get_u24lambda_u241 = bitmap3 = bitmap2;
            boolean bl = false;
            this.markBitmapAsUsed($this$get_u24lambda_u241);
            bitmap = bitmap3;
        } else {
            bitmap = null;
        }
        return bitmap;
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    public synchronized void onLowMemory() {
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Unit>(this){
            final /* synthetic */ BitmapPool this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                BitmapPool.access$getCache$p(this.this$0).evictAll();
            }
        });
    }

    public synchronized void onTrimMemory(int level) {
        this.cacheUtils.handleTrimMemory$dd_sdk_android_session_replay_release(level, this.cache);
    }

    @Nullable
    public final Bitmap getBitmapByProperties$dd_sdk_android_session_replay_release(int width, int height, @Nullable Bitmap.Config config) {
        String key = this.bitmapPoolHelper.generateKey$dd_sdk_android_session_replay_release(width, height, config);
        return this.get(key);
    }

    private final void markBitmapAsFree(Bitmap bitmap) {
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(this, bitmap){
            final /* synthetic */ BitmapPool this$0;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getUsedBitmaps$dd_sdk_android_session_replay_release().remove(this.$bitmap);
            }
        });
    }

    private final void markBitmapAsUsed(Bitmap bitmap) {
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(this, bitmap){
            final /* synthetic */ BitmapPool this$0;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$bitmap = $bitmap;
                super(0);
            }

            @NotNull
            public final Boolean invoke() {
                return this.this$0.getUsedBitmaps$dd_sdk_android_session_replay_release().add(this.$bitmap);
            }
        });
    }

    private final void addBitmapToPool(String key, Bitmap bitmap) {
        int cacheIndex = this.bitmapIndex.incrementAndGet();
        String cacheKey = key + "-" + cacheIndex;
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Bitmap>(this, cacheKey, bitmap){
            final /* synthetic */ BitmapPool this$0;
            final /* synthetic */ String $cacheKey;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$cacheKey = $cacheKey;
                this.$bitmap = $bitmap;
                super(0);
            }

            @Nullable
            public final Bitmap invoke() {
                return (Bitmap)BitmapPool.access$getCache$p(this.this$0).put((Object)this.$cacheKey, (Object)this.$bitmap);
            }
        });
        if (Build.VERSION.SDK_INT >= 24) {
            this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<HashSet<Bitmap>>(this, key){
                final /* synthetic */ BitmapPool this$0;
                final /* synthetic */ String $key;
                {
                    this.this$0 = $receiver;
                    this.$key = $key;
                    super(0);
                }

                @Nullable
                public final HashSet<Bitmap> invoke() {
                    return this.this$0.getBitmapsBySize$dd_sdk_android_session_replay_release().putIfAbsent(this.$key, new HashSet<E>());
                }
            });
        } else if (this.bitmapsBySize.get(key) == null) {
            ((Map)this.bitmapsBySize).put(key, new HashSet());
        }
        this.bitmapPoolHelper.safeCall$dd_sdk_android_session_replay_release((Function0)new Function0<Boolean>(this, key, bitmap){
            final /* synthetic */ BitmapPool this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ Bitmap $bitmap;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$bitmap = $bitmap;
                super(0);
            }

            @Nullable
            public final Boolean invoke() {
                HashSet<Bitmap> hashSet = this.this$0.getBitmapsBySize$dd_sdk_android_session_replay_release().get(this.$key);
                return hashSet != null ? Boolean.valueOf(hashSet.add(this.$bitmap)) : null;
            }
        });
    }

    @Override
    public void put(@NotNull String key, @NotNull Bitmap value) {
        Cache.DefaultImpls.put(this, key, value);
    }

    public BitmapPool() {
        this(null, null, null, null, null, 31, null);
    }

    public static final /* synthetic */ LruCache access$getCache$p(BitmapPool $this) {
        return $this.cache;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\u00020\u00048\u0000X\u0081D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapPool$Companion;", "", "()V", "MAX_CACHE_MEMORY_SIZE_BYTES", "", "getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release$annotations", "getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release", "()I", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release() {
            return MAX_CACHE_MEMORY_SIZE_BYTES;
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

