/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.util.DisplayMetrics;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.sessionreplay.ImagePrivacy;
import com.datadog.android.sessionreplay.internal.recorder.ViewUtilsInternal;
import com.datadog.android.sessionreplay.internal.recorder.resources.ImageTypeResolver;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceResolver;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceResolverCallback;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.resources.DrawableCopier;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ImageWireframeHelper;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 P2\u00020\u0001:\u0003PQRB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J8\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001aH\u0002JB\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\u0006\u0010'\u001a\u00020 2\u0006\u0010#\u001a\u00020\u001a2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J^\u0010*\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106H\u0017J\u0094\u0001\u00107\u001a\u0004\u0018\u00010\u00132\u0006\u00108\u001a\u0002092\u0006\u00101\u001a\u0002022\u0006\u0010:\u001a\u00020\u00102\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00102\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001062\b\u0010@\u001a\u0004\u0018\u00010\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J\u0088\u0001\u0010A\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\u00102\u0006\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\u00102\u0006\u0010G\u001a\u00020\u00102\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010(\u001a\u0004\u0018\u00010)2\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u0001062\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0017J\u0018\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020\u001a2\u0006\u0010K\u001a\u00020LH\u0002J(\u0010M\u001a\u00020N2\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010H\u0002J(\u0010O\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010;\u001a\u0002002\u0006\u0010<\u001a\u00020=2\u0006\u0010-\u001a\u00020.H\u0002J(\u0010O\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u0010;\u001a\u0002002\u0006\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u0010H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006S"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper;", "Lcom/datadog/android/sessionreplay/utils/ImageWireframeHelper;", "logger", "Lcom/datadog/android/api/InternalLogger;", "resourceResolver", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "viewUtilsInternal", "Lcom/datadog/android/sessionreplay/internal/recorder/ViewUtilsInternal;", "imageTypeResolver", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageTypeResolver;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver;Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/internal/recorder/ViewUtilsInternal;Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageTypeResolver;)V", "convertIndexToCompoundDrawablePosition", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$CompoundDrawablePositions;", "compoundDrawableIndex", "", "createCompoundDrawableWireframes", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "textView", "Landroid/widget/TextView;", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "prevWireframeIndex", "customResourceIdCacheKey", "", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "createContentPlaceholderWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$PlaceholderWireframe;", "id", "", "globalBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "label", "x", "y", "width", "height", "clipping", "Lcom/datadog/android/sessionreplay/model/MobileSegment$WireframeClip;", "createImageWireframeByBitmap", "bitmap", "Landroid/graphics/Bitmap;", "density", "", "isContextualImage", "", "imagePrivacy", "Lcom/datadog/android/sessionreplay/ImagePrivacy;", "shapeStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "border", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeBorder;", "createImageWireframeByDrawable", "view", "Landroid/view/View;", "currentWireframeIndex", "usePIIPlaceholder", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableCopier", "Lcom/datadog/android/sessionreplay/recorder/resources/DrawableCopier;", "prefix", "createImageWireframeByPath", "path", "Landroid/graphics/Path;", "strokeColor", "strokeWidth", "targetWidth", "targetHeight", "populateResourceIdInWireframe", "", "resourceId", "wireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ImageWireframe;", "resolveDrawableProperties", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$DrawableProperties;", "shouldMaskContextualImage", "Companion", "CompoundDrawablePositions", "DrawableProperties", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nDefaultImageWireframeHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultImageWireframeHelper.kt\ncom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,514:1\n13374#2,3:515\n*S KotlinDebug\n*F\n+ 1 DefaultImageWireframeHelper.kt\ncom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper\n*L\n330#1:515,3\n*E\n"})
public final class DefaultImageWireframeHelper
implements ImageWireframeHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private final ResourceResolver resourceResolver;
    @NotNull
    private final ViewIdentifierResolver viewIdentifierResolver;
    @NotNull
    private final ViewUtilsInternal viewUtilsInternal;
    @NotNull
    private final ImageTypeResolver imageTypeResolver;
    @NotNull
    public static final String MASK_CONTEXTUAL_CONTENT_LABEL = "Content Image";
    @NotNull
    public static final String MASK_ALL_CONTENT_LABEL = "Image";
    @NotNull
    public static final String APPLICATION_CONTEXT_NULL_ERROR = "Application context is null for view %s";
    @NotNull
    public static final String RESOURCES_NULL_ERROR = "Resources is null for view %s";

    public DefaultImageWireframeHelper(@NotNull InternalLogger logger, @NotNull ResourceResolver resourceResolver, @NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ViewUtilsInternal viewUtilsInternal, @NotNull ImageTypeResolver imageTypeResolver) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)resourceResolver, (String)"resourceResolver");
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)viewUtilsInternal, (String)"viewUtilsInternal");
        Intrinsics.checkNotNullParameter((Object)imageTypeResolver, (String)"imageTypeResolver");
        this.logger = logger;
        this.resourceResolver = resourceResolver;
        this.viewIdentifierResolver = viewIdentifierResolver;
        this.viewUtilsInternal = viewUtilsInternal;
        this.imageTypeResolver = imageTypeResolver;
    }

    @Override
    @UiThread
    @NotNull
    public MobileSegment.Wireframe createImageWireframeByPath(long id2, @NotNull GlobalBounds globalBounds, @NotNull Path path, int strokeColor, int strokeWidth, int targetWidth, int targetHeight, float density, boolean isContextualImage, @NotNull ImagePrivacy imagePrivacy, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @Nullable MobileSegment.WireframeClip clipping, @Nullable MobileSegment.ShapeStyle shapeStyle, @Nullable MobileSegment.ShapeBorder border, @Nullable String customResourceIdCacheKey) {
        Intrinsics.checkNotNullParameter((Object)globalBounds, (String)"globalBounds");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        if (imagePrivacy == ImagePrivacy.MASK_ALL) {
            return this.createContentPlaceholderWireframe(id2, globalBounds.getX(), globalBounds.getY(), targetWidth, targetHeight, MASK_ALL_CONTENT_LABEL, clipping);
        }
        if (this.shouldMaskContextualImage(imagePrivacy, isContextualImage, IntExtKt.densityNormalized((int)targetWidth, (float)density), IntExtKt.densityNormalized((int)targetHeight, (float)density))) {
            return this.createContentPlaceholderWireframe(id2, globalBounds.getX(), globalBounds.getY(), targetWidth, targetHeight, MASK_CONTEXTUAL_CONTENT_LABEL, clipping);
        }
        long l = globalBounds.getX();
        long l2 = globalBounds.getY();
        long l3 = targetWidth;
        long l4 = targetHeight;
        MobileSegment.Wireframe.ImageWireframe imageWireframe = new MobileSegment.Wireframe.ImageWireframe(id2, l, l2, l3, l4, clipping, shapeStyle, border, null, null, null, true, 1792, null);
        asyncJobStatusCallback.jobStarted();
        this.resourceResolver.resolveResourceIdFromPath$dd_sdk_android_session_replay_release(path, strokeColor, strokeWidth, targetWidth, targetHeight, customResourceIdCacheKey, new ResourceResolverCallback(this, imageWireframe, asyncJobStatusCallback){
            final /* synthetic */ DefaultImageWireframeHelper this$0;
            final /* synthetic */ MobileSegment.Wireframe.ImageWireframe $imageWireframe;
            final /* synthetic */ AsyncJobStatusCallback $asyncJobStatusCallback;
            {
                this.this$0 = $receiver;
                this.$imageWireframe = $imageWireframe;
                this.$asyncJobStatusCallback = $asyncJobStatusCallback;
            }

            public void onSuccess(@NotNull String resourceId) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                DefaultImageWireframeHelper.access$populateResourceIdInWireframe(this.this$0, resourceId, this.$imageWireframe);
                this.$asyncJobStatusCallback.jobFinished();
            }

            public void onFailure() {
                this.$asyncJobStatusCallback.jobFinished();
            }
        });
        return imageWireframe;
    }

    @Override
    @UiThread
    @NotNull
    public MobileSegment.Wireframe createImageWireframeByBitmap(long id2, @NotNull GlobalBounds globalBounds, @NotNull Bitmap bitmap, float density, boolean isContextualImage, @NotNull ImagePrivacy imagePrivacy, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @Nullable MobileSegment.WireframeClip clipping, @Nullable MobileSegment.ShapeStyle shapeStyle, @Nullable MobileSegment.ShapeBorder border) {
        Intrinsics.checkNotNullParameter((Object)globalBounds, (String)"globalBounds");
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        if (imagePrivacy == ImagePrivacy.MASK_ALL) {
            return this.createContentPlaceholderWireframe(id2, globalBounds, MASK_ALL_CONTENT_LABEL);
        }
        if (isContextualImage && ImagePrivacy.MASK_LARGE_ONLY == imagePrivacy) {
            return this.createContentPlaceholderWireframe(id2, globalBounds, MASK_CONTEXTUAL_CONTENT_LABEL);
        }
        long l = globalBounds.getX();
        long l2 = globalBounds.getY();
        long l3 = globalBounds.getWidth();
        long l4 = globalBounds.getHeight();
        MobileSegment.Wireframe.ImageWireframe imageWireframe = new MobileSegment.Wireframe.ImageWireframe(id2, l, l2, l3, l4, clipping, shapeStyle, border, null, null, null, true, 1792, null);
        asyncJobStatusCallback.jobStarted();
        this.resourceResolver.resolveResourceIdFromBitmap$dd_sdk_android_session_replay_release(bitmap, new ResourceResolverCallback(this, imageWireframe, asyncJobStatusCallback){
            final /* synthetic */ DefaultImageWireframeHelper this$0;
            final /* synthetic */ MobileSegment.Wireframe.ImageWireframe $imageWireframe;
            final /* synthetic */ AsyncJobStatusCallback $asyncJobStatusCallback;
            {
                this.this$0 = $receiver;
                this.$imageWireframe = $imageWireframe;
                this.$asyncJobStatusCallback = $asyncJobStatusCallback;
            }

            public void onSuccess(@NotNull String resourceId) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                DefaultImageWireframeHelper.access$populateResourceIdInWireframe(this.this$0, resourceId, this.$imageWireframe);
                this.$asyncJobStatusCallback.jobFinished();
            }

            public void onFailure() {
                this.$asyncJobStatusCallback.jobFinished();
            }
        });
        return imageWireframe;
    }

    @Override
    @UiThread
    @Nullable
    public MobileSegment.Wireframe createImageWireframeByDrawable(@NotNull View view, @NotNull ImagePrivacy imagePrivacy, int currentWireframeIndex, long x, long y, int width, int height, boolean usePIIPlaceholder, @NotNull Drawable drawable, @NotNull DrawableCopier drawableCopier, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @Nullable MobileSegment.WireframeClip clipping, @Nullable MobileSegment.ShapeStyle shapeStyle, @Nullable MobileSegment.ShapeBorder border, @Nullable String prefix, @Nullable String customResourceIdCacheKey) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)imagePrivacy, (String)"imagePrivacy");
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)drawableCopier, (String)"drawableCopier");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Long id2 = this.viewIdentifierResolver.resolveChildUniqueIdentifier(view, prefix + currentWireframeIndex);
        DrawableProperties drawableProperties = this.resolveDrawableProperties(view, drawable, width, height);
        if (id2 == null || !drawableProperties.isValid()) {
            return null;
        }
        Resources resources = view.getResources();
        if (resources == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)((Function0)new Function0<String>(view){
                final /* synthetic */ View $view;
                {
                    this.$view = $view;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Resources is null for view %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$view.getClass().getCanonicalName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return null;
        }
        DisplayMetrics displayMetrics = resources.getDisplayMetrics();
        Context applicationContext = view.getContext().getApplicationContext();
        if (applicationContext == null) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.TELEMETRY, (Function0)((Function0)new Function0<String>(view){
                final /* synthetic */ View $view;
                {
                    this.$view = $view;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Application context is null for view %s";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$view.getClass().getCanonicalName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            return null;
        }
        float density = displayMetrics.density;
        long drawableWidthDp = IntExtKt.densityNormalized((int)drawableProperties.getDrawableWidth(), (float)density);
        long drawableHeightDp = IntExtKt.densityNormalized((int)drawableProperties.getDrawableHeight(), (float)density);
        if (imagePrivacy == ImagePrivacy.MASK_ALL) {
            return this.createContentPlaceholderWireframe(id2, x, y, drawableWidthDp, drawableHeightDp, MASK_ALL_CONTENT_LABEL, clipping);
        }
        if (this.shouldMaskContextualImage(imagePrivacy, usePIIPlaceholder, drawable, density)) {
            return this.createContentPlaceholderWireframe(id2, x, y, drawableWidthDp, drawableHeightDp, MASK_CONTEXTUAL_CONTENT_LABEL, clipping);
        }
        MobileSegment.Wireframe.ImageWireframe imageWireframe = new MobileSegment.Wireframe.ImageWireframe(id2, x, y, drawableWidthDp, drawableHeightDp, clipping, shapeStyle, border, null, null, null, true, 1792, null);
        asyncJobStatusCallback.jobStarted();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"displayMetrics");
        this.resourceResolver.resolveResourceIdFromDrawable$dd_sdk_android_session_replay_release(resources, applicationContext, displayMetrics, drawableProperties.getDrawable(), drawableCopier, width, height, customResourceIdCacheKey, new ResourceResolverCallback(this, imageWireframe, asyncJobStatusCallback){
            final /* synthetic */ DefaultImageWireframeHelper this$0;
            final /* synthetic */ MobileSegment.Wireframe.ImageWireframe $imageWireframe;
            final /* synthetic */ AsyncJobStatusCallback $asyncJobStatusCallback;
            {
                this.this$0 = $receiver;
                this.$imageWireframe = $imageWireframe;
                this.$asyncJobStatusCallback = $asyncJobStatusCallback;
            }

            public void onSuccess(@NotNull String resourceId) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                DefaultImageWireframeHelper.access$populateResourceIdInWireframe(this.this$0, resourceId, this.$imageWireframe);
                this.$asyncJobStatusCallback.jobFinished();
            }

            public void onFailure() {
                this.$asyncJobStatusCallback.jobFinished();
            }
        });
        return imageWireframe;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> createCompoundDrawableWireframes(@NotNull TextView textView, @NotNull MappingContext mappingContext, int prevWireframeIndex, @Nullable String customResourceIdCacheKey, @NotNull AsyncJobStatusCallback asyncJobStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        List result2 = new ArrayList();
        int wireframeIndex = 0;
        wireframeIndex = prevWireframeIndex;
        float density = mappingContext.getSystemInformation().getScreenDensity();
        Drawable[] drawableArray = textView.getCompoundDrawables();
        Intrinsics.checkNotNullExpressionValue((Object)drawableArray, (String)"textView.compoundDrawables");
        Object[] $this$forEachIndexed$iv = drawableArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            MobileSegment.WireframeClip wireframeClip;
            int n;
            int n2;
            long l;
            long l2;
            int n3;
            CompoundDrawablePositions compoundDrawablePosition;
            Drawable drawable;
            int n4 = index$iv++;
            Drawable cfr_ignored_0 = (Drawable)item$iv;
            int compoundDrawableIndex = n4;
            boolean bl = false;
            if (compoundDrawableIndex > CompoundDrawablePositions.values().length || this.convertIndexToCompoundDrawablePosition(compoundDrawableIndex) == null || (drawable = textView.getCompoundDrawables()[compoundDrawableIndex]) == null) continue;
            GlobalBounds drawableCoordinates = this.viewUtilsInternal.resolveCompoundDrawableBounds$dd_sdk_android_session_replay_release((View)textView, drawable, density, compoundDrawablePosition);
            String resourceCacheKey = customResourceIdCacheKey != null ? customResourceIdCacheKey + "_" + compoundDrawableIndex : null;
            ImagePrivacy imagePrivacy = mappingContext.getImagePrivacy();
            MobileSegment.Wireframe wireframe = ImageWireframeHelper.DefaultImpls.createImageWireframeByDrawable$default(this, (View)textView, imagePrivacy, n3 = ++wireframeIndex, l2 = drawableCoordinates.getX(), l = drawableCoordinates.getY(), n2 = drawable.getIntrinsicWidth(), n = drawable.getIntrinsicHeight(), true, drawable, null, asyncJobStatusCallback, wireframeClip = new MobileSegment.WireframeClip(null, null, null, null, 15, null), null, null, null, resourceCacheKey, 16896, null);
            if (wireframe == null) continue;
            MobileSegment.Wireframe resultWireframe = wireframe;
            boolean bl2 = false;
            result2.add(resultWireframe);
        }
        return result2;
    }

    private final DrawableProperties resolveDrawableProperties(View view, Drawable drawable, int width, int height) {
        DrawableProperties drawableProperties;
        Drawable drawable2 = drawable;
        if (drawable2 instanceof LayerDrawable) {
            if (((LayerDrawable)drawable).getNumberOfLayers() > 0) {
                Drawable drawable3 = ((LayerDrawable)drawable).getDrawable(0);
                Intrinsics.checkNotNullExpressionValue((Object)drawable3, (String)"drawable.getDrawable(0)");
                drawableProperties = this.resolveDrawableProperties(view, drawable3, width, height);
            } else {
                drawableProperties = new DrawableProperties(drawable, ((LayerDrawable)drawable).getIntrinsicWidth(), ((LayerDrawable)drawable).getIntrinsicHeight());
            }
        } else {
            Drawable internalDrawable;
            drawableProperties = drawable2 instanceof InsetDrawable ? ((internalDrawable = ((InsetDrawable)drawable).getDrawable()) != null ? this.resolveDrawableProperties(view, internalDrawable, width, height) : new DrawableProperties(drawable, ((InsetDrawable)drawable).getIntrinsicWidth(), ((InsetDrawable)drawable).getIntrinsicHeight())) : new DrawableProperties(drawable, width, height);
        }
        return drawableProperties;
    }

    private final MobileSegment.Wireframe.PlaceholderWireframe createContentPlaceholderWireframe(long id2, GlobalBounds globalBounds, String label) {
        return new MobileSegment.Wireframe.PlaceholderWireframe(id2, globalBounds.getX(), globalBounds.getY(), globalBounds.getWidth(), globalBounds.getHeight(), null, label, 32, null);
    }

    private final MobileSegment.Wireframe.PlaceholderWireframe createContentPlaceholderWireframe(long id2, long x, long y, long width, long height, String label, MobileSegment.WireframeClip clipping) {
        return new MobileSegment.Wireframe.PlaceholderWireframe(id2, x, y, width, height, clipping, label);
    }

    private final CompoundDrawablePositions convertIndexToCompoundDrawablePosition(int compoundDrawableIndex) {
        CompoundDrawablePositions compoundDrawablePositions;
        switch (compoundDrawableIndex) {
            case 0: {
                compoundDrawablePositions = CompoundDrawablePositions.LEFT;
                break;
            }
            case 1: {
                compoundDrawablePositions = CompoundDrawablePositions.TOP;
                break;
            }
            case 2: {
                compoundDrawablePositions = CompoundDrawablePositions.RIGHT;
                break;
            }
            case 3: {
                compoundDrawablePositions = CompoundDrawablePositions.BOTTOM;
                break;
            }
            default: {
                compoundDrawablePositions = null;
            }
        }
        return compoundDrawablePositions;
    }

    private final boolean shouldMaskContextualImage(ImagePrivacy imagePrivacy, boolean usePIIPlaceholder, int width, int height) {
        return imagePrivacy == ImagePrivacy.MASK_LARGE_ONLY && usePIIPlaceholder && this.imageTypeResolver.isPIIByDimensions(width, height);
    }

    private final boolean shouldMaskContextualImage(ImagePrivacy imagePrivacy, boolean usePIIPlaceholder, Drawable drawable, float density) {
        return imagePrivacy == ImagePrivacy.MASK_LARGE_ONLY && usePIIPlaceholder && this.imageTypeResolver.isDrawablePII(drawable, density);
    }

    private final void populateResourceIdInWireframe(String resourceId, MobileSegment.Wireframe.ImageWireframe wireframe) {
        wireframe.setResourceId(resourceId);
        wireframe.setEmpty(false);
    }

    public static final /* synthetic */ void access$populateResourceIdInWireframe(DefaultImageWireframeHelper $this, String resourceId, MobileSegment.Wireframe.ImageWireframe wireframe) {
        $this.populateResourceIdInWireframe(resourceId, wireframe);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002R\u0016\u0010\u0006\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u0016\u0010\b\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0002R\u0016\u0010\n\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$Companion;", "", "()V", "APPLICATION_CONTEXT_NULL_ERROR", "", "getAPPLICATION_CONTEXT_NULL_ERROR$dd_sdk_android_session_replay_release$annotations", "MASK_ALL_CONTENT_LABEL", "getMASK_ALL_CONTENT_LABEL$dd_sdk_android_session_replay_release$annotations", "MASK_CONTEXTUAL_CONTENT_LABEL", "getMASK_CONTEXTUAL_CONTENT_LABEL$dd_sdk_android_session_replay_release$annotations", "RESOURCES_NULL_ERROR", "getRESOURCES_NULL_ERROR$dd_sdk_android_session_replay_release$annotations", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMASK_CONTEXTUAL_CONTENT_LABEL$dd_sdk_android_session_replay_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMASK_ALL_CONTENT_LABEL$dd_sdk_android_session_replay_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getAPPLICATION_CONTEXT_NULL_ERROR$dd_sdk_android_session_replay_release$annotations() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getRESOURCES_NULL_ERROR$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$CompoundDrawablePositions;", "", "(Ljava/lang/String;I)V", "LEFT", "TOP", "RIGHT", "BOTTOM", "dd-sdk-android-session-replay_release"})
    public static final class CompoundDrawablePositions
    extends Enum<CompoundDrawablePositions> {
        public static final /* enum */ CompoundDrawablePositions LEFT = new CompoundDrawablePositions();
        public static final /* enum */ CompoundDrawablePositions TOP = new CompoundDrawablePositions();
        public static final /* enum */ CompoundDrawablePositions RIGHT = new CompoundDrawablePositions();
        public static final /* enum */ CompoundDrawablePositions BOTTOM = new CompoundDrawablePositions();
        private static final /* synthetic */ CompoundDrawablePositions[] $VALUES;

        public static CompoundDrawablePositions[] values() {
            return (CompoundDrawablePositions[])$VALUES.clone();
        }

        public static CompoundDrawablePositions valueOf(String value) {
            return Enum.valueOf(CompoundDrawablePositions.class, value);
        }

        static {
            $VALUES = compoundDrawablePositionsArray = new CompoundDrawablePositions[]{CompoundDrawablePositions.LEFT, CompoundDrawablePositions.TOP, CompoundDrawablePositions.RIGHT, CompoundDrawablePositions.BOTTOM};
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0012J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/DefaultImageWireframeHelper$DrawableProperties;", "", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableWidth", "", "drawableHeight", "(Landroid/graphics/drawable/Drawable;II)V", "getDrawable", "()Landroid/graphics/drawable/Drawable;", "getDrawableHeight", "()I", "getDrawableWidth", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "isValid", "toString", "", "dd-sdk-android-session-replay_release"})
    private static final class DrawableProperties {
        @NotNull
        private final Drawable drawable;
        private final int drawableWidth;
        private final int drawableHeight;

        public DrawableProperties(@NotNull Drawable drawable, int drawableWidth, int drawableHeight) {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            this.drawable = drawable;
            this.drawableWidth = drawableWidth;
            this.drawableHeight = drawableHeight;
        }

        @NotNull
        public final Drawable getDrawable() {
            return this.drawable;
        }

        public final int getDrawableWidth() {
            return this.drawableWidth;
        }

        public final int getDrawableHeight() {
            return this.drawableHeight;
        }

        public final boolean isValid() {
            return this.drawableWidth > 0 && this.drawableHeight > 0;
        }

        @NotNull
        public final Drawable component1() {
            return this.drawable;
        }

        public final int component2() {
            return this.drawableWidth;
        }

        public final int component3() {
            return this.drawableHeight;
        }

        @NotNull
        public final DrawableProperties copy(@NotNull Drawable drawable, int drawableWidth, int drawableHeight) {
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            return new DrawableProperties(drawable, drawableWidth, drawableHeight);
        }

        public static /* synthetic */ DrawableProperties copy$default(DrawableProperties drawableProperties, Drawable drawable, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                drawable = drawableProperties.drawable;
            }
            if ((n3 & 2) != 0) {
                n = drawableProperties.drawableWidth;
            }
            if ((n3 & 4) != 0) {
                n2 = drawableProperties.drawableHeight;
            }
            return drawableProperties.copy(drawable, n, n2);
        }

        @NotNull
        public String toString() {
            return "DrawableProperties(drawable=" + this.drawable + ", drawableWidth=" + this.drawableWidth + ", drawableHeight=" + this.drawableHeight + ")";
        }

        public int hashCode() {
            int result2 = this.drawable.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.drawableWidth);
            result2 = result2 * 31 + Integer.hashCode(this.drawableHeight);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DrawableProperties)) {
                return false;
            }
            DrawableProperties drawableProperties = (DrawableProperties)other;
            if (!Intrinsics.areEqual((Object)this.drawable, (Object)drawableProperties.drawable)) {
                return false;
            }
            if (this.drawableWidth != drawableProperties.drawableWidth) {
                return false;
            }
            return this.drawableHeight == drawableProperties.drawableHeight;
        }
    }
}

