/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.VisibleForTesting;
import com.datadog.android.internal.utils.IntExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\u000e"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageTypeResolver;", "", "()V", "isDrawablePII", "", "drawable", "Landroid/graphics/drawable/Drawable;", "density", "", "isPIIByDimensions", "width", "", "height", "Companion", "dd-sdk-android-session-replay_release"})
public final class ImageTypeResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int IMAGE_DIMEN_CONSIDERED_PII_IN_DP = 100;

    public final boolean isDrawablePII(@NotNull Drawable drawable, float density) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        boolean isNotGradient = !(drawable instanceof GradientDrawable);
        int widthDp = IntExtKt.densityNormalized((int)drawable.getIntrinsicWidth(), (float)density);
        int heightDp = IntExtKt.densityNormalized((int)drawable.getIntrinsicHeight(), (float)density);
        return isNotGradient && this.isPIIByDimensions(widthDp, heightDp);
    }

    public final boolean isPIIByDimensions(int width, int height) {
        boolean isGreaterThan = width >= 100 || height >= 100;
        return isGreaterThan;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageTypeResolver$Companion;", "", "()V", "IMAGE_DIMEN_CONSIDERED_PII_IN_DP", "", "getIMAGE_DIMEN_CONSIDERED_PII_IN_DP$dd_sdk_android_session_replay_release$annotations", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getIMAGE_DIMEN_CONSIDERED_PII_IN_DP$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

