/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.ByteArrayExtKt;
import com.datadog.android.sessionreplay.internal.recorder.resources.HashGenerator;
import com.datadog.android.sessionreplay.internal.recorder.resources.MD5HashGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/MD5HashGenerator;", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/HashGenerator;", "logger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "generate", "", "input", "", "Companion", "dd-sdk-android-session-replay_release"})
public final class MD5HashGenerator
implements HashGenerator {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private static final String MD5_HASH_GENERATION_ERROR = "Cannot generate MD5 hash.";

    public MD5HashGenerator(@NotNull InternalLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    @Nullable
    public String generate(@NotNull byte[] input) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(input);
            byte[] hashBytes = messageDigest.digest();
            Intrinsics.checkNotNullExpressionValue((Object)hashBytes, (String)"hashBytes");
            string = ByteArrayExtKt.toHexString((byte[])hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)generate.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            string = null;
        }
        return string;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/MD5HashGenerator$Companion;", "", "()V", "MD5_HASH_GENERATION_ERROR", "", "dd-sdk-android-session-replay_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

