/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import androidx.annotation.VisibleForTesting;
import com.datadog.android.sessionreplay.internal.async.DataQueueHandler;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001d\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceItemCreationHandler;", "", "recordedDataQueueHandler", "Lcom/datadog/android/sessionreplay/internal/async/DataQueueHandler;", "applicationId", "", "(Lcom/datadog/android/sessionreplay/internal/async/DataQueueHandler;Ljava/lang/String;)V", "resourceIdsSeen", "", "getResourceIdsSeen$dd_sdk_android_session_replay_release$annotations", "()V", "getResourceIdsSeen$dd_sdk_android_session_replay_release", "()Ljava/util/Set;", "queueItem", "", "resourceId", "resourceData", "", "queueItem$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
public final class ResourceItemCreationHandler {
    @NotNull
    private final DataQueueHandler recordedDataQueueHandler;
    @NotNull
    private final String applicationId;
    @NotNull
    private final Set<String> resourceIdsSeen;

    public ResourceItemCreationHandler(@NotNull DataQueueHandler recordedDataQueueHandler, @NotNull String applicationId) {
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueHandler, (String)"recordedDataQueueHandler");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        this.recordedDataQueueHandler = recordedDataQueueHandler;
        this.applicationId = applicationId;
        Set set = Collections.synchronizedSet(new HashSet());
        Intrinsics.checkNotNullExpressionValue(set, (String)"synchronizedSet(HashSet<String>())");
        this.resourceIdsSeen = set;
    }

    @NotNull
    public final Set<String> getResourceIdsSeen$dd_sdk_android_session_replay_release() {
        return this.resourceIdsSeen;
    }

    @VisibleForTesting
    public static /* synthetic */ void getResourceIdsSeen$dd_sdk_android_session_replay_release$annotations() {
    }

    public final void queueItem$dd_sdk_android_session_replay_release(@NotNull String resourceId, @NotNull byte[] resourceData) {
        Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
        Intrinsics.checkNotNullParameter((Object)resourceData, (String)"resourceData");
        if (!this.resourceIdsSeen.contains(resourceId)) {
            this.resourceIdsSeen.add(resourceId);
            DataQueueHandler dataQueueHandler = this.recordedDataQueueHandler;
            String string = this.applicationId;
            dataQueueHandler.addResourceItem(resourceId, string, resourceData);
        }
    }
}

