/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Path;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.sessionreplay.internal.async.DataQueueHandler;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapCachesManager;
import com.datadog.android.sessionreplay.internal.recorder.resources.ImageCompression;
import com.datadog.android.sessionreplay.internal.recorder.resources.MD5HashGenerator;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResolveResourceCallback;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceItemCreationHandler;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceResolverCallback;
import com.datadog.android.sessionreplay.internal.utils.DrawableUtils;
import com.datadog.android.sessionreplay.internal.utils.PathUtils;
import com.datadog.android.sessionreplay.recorder.resources.DrawableCopier;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 O2\u00020\u0001:\u0002NOBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J4\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\b\u0010 \u001a\u0004\u0018\u00010\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J,\u0010#\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0003JL\u0010&\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0003J\u0014\u0010.\u001a\u0004\u0018\u00010\u00132\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010/\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0003J\u0018\u00102\u001a\u00020\u001a2\u0006\u00103\u001a\u0002042\u0006\u0010$\u001a\u00020%H\u0003J<\u00105\u001a\u00020\u001a2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00103\u001a\u0002042\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0003J\u001d\u00106\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b7JW\u00108\u001a\u00020\u001a2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<2\u0006\u0010+\u001a\u00020,2\u0006\u0010=\u001a\u00020\"2\u0006\u0010>\u001a\u00020?2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\b@JG\u0010A\u001a\u00020\u001a2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020)2\u0006\u0010E\u001a\u00020)2\u0006\u0010F\u001a\u00020)2\u0006\u0010G\u001a\u00020)2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u00100\u001a\u000201H\u0001\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020JH\u0002JB\u0010K\u001a\u00020\u001a2\u0006\u0010=\u001a\u00020\"2\u0006\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020,2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0003J,\u0010L\u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\"2\u0006\u0010-\u001a\u00020\u001e2\b\u0010 \u001a\u0004\u0018\u00010\u00132\u0006\u0010$\u001a\u00020%H\u0003J\u001e\u0010M\u001a\u0004\u0018\u00010\u00132\b\u0010!\u001a\u0004\u0018\u00010\"2\b\u0010 \u001a\u0004\u0018\u00010\u0013H\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver;", "", "bitmapCachesManager", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;", "pathUtils", "Lcom/datadog/android/sessionreplay/internal/utils/PathUtils;", "threadPoolExecutor", "Ljava/util/concurrent/ExecutorService;", "drawableUtils", "Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils;", "webPImageCompression", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageCompression;", "logger", "Lcom/datadog/android/api/InternalLogger;", "md5HashGenerator", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/MD5HashGenerator;", "recordedDataQueueHandler", "Lcom/datadog/android/sessionreplay/internal/async/DataQueueHandler;", "applicationId", "", "resourceItemCreationHandler", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceItemCreationHandler;", "(Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;Lcom/datadog/android/sessionreplay/internal/utils/PathUtils;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils;Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageCompression;Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/recorder/resources/MD5HashGenerator;Lcom/datadog/android/sessionreplay/internal/async/DataQueueHandler;Ljava/lang/String;Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceItemCreationHandler;)V", "getThreadPoolExecutor$dd_sdk_android_session_replay_release", "()Ljava/util/concurrent/ExecutorService;", "cacheIfNecessary", "", "shouldCacheBitmap", "", "bitmap", "Landroid/graphics/Bitmap;", "resourceId", "customResourceIdCacheKey", "drawable", "Landroid/graphics/drawable/Drawable;", "compressAndCacheBitmap", "resolveResourceCallback", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResolveResourceCallback;", "createBitmapFromDrawable", "copiedDrawable", "drawableWidth", "", "drawableHeight", "displayMetrics", "Landroid/util/DisplayMetrics;", "bitmapFromDrawable", "generateKey", "getResourceIdFromBitmap", "resourceResolverCallback", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolverCallback;", "resolveBitmapHash", "compressedBitmapBytes", "", "resolveResourceHash", "resolveResourceIdFromBitmap", "resolveResourceIdFromBitmap$dd_sdk_android_session_replay_release", "resolveResourceIdFromDrawable", "resources", "Landroid/content/res/Resources;", "applicationContext", "Landroid/content/Context;", "originalDrawable", "drawableCopier", "Lcom/datadog/android/sessionreplay/recorder/resources/DrawableCopier;", "resolveResourceIdFromDrawable$dd_sdk_android_session_replay_release", "resolveResourceIdFromPath", "path", "Landroid/graphics/Path;", "strokeColor", "strokeWidth", "desiredWidth", "desiredHeight", "resolveResourceIdFromPath$dd_sdk_android_session_replay_release", "shouldUseDrawableBitmap", "Landroid/graphics/drawable/BitmapDrawable;", "tryToDrawNewBitmap", "tryToGetBitmapFromBitmapDrawable", "tryToGetResourceFromCache", "BitmapCreationCallback", "Companion", "dd-sdk-android-session-replay_release"})
public final class ResourceResolver {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final BitmapCachesManager bitmapCachesManager;
    @NotNull
    private final PathUtils pathUtils;
    @NotNull
    private final ExecutorService threadPoolExecutor;
    @NotNull
    private final DrawableUtils drawableUtils;
    @NotNull
    private final ImageCompression webPImageCompression;
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private final MD5HashGenerator md5HashGenerator;
    @NotNull
    private final DataQueueHandler recordedDataQueueHandler;
    @NotNull
    private final String applicationId;
    @NotNull
    private final ResourceItemCreationHandler resourceItemCreationHandler;
    private static final long THREAD_POOL_MAX_KEEP_ALIVE_MS = 5000L;
    private static final int CORE_DEFAULT_POOL_SIZE = 1;
    private static final int MAX_THREAD_COUNT = 10;
    @NotNull
    private static final String RESOURCE_RESOLVER_ALIAS = "resolveResourceId";
    @NotNull
    private static final ThreadPoolExecutor THREADPOOL_EXECUTOR = new ThreadPoolExecutor(1, 10, 5000L, TimeUnit.MILLISECONDS, new LinkedBlockingDeque());

    public ResourceResolver(@NotNull BitmapCachesManager bitmapCachesManager, @NotNull PathUtils pathUtils, @NotNull ExecutorService threadPoolExecutor, @NotNull DrawableUtils drawableUtils, @NotNull ImageCompression webPImageCompression, @NotNull InternalLogger logger, @NotNull MD5HashGenerator md5HashGenerator, @NotNull DataQueueHandler recordedDataQueueHandler, @NotNull String applicationId, @NotNull ResourceItemCreationHandler resourceItemCreationHandler) {
        Intrinsics.checkNotNullParameter((Object)bitmapCachesManager, (String)"bitmapCachesManager");
        Intrinsics.checkNotNullParameter((Object)pathUtils, (String)"pathUtils");
        Intrinsics.checkNotNullParameter((Object)threadPoolExecutor, (String)"threadPoolExecutor");
        Intrinsics.checkNotNullParameter((Object)drawableUtils, (String)"drawableUtils");
        Intrinsics.checkNotNullParameter((Object)webPImageCompression, (String)"webPImageCompression");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)md5HashGenerator, (String)"md5HashGenerator");
        Intrinsics.checkNotNullParameter((Object)recordedDataQueueHandler, (String)"recordedDataQueueHandler");
        Intrinsics.checkNotNullParameter((Object)applicationId, (String)"applicationId");
        Intrinsics.checkNotNullParameter((Object)resourceItemCreationHandler, (String)"resourceItemCreationHandler");
        this.bitmapCachesManager = bitmapCachesManager;
        this.pathUtils = pathUtils;
        this.threadPoolExecutor = threadPoolExecutor;
        this.drawableUtils = drawableUtils;
        this.webPImageCompression = webPImageCompression;
        this.logger = logger;
        this.md5HashGenerator = md5HashGenerator;
        this.recordedDataQueueHandler = recordedDataQueueHandler;
        this.applicationId = applicationId;
        this.resourceItemCreationHandler = resourceItemCreationHandler;
    }

    public /* synthetic */ ResourceResolver(BitmapCachesManager bitmapCachesManager, PathUtils pathUtils, ExecutorService executorService, DrawableUtils drawableUtils, ImageCompression imageCompression, InternalLogger internalLogger, MD5HashGenerator mD5HashGenerator, DataQueueHandler dataQueueHandler, String string, ResourceItemCreationHandler resourceItemCreationHandler, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            executorService = THREADPOOL_EXECUTOR;
        }
        if ((n & 0x200) != 0) {
            resourceItemCreationHandler = new ResourceItemCreationHandler(dataQueueHandler, string);
        }
        this(bitmapCachesManager, pathUtils, executorService, drawableUtils, imageCompression, internalLogger, mD5HashGenerator, dataQueueHandler, string, resourceItemCreationHandler);
    }

    @NotNull
    public final ExecutorService getThreadPoolExecutor$dd_sdk_android_session_replay_release() {
        return this.threadPoolExecutor;
    }

    @MainThread
    public final void resolveResourceIdFromBitmap$dd_sdk_android_session_replay_release(@NotNull Bitmap bitmap, @NotNull ResourceResolverCallback resourceResolverCallback) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Intrinsics.checkNotNullParameter((Object)resourceResolverCallback, (String)"resourceResolverCallback");
        ConcurrencyExtKt.executeSafe((Executor)this.threadPoolExecutor, (String)RESOURCE_RESOLVER_ALIAS, (InternalLogger)this.logger, () -> ResourceResolver.resolveResourceIdFromBitmap$lambda$0(this, bitmap, resourceResolverCallback));
    }

    @MainThread
    public final void resolveResourceIdFromPath$dd_sdk_android_session_replay_release(@NotNull Path path, int strokeColor, int strokeWidth, int desiredWidth, int desiredHeight, @Nullable String customResourceIdCacheKey, @NotNull ResourceResolverCallback resourceResolverCallback) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)resourceResolverCallback, (String)"resourceResolverCallback");
        ConcurrencyExtKt.executeSafe((Executor)this.threadPoolExecutor, (String)RESOURCE_RESOLVER_ALIAS, (InternalLogger)this.logger, () -> ResourceResolver.resolveResourceIdFromPath$lambda$2(customResourceIdCacheKey, path, this, resourceResolverCallback, strokeColor, desiredWidth, desiredHeight, strokeWidth));
    }

    @MainThread
    public final void resolveResourceIdFromDrawable$dd_sdk_android_session_replay_release(@NotNull Resources resources, @NotNull Context applicationContext, @NotNull DisplayMetrics displayMetrics, @NotNull Drawable originalDrawable, @NotNull DrawableCopier drawableCopier, int drawableWidth, int drawableHeight, @Nullable String customResourceIdCacheKey, @NotNull ResourceResolverCallback resourceResolverCallback) {
        Intrinsics.checkNotNullParameter((Object)resources, (String)"resources");
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkNotNullParameter((Object)originalDrawable, (String)"originalDrawable");
        Intrinsics.checkNotNullParameter((Object)drawableCopier, (String)"drawableCopier");
        Intrinsics.checkNotNullParameter((Object)resourceResolverCallback, (String)"resourceResolverCallback");
        this.bitmapCachesManager.registerCallbacks$dd_sdk_android_session_replay_release(applicationContext);
        String resourceId = this.tryToGetResourceFromCache(originalDrawable, customResourceIdCacheKey);
        if (resourceId != null) {
            resourceResolverCallback.onSuccess(resourceId);
            return;
        }
        Drawable copiedDrawable = drawableCopier.copy(originalDrawable, resources);
        if (copiedDrawable == null) {
            resourceResolverCallback.onFailure();
            return;
        }
        Bitmap bitmapFromDrawable = copiedDrawable instanceof BitmapDrawable && this.shouldUseDrawableBitmap((BitmapDrawable)copiedDrawable) ? ((BitmapDrawable)copiedDrawable).getBitmap() : null;
        ConcurrencyExtKt.executeSafe((Executor)this.threadPoolExecutor, (String)RESOURCE_RESOLVER_ALIAS, (InternalLogger)this.logger, () -> ResourceResolver.resolveResourceIdFromDrawable$lambda$3(this, originalDrawable, copiedDrawable, drawableWidth, drawableHeight, displayMetrics, bitmapFromDrawable, customResourceIdCacheKey, resourceResolverCallback));
    }

    @WorkerThread
    private final void createBitmapFromDrawable(Drawable drawable, Drawable copiedDrawable, int drawableWidth, int drawableHeight, DisplayMetrics displayMetrics, Bitmap bitmapFromDrawable, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        Bitmap handledBitmap;
        Bitmap bitmap = handledBitmap = bitmapFromDrawable != null ? this.tryToGetBitmapFromBitmapDrawable(drawable, bitmapFromDrawable, customResourceIdCacheKey, resolveResourceCallback) : null;
        if (handledBitmap == null) {
            this.tryToDrawNewBitmap(drawable, copiedDrawable, drawableWidth, drawableHeight, displayMetrics, customResourceIdCacheKey, resolveResourceCallback);
        }
    }

    @WorkerThread
    private final void resolveBitmapHash(byte[] compressedBitmapBytes, ResolveResourceCallback resolveResourceCallback) {
        if (compressedBitmapBytes.length == 0) {
            resolveResourceCallback.onFailed();
            return;
        }
        String resourceId = this.md5HashGenerator.generate(compressedBitmapBytes);
        if (resourceId == null) {
            resolveResourceCallback.onFailed();
            return;
        }
        resolveResourceCallback.onResolved(resourceId, compressedBitmapBytes);
    }

    @WorkerThread
    private final void resolveResourceHash(Drawable drawable, Bitmap bitmap, byte[] compressedBitmapBytes, boolean shouldCacheBitmap, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        if (compressedBitmapBytes.length == 0) {
            resolveResourceCallback.onFailed();
            return;
        }
        String resourceId = this.md5HashGenerator.generate(compressedBitmapBytes);
        if (resourceId == null) {
            resolveResourceCallback.onFailed();
            return;
        }
        this.cacheIfNecessary(shouldCacheBitmap, bitmap, resourceId, customResourceIdCacheKey, drawable);
        resolveResourceCallback.onResolved(resourceId, compressedBitmapBytes);
    }

    private final void cacheIfNecessary(boolean shouldCacheBitmap, Bitmap bitmap, String resourceId, String customResourceIdCacheKey, Drawable drawable) {
        String string;
        if (shouldCacheBitmap) {
            this.bitmapCachesManager.putInBitmapPool$dd_sdk_android_session_replay_release(bitmap);
        }
        if ((string = customResourceIdCacheKey) == null && (string = this.generateKey(drawable)) == null) {
            return;
        }
        String key = string;
        this.bitmapCachesManager.putInResourceCache$dd_sdk_android_session_replay_release(key, resourceId);
    }

    @WorkerThread
    private final void tryToDrawNewBitmap(Drawable originalDrawable, Drawable copiedDrawable, int drawableWidth, int drawableHeight, DisplayMetrics displayMetrics, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        DrawableUtils.createBitmapOfApproxSizeFromDrawable$dd_sdk_android_session_replay_release$default(this.drawableUtils, copiedDrawable, drawableWidth, drawableHeight, displayMetrics, 0, null, new BitmapCreationCallback(this, originalDrawable, customResourceIdCacheKey, resolveResourceCallback){
            final /* synthetic */ ResourceResolver this$0;
            final /* synthetic */ Drawable $originalDrawable;
            final /* synthetic */ String $customResourceIdCacheKey;
            final /* synthetic */ ResolveResourceCallback $resolveResourceCallback;
            {
                this.this$0 = $receiver;
                this.$originalDrawable = $originalDrawable;
                this.$customResourceIdCacheKey = $customResourceIdCacheKey;
                this.$resolveResourceCallback = $resolveResourceCallback;
            }

            @WorkerThread
            public void onReady(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                ResourceResolver.access$compressAndCacheBitmap(this.this$0, this.$originalDrawable, bitmap, this.$customResourceIdCacheKey, this.$resolveResourceCallback);
            }

            @WorkerThread
            public void onFailure() {
                this.$resolveResourceCallback.onFailed();
            }
        }, 48, null);
    }

    @WorkerThread
    private final void compressAndCacheBitmap(Drawable drawable, Bitmap bitmap, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        byte[] compressedBitmapBytes = this.webPImageCompression.compressBitmap(bitmap);
        if (compressedBitmapBytes.length == 0) {
            resolveResourceCallback.onFailed();
            return;
        }
        this.resolveResourceHash(drawable, bitmap, compressedBitmapBytes, true, customResourceIdCacheKey, resolveResourceCallback);
    }

    @WorkerThread
    private final void getResourceIdFromBitmap(Bitmap bitmap, ResourceResolverCallback resourceResolverCallback) {
        byte[] compressedBitmapBytes = this.webPImageCompression.compressBitmap(bitmap);
        if (compressedBitmapBytes.length == 0) {
            resourceResolverCallback.onFailure();
            return;
        }
        this.resolveBitmapHash(compressedBitmapBytes, new ResolveResourceCallback(this, resourceResolverCallback){
            final /* synthetic */ ResourceResolver this$0;
            final /* synthetic */ ResourceResolverCallback $resourceResolverCallback;
            {
                this.this$0 = $receiver;
                this.$resourceResolverCallback = $resourceResolverCallback;
            }

            public void onResolved(@NotNull String resourceId, @NotNull byte[] resourceData) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                Intrinsics.checkNotNullParameter((Object)resourceData, (String)"resourceData");
                ResourceResolver.access$getResourceItemCreationHandler$p(this.this$0).queueItem$dd_sdk_android_session_replay_release(resourceId, resourceData);
                this.$resourceResolverCallback.onSuccess(resourceId);
            }

            public void onFailed() {
                this.$resourceResolverCallback.onFailure();
            }
        });
    }

    @WorkerThread
    private final Bitmap tryToGetBitmapFromBitmapDrawable(Drawable drawable, Bitmap bitmapFromDrawable, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        Bitmap bitmap = DrawableUtils.createScaledBitmap$dd_sdk_android_session_replay_release$default(this.drawableUtils, bitmapFromDrawable, 0, 2, null);
        if (bitmap == null) {
            return null;
        }
        Bitmap scaledBitmap = bitmap;
        byte[] compressedBitmapBytes = this.webPImageCompression.compressBitmap(scaledBitmap);
        if (compressedBitmapBytes.length == 0) {
            return null;
        }
        boolean shouldCacheBitmap = !bitmapFromDrawable.isRecycled() && (scaledBitmap.getWidth() < bitmapFromDrawable.getWidth() || scaledBitmap.getHeight() < bitmapFromDrawable.getHeight());
        this.resolveResourceHash(drawable, scaledBitmap, compressedBitmapBytes, shouldCacheBitmap, customResourceIdCacheKey, resolveResourceCallback);
        return scaledBitmap;
    }

    private final String tryToGetResourceFromCache(Drawable drawable, String customResourceIdCacheKey) {
        String string = customResourceIdCacheKey;
        if (string == null && (string = this.generateKey(drawable)) == null) {
            return null;
        }
        String key = string;
        return this.bitmapCachesManager.getFromResourceCache$dd_sdk_android_session_replay_release(key);
    }

    private final String generateKey(Drawable drawable) {
        return drawable != null ? this.bitmapCachesManager.generateResourceKeyFromDrawable$dd_sdk_android_session_replay_release(drawable) : null;
    }

    private final boolean shouldUseDrawableBitmap(BitmapDrawable drawable) {
        return drawable.getBitmap() != null && !drawable.getBitmap().isRecycled() && drawable.getBitmap().getWidth() > 0 && drawable.getBitmap().getHeight() > 0;
    }

    private static final void resolveResourceIdFromBitmap$lambda$0(ResourceResolver this$0, Bitmap $bitmap, ResourceResolverCallback $resourceResolverCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
        Intrinsics.checkNotNullParameter((Object)$resourceResolverCallback, (String)"$resourceResolverCallback");
        this$0.getResourceIdFromBitmap($bitmap, $resourceResolverCallback);
    }

    private static final void resolveResourceIdFromPath$lambda$2(String $customResourceIdCacheKey, Path $path, ResourceResolver this$0, ResourceResolverCallback $resourceResolverCallback, int $strokeColor, int $desiredWidth, int $desiredHeight, int $strokeWidth) {
        String key;
        String resourceId;
        Intrinsics.checkNotNullParameter((Object)$path, (String)"$path");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$resourceResolverCallback, (String)"$resourceResolverCallback");
        String string = $customResourceIdCacheKey;
        if (string == null) {
            Path it = $path;
            boolean bl = false;
            string = PathUtils.generateKeyForPath$dd_sdk_android_session_replay_release$default(this$0.pathUtils, it, 0, 0.0f, null, 14, null);
        }
        if ((resourceId = this$0.tryToGetResourceFromCache(null, key = string)) != null) {
            $resourceResolverCallback.onSuccess(resourceId);
            return;
        }
        Bitmap bitmap = this$0.pathUtils.convertPathToBitmap$dd_sdk_android_session_replay_release($path, $strokeColor, $desiredWidth, $desiredHeight, $strokeWidth);
        if (bitmap == null) {
            $resourceResolverCallback.onFailure();
            return;
        }
        this$0.compressAndCacheBitmap(null, bitmap, $customResourceIdCacheKey, new ResolveResourceCallback(this$0, $resourceResolverCallback){
            final /* synthetic */ ResourceResolver this$0;
            final /* synthetic */ ResourceResolverCallback $resourceResolverCallback;
            {
                this.this$0 = $receiver;
                this.$resourceResolverCallback = $resourceResolverCallback;
            }

            public void onResolved(@NotNull String resourceId, @NotNull byte[] resourceData) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                Intrinsics.checkNotNullParameter((Object)resourceData, (String)"resourceData");
                ResourceResolver.access$getResourceItemCreationHandler$p(this.this$0).queueItem$dd_sdk_android_session_replay_release(resourceId, resourceData);
                this.$resourceResolverCallback.onSuccess(resourceId);
            }

            public void onFailed() {
                this.$resourceResolverCallback.onFailure();
            }
        });
    }

    private static final void resolveResourceIdFromDrawable$lambda$3(ResourceResolver this$0, Drawable $originalDrawable, Drawable $copiedDrawable, int $drawableWidth, int $drawableHeight, DisplayMetrics $displayMetrics, Bitmap $bitmapFromDrawable, String $customResourceIdCacheKey, ResourceResolverCallback $resourceResolverCallback) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$originalDrawable, (String)"$originalDrawable");
        Intrinsics.checkNotNullParameter((Object)$displayMetrics, (String)"$displayMetrics");
        Intrinsics.checkNotNullParameter((Object)$resourceResolverCallback, (String)"$resourceResolverCallback");
        this$0.createBitmapFromDrawable($originalDrawable, $copiedDrawable, $drawableWidth, $drawableHeight, $displayMetrics, $bitmapFromDrawable, $customResourceIdCacheKey, new ResolveResourceCallback(this$0, $resourceResolverCallback){
            final /* synthetic */ ResourceResolver this$0;
            final /* synthetic */ ResourceResolverCallback $resourceResolverCallback;
            {
                this.this$0 = $receiver;
                this.$resourceResolverCallback = $resourceResolverCallback;
            }

            public void onResolved(@NotNull String resourceId, @NotNull byte[] resourceData) {
                Intrinsics.checkNotNullParameter((Object)resourceId, (String)"resourceId");
                Intrinsics.checkNotNullParameter((Object)resourceData, (String)"resourceData");
                ResourceResolver.access$getResourceItemCreationHandler$p(this.this$0).queueItem$dd_sdk_android_session_replay_release(resourceId, resourceData);
                this.$resourceResolverCallback.onSuccess(resourceId);
            }

            public void onFailed() {
                this.$resourceResolverCallback.onFailure();
            }
        });
    }

    public static final /* synthetic */ void access$compressAndCacheBitmap(ResourceResolver $this, Drawable drawable, Bitmap bitmap, String customResourceIdCacheKey, ResolveResourceCallback resolveResourceCallback) {
        $this.compressAndCacheBitmap(drawable, bitmap, customResourceIdCacheKey, resolveResourceCallback);
    }

    public static final /* synthetic */ ResourceItemCreationHandler access$getResourceItemCreationHandler$p(ResourceResolver $this) {
        return $this.resourceItemCreationHandler;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver$BitmapCreationCallback;", "", "onFailure", "", "onReady", "bitmap", "Landroid/graphics/Bitmap;", "dd-sdk-android-session-replay_release"})
    public static interface BitmapCreationCallback {
        @WorkerThread
        public void onReady(@NotNull Bitmap var1);

        @WorkerThread
        public void onFailure();
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver$Companion;", "", "()V", "CORE_DEFAULT_POOL_SIZE", "", "MAX_THREAD_COUNT", "RESOURCE_RESOLVER_ALIAS", "", "THREADPOOL_EXECUTOR", "Ljava/util/concurrent/ThreadPoolExecutor;", "getTHREADPOOL_EXECUTOR$annotations", "THREAD_POOL_MAX_KEEP_ALIVE_MS", "", "dd-sdk-android-session-replay_release"})
    private static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getTHREADPOOL_EXECUTOR$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

