/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.graphics.drawable.AnimationDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableContainer;
import android.graphics.drawable.LayerDrawable;
import androidx.collection.LruCache;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.recorder.LayerDrawableExtKt;
import com.datadog.android.sessionreplay.internal.recorder.resources.Cache;
import com.datadog.android.sessionreplay.internal.utils.CacheUtils;
import com.datadog.android.sessionreplay.internal.utils.InvocationUtils;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 $2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004:\u0001$B;\u0012\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0011J\u0010\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0015\u001a\u00020\u0002H\u0016J\u0010\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0018\u0010!\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0003H\u0016J\b\u0010#\u001a\u00020 H\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourcesLRUCache;", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/Cache;", "", "", "Landroid/content/ComponentCallbacks2;", "cacheUtils", "Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils;", "invocationUtils", "Lcom/datadog/android/sessionreplay/internal/utils/InvocationUtils;", "cache", "Landroidx/collection/LruCache;", "(Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils;Lcom/datadog/android/sessionreplay/internal/utils/InvocationUtils;Landroidx/collection/LruCache;)V", "clear", "", "generateKeyFromDrawable", "element", "Landroid/graphics/drawable/Drawable;", "generateKeyFromDrawable$dd_sdk_android_session_replay_release", "generatePrefix", "drawable", "get", "key", "getPrefixForDrawableContainer", "Landroid/graphics/drawable/DrawableContainer;", "getPrefixForLayerDrawable", "Landroid/graphics/drawable/LayerDrawable;", "onConfigurationChanged", "newConfig", "Landroid/content/res/Configuration;", "onLowMemory", "onTrimMemory", "level", "", "put", "value", "size", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nResourcesLRUCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourcesLRUCache.kt\ncom/datadog/android/sessionreplay/internal/recorder/resources/ResourcesLRUCache\n+ 2 InvocationUtils.kt\ncom/datadog/android/sessionreplay/internal/utils/InvocationUtils\n*L\n1#1,115:1\n13#2,21:116\n13#2,21:137\n13#2,21:158\n13#2,21:179\n*S KotlinDebug\n*F\n+ 1 ResourcesLRUCache.kt\ncom/datadog/android/sessionreplay/internal/recorder/resources/ResourcesLRUCache\n*L\n40#1:116,21\n49#1:137,21\n58#1:158,21\n70#1:179,21\n*E\n"})
public final class ResourcesLRUCache
implements Cache<String, byte[]>,
ComponentCallbacks2 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CacheUtils<String, byte[]> cacheUtils;
    @NotNull
    private final InvocationUtils invocationUtils;
    @NotNull
    private LruCache<String, byte[]> cache;
    private static final int MAX_CACHE_MEMORY_SIZE_BYTES = 0x400000;
    @NotNull
    private static final String FAILURE_MSG_EVICT_CACHE_CONTENTS = "Failed to evict cache entries";
    @NotNull
    private static final String FAILURE_MSG_PUT_CACHE = "Failed to put item in cache";
    @NotNull
    private static final String FAILURE_MSG_GET_CACHE = "Failed to get item from cache";

    public ResourcesLRUCache(@NotNull CacheUtils<String, byte[]> cacheUtils, @NotNull InvocationUtils invocationUtils, @NotNull LruCache<String, byte[]> cache) {
        Intrinsics.checkNotNullParameter(cacheUtils, (String)"cacheUtils");
        Intrinsics.checkNotNullParameter((Object)invocationUtils, (String)"invocationUtils");
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        this.cacheUtils = cacheUtils;
        this.invocationUtils = invocationUtils;
        this.cache = cache;
    }

    public /* synthetic */ ResourcesLRUCache(CacheUtils cacheUtils, InvocationUtils invocationUtils, LruCache lruCache, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            cacheUtils = new CacheUtils<String, byte[]>(null, 1, null);
        }
        if ((n & 2) != 0) {
            invocationUtils = new InvocationUtils();
        }
        if ((n & 4) != 0) {
            int n2 = Companion.getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release();
            lruCache = (LruCache)new LruCache<String, byte[]>(n2){

                protected int sizeOf(@NotNull String key, @NotNull byte[] value) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    return value.length;
                }
            };
        }
        this(cacheUtils, invocationUtils, (LruCache<String, byte[]>)lruCache);
    }

    public void onTrimMemory(int level) {
        this.cacheUtils.handleTrimMemory$dd_sdk_android_session_replay_release(level, this.cache);
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
    }

    public void onLowMemory() {
        InvocationUtils invocationUtils = this.invocationUtils;
        String failureMessage$iv = FAILURE_MSG_EVICT_CACHE_CONTENTS;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            this.cache.evictAll();
        }
        catch (Exception e$iv) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new Function0<String>(failureMessage$iv){
                final /* synthetic */ String $failureMessage;
                {
                    this.$failureMessage = $failureMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$failureMessage;
                }
            }), (Throwable)e$iv, (boolean)false, null, (int)48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void put(@NotNull String key, @NotNull byte[] value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        InvocationUtils invocationUtils = this.invocationUtils;
        String string = FAILURE_MSG_PUT_CACHE;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            byte[] cfr_ignored_0 = (byte[])this.cache.put((Object)key, (Object)value);
        }
        catch (Exception e$iv) {
            void failureMessage$iv;
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Throwable)e$iv, (boolean)false, null, (int)48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public synchronized byte[] get(@NotNull String key) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        InvocationUtils invocationUtils = this.invocationUtils;
        String string = FAILURE_MSG_GET_CACHE;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            byArray = (byte[])this.cache.get((Object)key);
        }
        catch (Exception e$iv) {
            void failureMessage$iv;
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Throwable)e$iv, (boolean)false, null, (int)48, null);
            byArray = null;
        }
        return byArray;
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public synchronized void clear() {
        InvocationUtils invocationUtils = this.invocationUtils;
        String failureMessage$iv = FAILURE_MSG_EVICT_CACHE_CONTENTS;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            this.cache.evictAll();
        }
        catch (Exception e$iv) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Throwable)e$iv, (boolean)false, null, (int)48, null);
        }
    }

    @NotNull
    public final String generateKeyFromDrawable$dd_sdk_android_session_replay_release(@NotNull Drawable element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return this.generatePrefix(element) + System.identityHashCode(element);
    }

    private final String generatePrefix(Drawable drawable) {
        Drawable drawable2 = drawable;
        return drawable2 instanceof DrawableContainer ? this.getPrefixForDrawableContainer((DrawableContainer)drawable) : (drawable2 instanceof LayerDrawable ? this.getPrefixForLayerDrawable((LayerDrawable)drawable) : "");
    }

    private final String getPrefixForDrawableContainer(DrawableContainer drawable) {
        if (!(drawable instanceof AnimationDrawable)) {
            int[] nArray = drawable.getState();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"drawable.state");
            return ArraysKt.joinToString$default((int[])nArray, (CharSequence)"", null, (CharSequence)"-", (int)0, null, null, (int)58, null);
        }
        return "";
    }

    private final String getPrefixForLayerDrawable(LayerDrawable drawable) {
        StringBuilder sb = new StringBuilder();
        int n = drawable.getNumberOfLayers();
        for (int index = 0; index < n; ++index) {
            Drawable layer = LayerDrawableExtKt.safeGetDrawable$default(drawable, index, null, 2, null);
            String layerHash = String.valueOf(System.identityHashCode(layer));
            sb.append(layerHash);
            sb.append("-");
        }
        return String.valueOf(sb);
    }

    @Override
    public void put(@NotNull byte[] value) {
        Cache.DefaultImpls.put(this, value);
    }

    public ResourcesLRUCache() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0080D\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourcesLRUCache$Companion;", "", "()V", "FAILURE_MSG_EVICT_CACHE_CONTENTS", "", "FAILURE_MSG_GET_CACHE", "FAILURE_MSG_PUT_CACHE", "MAX_CACHE_MEMORY_SIZE_BYTES", "", "getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release$annotations", "getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release", "()I", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public final int getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release() {
            return MAX_CACHE_MEMORY_SIZE_BYTES;
        }

        public static /* synthetic */ void getMAX_CACHE_MEMORY_SIZE_BYTES$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

