/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.recorder.resources;

import android.graphics.Bitmap;
import android.os.Build;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.recorder.resources.ImageCompression;
import com.datadog.android.sessionreplay.internal.recorder.resources.WebPImageCompression;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0017J\b\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/WebPImageCompression;", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ImageCompression;", "logger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "compressBitmap", "", "bitmap", "Landroid/graphics/Bitmap;", "getImageCompressionFormat", "Landroid/graphics/Bitmap$CompressFormat;", "Companion", "dd-sdk-android-session-replay_release"})
public final class WebPImageCompression
implements ImageCompression {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private static final byte[] EMPTY_BYTEARRAY = new byte[0];
    private static final int IMAGE_QUALITY = 75;
    @NotNull
    private static final String IMAGE_COMPRESSION_ERROR = "Error while compressing the image.";

    public WebPImageCompression(@NotNull InternalLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Override
    @WorkerThread
    @NotNull
    public byte[] compressBitmap(@NotNull Bitmap bitmap) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(bitmap.getAllocationByteCount());
        Bitmap.CompressFormat imageFormat = this.getImageCompressionFormat();
        try {
            bitmap.compress(imageFormat, 75, (OutputStream)byteArrayOutputStream);
        }
        catch (IllegalStateException e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.MAINTAINER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)compressBitmap.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            return EMPTY_BYTEARRAY;
        }
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteArrayOutputStream.toByteArray()");
        return byArray;
    }

    private final Bitmap.CompressFormat getImageCompressionFormat() {
        return Build.VERSION.SDK_INT >= 30 ? Bitmap.CompressFormat.WEBP_LOSSY : Bitmap.CompressFormat.WEBP;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/internal/recorder/resources/WebPImageCompression$Companion;", "", "()V", "EMPTY_BYTEARRAY", "", "IMAGE_COMPRESSION_ERROR", "", "IMAGE_QUALITY", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

