/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.resources;

import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.datastore.DataStoreHandler;
import com.datadog.android.api.storage.datastore.DataStoreReadCallback;
import com.datadog.android.api.storage.datastore.DataStoreWriteCallback;
import com.datadog.android.core.internal.persistence.Deserializer;
import com.datadog.android.core.persistence.Serializer;
import com.datadog.android.core.persistence.datastore.DataStoreContent;
import com.datadog.android.sessionreplay.model.ResourceHashesEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 02\u00020\u0001:\u00010B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\nJ\u0015\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0018J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002JA\u0010!\u001a\u00020\u00162)\u0010\"\u001a%\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0006\u0018\u00010$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00160#2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00160)H\u0002J\b\u0010*\u001a\u00020\u0016H\u0002J\u0015\u0010+\u001a\u00020\u001e2\u0006\u0010\u0017\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b,J\r\u0010-\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b.J\b\u0010/\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010\r\u001a&\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\t0\t \u000f*\u0012\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\t0\t\u0018\u00010\u00100\u000eX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager;", "", "featureSdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "resourceHashesSerializer", "Lcom/datadog/android/core/persistence/Serializer;", "Lcom/datadog/android/sessionreplay/model/ResourceHashesEntry;", "resourceHashesDeserializer", "Lcom/datadog/android/core/internal/persistence/Deserializer;", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/core/persistence/Serializer;Lcom/datadog/android/core/internal/persistence/Deserializer;)V", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "knownResources", "", "kotlin.jvm.PlatformType", "", "getKnownResources$annotations", "()V", "storedLastUpdateDateNs", "Ljava/util/concurrent/atomic/AtomicLong;", "cacheResourceHash", "", "resourceHash", "cacheResourceHash$dd_sdk_android_session_replay_release", "deleteStoredHashesEntry", "callback", "Lcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;", "(Lcom/datadog/android/api/storage/datastore/DataStoreWriteCallback;)Lkotlin/Unit;", "didDataStoreExpire", "", "lastUpdateDate", "", "fetchStoredResourceHashes", "onFetchSuccessful", "Lkotlin/Function1;", "Lcom/datadog/android/core/persistence/datastore/DataStoreContent;", "Lkotlin/ParameterName;", "name", "dataStoreContent", "onFetchFailure", "Lkotlin/Function0;", "finishedInitializingManager", "isPreviouslySentResource", "isPreviouslySentResource$dd_sdk_android_session_replay_release", "isReady", "isReady$dd_sdk_android_session_replay_release", "writeResourcesToStore", "Companion", "dd-sdk-android-session-replay_release"})
public final class ResourceDataStoreManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore featureSdkCore;
    @NotNull
    private final Serializer<ResourceHashesEntry> resourceHashesSerializer;
    @NotNull
    private final Deserializer<String, ResourceHashesEntry> resourceHashesDeserializer;
    private final Set<String> knownResources;
    @NotNull
    private AtomicLong storedLastUpdateDateNs;
    @NotNull
    private AtomicBoolean isInitialized;
    public static final long DATASTORE_EXPIRATION_NS = 2592000000000000L;
    @NotNull
    public static final String DATASTORE_HASHES_ENTRY_NAME = "resource-hash-store";

    public ResourceDataStoreManager(@NotNull FeatureSdkCore featureSdkCore, @NotNull Serializer<ResourceHashesEntry> resourceHashesSerializer, @NotNull Deserializer<String, ResourceHashesEntry> resourceHashesDeserializer) {
        Intrinsics.checkNotNullParameter((Object)featureSdkCore, (String)"featureSdkCore");
        Intrinsics.checkNotNullParameter(resourceHashesSerializer, (String)"resourceHashesSerializer");
        Intrinsics.checkNotNullParameter(resourceHashesDeserializer, (String)"resourceHashesDeserializer");
        this.featureSdkCore = featureSdkCore;
        this.resourceHashesSerializer = resourceHashesSerializer;
        this.resourceHashesDeserializer = resourceHashesDeserializer;
        this.knownResources = Collections.newSetFromMap(new ConcurrentHashMap());
        this.storedLastUpdateDateNs = new AtomicLong(System.nanoTime());
        this.isInitialized = new AtomicBoolean(false);
        this.fetchStoredResourceHashes((Function1<? super DataStoreContent<ResourceHashesEntry>, Unit>)((Function1)new Function1<DataStoreContent<ResourceHashesEntry>, Unit>(){

            public final void invoke(@Nullable DataStoreContent<ResourceHashesEntry> storedEntry) {
                ResourceHashesEntry storedData;
                DataStoreContent<ResourceHashesEntry> dataStoreContent = storedEntry;
                ResourceHashesEntry resourceHashesEntry = storedData = dataStoreContent != null ? (ResourceHashesEntry)dataStoreContent.getData() : null;
                if (storedData == null) {
                    this.finishedInitializingManager();
                    return;
                }
                long lastUpdateDateNs = storedData.getLastUpdateDateNs().longValue();
                List<String> storedHashes = storedData.getResourceHashes();
                if (this.didDataStoreExpire(lastUpdateDateNs)) {
                    this.deleteStoredHashesEntry(new DataStoreWriteCallback(){

                        public void onSuccess() {
                            this.finishedInitializingManager();
                        }

                        public void onFailure() {
                            this.finishedInitializingManager();
                        }
                    });
                } else {
                    storedLastUpdateDateNs.set(lastUpdateDateNs);
                    knownResources.addAll((Collection)storedHashes);
                    this.finishedInitializingManager();
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.finishedInitializingManager();
            }
        }));
    }

    private static /* synthetic */ void getKnownResources$annotations() {
    }

    public final boolean isPreviouslySentResource$dd_sdk_android_session_replay_release(@NotNull String resourceHash) {
        Intrinsics.checkNotNullParameter((Object)resourceHash, (String)"resourceHash");
        return this.knownResources.contains(resourceHash);
    }

    public final void cacheResourceHash$dd_sdk_android_session_replay_release(@NotNull String resourceHash) {
        Intrinsics.checkNotNullParameter((Object)resourceHash, (String)"resourceHash");
        this.knownResources.add(resourceHash);
        this.writeResourcesToStore();
    }

    public final boolean isReady$dd_sdk_android_session_replay_release() {
        return this.isInitialized.get();
    }

    private final void finishedInitializingManager() {
        this.isInitialized.set(true);
    }

    private final void writeResourcesToStore() {
        DataStoreHandler dataStoreHandler;
        Number number = this.storedLastUpdateDateNs;
        Set<String> set = this.knownResources;
        Intrinsics.checkNotNullExpressionValue(set, (String)"knownResources");
        ResourceHashesEntry data = new ResourceHashesEntry(number, CollectionsKt.toList((Iterable)set));
        FeatureScope featureScope = this.featureSdkCore.getFeature("session-replay-resources");
        if (featureScope != null && (dataStoreHandler = featureScope.getDataStore()) != null) {
            Serializer<ResourceHashesEntry> serializer = this.resourceHashesSerializer;
            DataStoreHandler.DefaultImpls.setValue$default((DataStoreHandler)dataStoreHandler, (String)DATASTORE_HASHES_ENTRY_NAME, (Object)data, (int)0, null, serializer, (int)12, null);
        }
    }

    private final void fetchStoredResourceHashes(Function1<? super DataStoreContent<ResourceHashesEntry>, Unit> onFetchSuccessful, Function0<Unit> onFetchFailure) {
        DataStoreHandler dataStoreHandler;
        FeatureScope featureScope = this.featureSdkCore.getFeature("session-replay-resources");
        if (featureScope != null && (dataStoreHandler = featureScope.getDataStore()) != null) {
            Deserializer<String, ResourceHashesEntry> deserializer = this.resourceHashesDeserializer;
            DataStoreReadCallback<ResourceHashesEntry> dataStoreReadCallback = new DataStoreReadCallback<ResourceHashesEntry>(onFetchSuccessful, onFetchFailure){
                final /* synthetic */ Function1<DataStoreContent<ResourceHashesEntry>, Unit> $onFetchSuccessful;
                final /* synthetic */ Function0<Unit> $onFetchFailure;
                {
                    this.$onFetchSuccessful = $onFetchSuccessful;
                    this.$onFetchFailure = $onFetchFailure;
                }

                public void onSuccess(@Nullable DataStoreContent<ResourceHashesEntry> dataStoreContent) {
                    this.$onFetchSuccessful.invoke(dataStoreContent);
                }

                public void onFailure() {
                    this.$onFetchFailure.invoke();
                }
            };
            DataStoreHandler.DefaultImpls.value$default((DataStoreHandler)dataStoreHandler, (String)DATASTORE_HASHES_ENTRY_NAME, null, (DataStoreReadCallback)((DataStoreReadCallback)dataStoreReadCallback), deserializer, (int)2, null);
        }
    }

    private final Unit deleteStoredHashesEntry(DataStoreWriteCallback callback) {
        Unit unit;
        DataStoreHandler dataStoreHandler;
        FeatureScope featureScope = this.featureSdkCore.getFeature("session-replay-resources");
        if (featureScope != null && (dataStoreHandler = featureScope.getDataStore()) != null) {
            dataStoreHandler.removeValue(DATASTORE_HASHES_ENTRY_NAME, callback);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final boolean didDataStoreExpire(long lastUpdateDate) {
        return System.nanoTime() - lastUpdateDate > 2592000000000000L;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/internal/resources/ResourceDataStoreManager$Companion;", "", "()V", "DATASTORE_EXPIRATION_NS", "", "DATASTORE_HASHES_ENTRY_NAME", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

