/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.storage;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.sessionreplay.internal.RecordCallback;
import com.datadog.android.sessionreplay.internal.processor.EnrichedRecord;
import com.datadog.android.sessionreplay.internal.storage.RecordWriter;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/datadog/android/sessionreplay/internal/storage/SessionReplayRecordWriter;", "Lcom/datadog/android/sessionreplay/internal/storage/RecordWriter;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "recordCallback", "Lcom/datadog/android/sessionreplay/internal/RecordCallback;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/sessionreplay/internal/RecordCallback;)V", "updateViewSent", "", "record", "Lcom/datadog/android/sessionreplay/internal/processor/EnrichedRecord;", "write", "dd-sdk-android-session-replay_release"})
public final class SessionReplayRecordWriter
implements RecordWriter {
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final RecordCallback recordCallback;

    public SessionReplayRecordWriter(@NotNull FeatureSdkCore sdkCore, @NotNull RecordCallback recordCallback) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)recordCallback, (String)"recordCallback");
        this.sdkCore = sdkCore;
        this.recordCallback = recordCallback;
    }

    @Override
    public void write(@NotNull EnrichedRecord record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        FeatureScope featureScope = this.sdkCore.getFeature("session-replay");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(record, this){
                final /* synthetic */ EnrichedRecord $record;
                final /* synthetic */ SessionReplayRecordWriter this$0;
                {
                    this.$record = $record;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"<anonymous parameter 0>");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    byte[] byArray = this.$record.toJson().getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                    byte[] serializedRecord = byArray;
                    RawBatchEvent rawBatchEvent = new RawBatchEvent(serializedRecord, null, 2, null);
                    SessionReplayRecordWriter sessionReplayRecordWriter = this.this$0;
                    SessionReplayRecordWriter sessionReplayRecordWriter2 = this.this$0;
                    EnrichedRecord enrichedRecord = this.$record;
                    SessionReplayRecordWriter sessionReplayRecordWriter3 = sessionReplayRecordWriter;
                    synchronized (sessionReplayRecordWriter3) {
                        boolean bl = false;
                        if (eventBatchWriter.write(rawBatchEvent, null, EventType.DEFAULT)) {
                            SessionReplayRecordWriter.access$updateViewSent(sessionReplayRecordWriter2, enrichedRecord);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            }), (int)1, null);
        }
    }

    private final void updateViewSent(EnrichedRecord record) {
        this.recordCallback.onRecordForViewSent(record);
    }

    public static final /* synthetic */ void access$updateViewSent(SessionReplayRecordWriter $this, EnrichedRecord record) {
        $this.updateViewSent(record);
    }
}

