/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.time;

import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.sessionreplay.internal.utils.TimeProvider;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0000\u0018\u0000 \n2\u00020\u0001:\u0001\nB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/internal/time/SessionReplayTimeProvider;", "Lcom/datadog/android/sessionreplay/internal/utils/TimeProvider;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "currentTimeProvider", "Lkotlin/Function0;", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lkotlin/jvm/functions/Function0;)V", "getDeviceTimestamp", "resolveRumViewTimestampOffset", "Companion", "dd-sdk-android-session-replay_release"})
public final class SessionReplayTimeProvider
implements TimeProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final Function0<Long> currentTimeProvider;
    @NotNull
    public static final String RUM_VIEW_TIMESTAMP_OFFSET = "view_timestamp_offset";

    public SessionReplayTimeProvider(@NotNull FeatureSdkCore sdkCore, @NotNull Function0<Long> currentTimeProvider) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(currentTimeProvider, (String)"currentTimeProvider");
        this.sdkCore = sdkCore;
        this.currentTimeProvider = currentTimeProvider;
    }

    public /* synthetic */ SessionReplayTimeProvider(FeatureSdkCore featureSdkCore, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function0 = 1.INSTANCE;
        }
        this(featureSdkCore, (Function0<Long>)function0);
    }

    @Override
    public long getDeviceTimestamp() {
        return ((Number)this.currentTimeProvider.invoke()).longValue() + this.resolveRumViewTimestampOffset();
    }

    private final long resolveRumViewTimestampOffset() {
        Map rumFeatureContext = this.sdkCore.getFeatureContext("rum");
        Object timestampOffset = rumFeatureContext.get(RUM_VIEW_TIMESTAMP_OFFSET);
        return timestampOffset instanceof Long ? ((Number)timestampOffset).longValue() : 0L;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/internal/time/SessionReplayTimeProvider$Companion;", "", "()V", "RUM_VIEW_TIMESTAMP_OFFSET", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

