/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.utils;

import androidx.collection.LruCache;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.utils.InvocationUtils;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u0000 \u0011*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002:\u0001\u0011B\u000f\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0002J)\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\nH\u0000\u00a2\u0006\u0002\b\u000eJ$\u0010\u000f\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\n2\u0006\u0010\u0010\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils;", "K", "", "V", "invocationUtils", "Lcom/datadog/android/sessionreplay/internal/utils/InvocationUtils;", "(Lcom/datadog/android/sessionreplay/internal/utils/InvocationUtils;)V", "evictAll", "", "cache", "Landroidx/collection/LruCache;", "handleTrimMemory", "level", "", "handleTrimMemory$dd_sdk_android_session_replay_release", "trimToSize", "targetSize", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nCacheUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CacheUtils.kt\ncom/datadog/android/sessionreplay/internal/utils/CacheUtils\n+ 2 InvocationUtils.kt\ncom/datadog/android/sessionreplay/internal/utils/InvocationUtils\n*L\n1#1,80:1\n13#2,21:81\n13#2,21:102\n*S KotlinDebug\n*F\n+ 1 CacheUtils.kt\ncom/datadog/android/sessionreplay/internal/utils/CacheUtils\n*L\n61#1:81,21\n69#1:102,21\n*E\n"})
public final class CacheUtils<K, V> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InvocationUtils invocationUtils;
    @NotNull
    private static final String FAILURE_MSG_EVICT_CACHE_CONTENTS = "Failed to evict cache entries";
    @NotNull
    private static final String FAILURE_MSG_TRIM_CACHE = "Failed to trim cache to size";

    public CacheUtils(@NotNull InvocationUtils invocationUtils) {
        Intrinsics.checkNotNullParameter((Object)invocationUtils, (String)"invocationUtils");
        this.invocationUtils = invocationUtils;
    }

    public /* synthetic */ CacheUtils(InvocationUtils invocationUtils, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            invocationUtils = new InvocationUtils();
        }
        this(invocationUtils);
    }

    public final void handleTrimMemory$dd_sdk_android_session_replay_release(int level, @NotNull LruCache<K, V> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        int onLowMemorySizeBytes = cache.maxSize() / 2;
        int onModerateMemorySizeBytes = cache.maxSize() / 4 * 3;
        switch (level) {
            case 40: {
                this.evictAll(cache);
                break;
            }
            case 80: {
                this.evictAll(cache);
                break;
            }
            case 60: {
                this.trimToSize(cache, onModerateMemorySizeBytes);
                break;
            }
            case 15: {
                this.evictAll(cache);
                break;
            }
            case 10: {
                this.trimToSize(cache, onLowMemorySizeBytes);
                break;
            }
            case 5: {
                this.trimToSize(cache, onModerateMemorySizeBytes);
                break;
            }
            case 20: {
                break;
            }
            default: {
                this.evictAll(cache);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void evictAll(LruCache<K, V> cache) {
        InvocationUtils invocationUtils = this.invocationUtils;
        String string = FAILURE_MSG_EVICT_CACHE_CONTENTS;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            cache.evictAll();
        }
        catch (Exception e$iv) {
            void failureMessage$iv;
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new Function0<String>((String)failureMessage$iv){
                final /* synthetic */ String $failureMessage;
                {
                    this.$failureMessage = $failureMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$failureMessage;
                }
            }), (Throwable)e$iv, (boolean)false, null, (int)48, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void trimToSize(LruCache<K, V> cache, int targetSize) {
        InvocationUtils invocationUtils = this.invocationUtils;
        String string = FAILURE_MSG_TRIM_CACHE;
        InternalLogger logger$iv = InternalLogger.Companion.getUNBOUND();
        InternalLogger.Level level$iv = InternalLogger.Level.WARN;
        InternalLogger.Target target$iv = InternalLogger.Target.MAINTAINER;
        boolean $i$f$safeCallWithErrorLogging = false;
        try {
            boolean bl = false;
            cache.trimToSize(targetSize);
        }
        catch (Exception e$iv) {
            void failureMessage$iv;
            InternalLogger.DefaultImpls.log$default((InternalLogger)logger$iv, (InternalLogger.Level)level$iv, (InternalLogger.Target)target$iv, (Function0)((Function0)new /* invalid duplicate definition of identical inner class */), (Throwable)e$iv, (boolean)false, null, (int)48, null);
        }
    }

    public CacheUtils() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/CacheUtils$Companion;", "", "()V", "FAILURE_MSG_EVICT_CACHE_CONTENTS", "", "FAILURE_MSG_TRIM_CACHE", "dd-sdk-android-session-replay_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

