/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.core.internal.utils.ConcurrencyExtKt;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapCachesManager;
import com.datadog.android.sessionreplay.internal.recorder.resources.ResourceResolver;
import com.datadog.android.sessionreplay.internal.utils.DrawableUtils;
import com.datadog.android.sessionreplay.recorder.wrappers.BitmapWrapper;
import com.datadog.android.sessionreplay.recorder.wrappers.CanvasWrapper;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 (2\u00020\u0001:\u0002()B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJI\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bJ!\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\b\b\u0002\u0010\u0016\u001a\u00020\u0012H\u0001\u00a2\u0006\u0002\b\u001fJ8\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0003J \u0010\"\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0003J*\u0010#\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J,\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120'2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils;", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "bitmapCachesManager", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;", "executorService", "Ljava/util/concurrent/ExecutorService;", "bitmapWrapper", "Lcom/datadog/android/sessionreplay/recorder/wrappers/BitmapWrapper;", "canvasWrapper", "Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;Ljava/util/concurrent/ExecutorService;Lcom/datadog/android/sessionreplay/recorder/wrappers/BitmapWrapper;Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper;)V", "createBitmapOfApproxSizeFromDrawable", "", "drawable", "Landroid/graphics/drawable/Drawable;", "drawableWidth", "", "drawableHeight", "displayMetrics", "Landroid/util/DisplayMetrics;", "requestedSizeInBytes", "config", "Landroid/graphics/Bitmap$Config;", "bitmapCreationCallback", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/ResourceResolver$BitmapCreationCallback;", "createBitmapOfApproxSizeFromDrawable$dd_sdk_android_session_replay_release", "createScaledBitmap", "Landroid/graphics/Bitmap;", "bitmap", "createScaledBitmap$dd_sdk_android_session_replay_release", "resizeBitmapCallback", "Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils$ResizeBitmapCallback;", "drawOnCanvas", "getBitmapBySize", "width", "height", "getScaledWidthAndHeight", "Lkotlin/Pair;", "Companion", "ResizeBitmapCallback", "dd-sdk-android-session-replay_release"})
public final class DrawableUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final BitmapCachesManager bitmapCachesManager;
    @NotNull
    private final ExecutorService executorService;
    @NotNull
    private final BitmapWrapper bitmapWrapper;
    @NotNull
    private final CanvasWrapper canvasWrapper;
    public static final int MAX_BITMAP_SIZE_BYTES_WITH_RESOURCE_ENDPOINT = 0xA00000;
    private static final int ARGB_8888_PIXEL_SIZE_BYTES = 4;
    @NotNull
    public static final String FAILED_TO_CREATE_SCALED_BITMAP_ERROR = "Failed to create a scaled bitmap from the drawable";

    public DrawableUtils(@NotNull InternalLogger internalLogger, @NotNull BitmapCachesManager bitmapCachesManager, @NotNull ExecutorService executorService, @NotNull BitmapWrapper bitmapWrapper, @NotNull CanvasWrapper canvasWrapper) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)bitmapCachesManager, (String)"bitmapCachesManager");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        Intrinsics.checkNotNullParameter((Object)bitmapWrapper, (String)"bitmapWrapper");
        Intrinsics.checkNotNullParameter((Object)canvasWrapper, (String)"canvasWrapper");
        this.internalLogger = internalLogger;
        this.bitmapCachesManager = bitmapCachesManager;
        this.executorService = executorService;
        this.bitmapWrapper = bitmapWrapper;
        this.canvasWrapper = canvasWrapper;
    }

    public /* synthetic */ DrawableUtils(InternalLogger internalLogger, BitmapCachesManager bitmapCachesManager, ExecutorService executorService, BitmapWrapper bitmapWrapper, CanvasWrapper canvasWrapper, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bitmapWrapper = new BitmapWrapper(internalLogger);
        }
        if ((n & 0x10) != 0) {
            canvasWrapper = new CanvasWrapper(internalLogger);
        }
        this(internalLogger, bitmapCachesManager, executorService, bitmapWrapper, canvasWrapper);
    }

    @WorkerThread
    public final void createBitmapOfApproxSizeFromDrawable$dd_sdk_android_session_replay_release(@NotNull Drawable drawable, int drawableWidth, int drawableHeight, @NotNull DisplayMetrics displayMetrics, int requestedSizeInBytes, @NotNull Bitmap.Config config, @NotNull ResourceResolver.BitmapCreationCallback bitmapCreationCallback) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)displayMetrics, (String)"displayMetrics");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)bitmapCreationCallback, (String)"bitmapCreationCallback");
        this.createScaledBitmap(drawableWidth, drawableHeight, requestedSizeInBytes, displayMetrics, config, new ResizeBitmapCallback(this, drawable, bitmapCreationCallback){
            final /* synthetic */ DrawableUtils this$0;
            final /* synthetic */ Drawable $drawable;
            final /* synthetic */ ResourceResolver.BitmapCreationCallback $bitmapCreationCallback;
            {
                this.this$0 = $receiver;
                this.$drawable = $drawable;
                this.$bitmapCreationCallback = $bitmapCreationCallback;
            }

            @WorkerThread
            public void onSuccess(@NotNull Bitmap bitmap) {
                Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                ConcurrencyExtKt.submitSafe((ExecutorService)DrawableUtils.access$getExecutorService$p(this.this$0), (String)"drawOnCanvas", (InternalLogger)DrawableUtils.access$getInternalLogger$p(this.this$0), () -> createBitmapOfApproxSizeFromDrawable.1.onSuccess$lambda$0(this.this$0, bitmap, this.$drawable, this.$bitmapCreationCallback));
            }

            @WorkerThread
            public void onFailure() {
                InternalLogger.DefaultImpls.log$default((InternalLogger)DrawableUtils.access$getInternalLogger$p(this.this$0), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)createBitmapOfApproxSizeFromDrawable.onFailure.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                this.$bitmapCreationCallback.onFailure();
            }

            private static final void onSuccess$lambda$0(DrawableUtils this$0, Bitmap $bitmap, Drawable $drawable, ResourceResolver.BitmapCreationCallback $bitmapCreationCallback) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$bitmap, (String)"$bitmap");
                Intrinsics.checkNotNullParameter((Object)$drawable, (String)"$drawable");
                Intrinsics.checkNotNullParameter((Object)$bitmapCreationCallback, (String)"$bitmapCreationCallback");
                DrawableUtils.access$drawOnCanvas(this$0, $bitmap, $drawable, $bitmapCreationCallback);
            }
        });
    }

    public static /* synthetic */ void createBitmapOfApproxSizeFromDrawable$dd_sdk_android_session_replay_release$default(DrawableUtils drawableUtils, Drawable drawable, int n, int n2, DisplayMetrics displayMetrics, int n3, Bitmap.Config config, ResourceResolver.BitmapCreationCallback bitmapCreationCallback, int n4, Object object) {
        if ((n4 & 0x10) != 0) {
            n3 = 0xA00000;
        }
        if ((n4 & 0x20) != 0) {
            config = Bitmap.Config.ARGB_8888;
        }
        drawableUtils.createBitmapOfApproxSizeFromDrawable$dd_sdk_android_session_replay_release(drawable, n, n2, displayMetrics, n3, config, bitmapCreationCallback);
    }

    @WorkerThread
    @Nullable
    public final Bitmap createScaledBitmap$dd_sdk_android_session_replay_release(@NotNull Bitmap bitmap, int requestedSizeInBytes) {
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        Pair<Integer, Integer> pair = this.getScaledWidthAndHeight(bitmap.getWidth(), bitmap.getHeight(), requestedSizeInBytes);
        int width = ((Number)pair.component1()).intValue();
        int height = ((Number)pair.component2()).intValue();
        return this.bitmapWrapper.createScaledBitmap$dd_sdk_android_session_replay_release(bitmap, width, height, false);
    }

    public static /* synthetic */ Bitmap createScaledBitmap$dd_sdk_android_session_replay_release$default(DrawableUtils drawableUtils, Bitmap bitmap, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0xA00000;
        }
        return drawableUtils.createScaledBitmap$dd_sdk_android_session_replay_release(bitmap, n);
    }

    @WorkerThread
    private final void drawOnCanvas(Bitmap bitmap, Drawable drawable, ResourceResolver.BitmapCreationCallback bitmapCreationCallback) {
        Canvas canvas = this.canvasWrapper.createCanvas(bitmap);
        if (canvas == null) {
            bitmapCreationCallback.onFailure();
        } else {
            canvas.drawColor(0, PorterDuff.Mode.MULTIPLY);
            drawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
            drawable.draw(canvas);
            bitmapCreationCallback.onReady(bitmap);
        }
    }

    @WorkerThread
    private final void createScaledBitmap(int drawableWidth, int drawableHeight, int requestedSizeInBytes, DisplayMetrics displayMetrics, Bitmap.Config config, ResizeBitmapCallback resizeBitmapCallback) {
        int height;
        Pair<Integer, Integer> pair = this.getScaledWidthAndHeight(drawableWidth, drawableHeight, requestedSizeInBytes);
        int width = ((Number)pair.component1()).intValue();
        Bitmap result2 = this.getBitmapBySize(displayMetrics, width, height = ((Number)pair.component2()).intValue(), config);
        if (result2 == null) {
            resizeBitmapCallback.onFailure();
        } else {
            resizeBitmapCallback.onSuccess(result2);
        }
    }

    private final Pair<Integer, Integer> getScaledWidthAndHeight(int drawableWidth, int drawableHeight, int requestedSizeInBytes) {
        int width = drawableWidth;
        int height = drawableHeight;
        int sizeAfterCreation = width * height * 4;
        if (sizeAfterCreation > requestedSizeInBytes) {
            int maxSize;
            double bitmapRatio = (double)width / (double)height;
            double totalMaxPixels = requestedSizeInBytes / 4;
            width = maxSize = (int)Math.sqrt(totalMaxPixels);
            height = maxSize;
            if (bitmapRatio > 1.0) {
                height = (int)((double)maxSize / bitmapRatio);
            } else {
                width = (int)((double)maxSize * bitmapRatio);
            }
        }
        return new Pair((Object)width, (Object)height);
    }

    private final Bitmap getBitmapBySize(DisplayMetrics displayMetrics, int width, int height, Bitmap.Config config) {
        Bitmap bitmap = this.bitmapCachesManager.getBitmapByProperties$dd_sdk_android_session_replay_release(width, height, config);
        if (bitmap == null) {
            bitmap = this.bitmapWrapper.createBitmap(width, height, config, displayMetrics);
        }
        return bitmap;
    }

    public static final /* synthetic */ ExecutorService access$getExecutorService$p(DrawableUtils $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ InternalLogger access$getInternalLogger$p(DrawableUtils $this) {
        return $this.internalLogger;
    }

    public static final /* synthetic */ void access$drawOnCanvas(DrawableUtils $this, Bitmap bitmap, Drawable drawable, ResourceResolver.BitmapCreationCallback bitmapCreationCallback) {
        $this.drawOnCanvas(bitmap, drawable, bitmapCreationCallback);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00020\u00048\u0000X\u0081T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils$Companion;", "", "()V", "ARGB_8888_PIXEL_SIZE_BYTES", "", "FAILED_TO_CREATE_SCALED_BITMAP_ERROR", "", "MAX_BITMAP_SIZE_BYTES_WITH_RESOURCE_ENDPOINT", "getMAX_BITMAP_SIZE_BYTES_WITH_RESOURCE_ENDPOINT$dd_sdk_android_session_replay_release$annotations", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        public static /* synthetic */ void getMAX_BITMAP_SIZE_BYTES_WITH_RESOURCE_ENDPOINT$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b`\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H'J\u0010\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006H'\u00a8\u0006\u0007"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/DrawableUtils$ResizeBitmapCallback;", "", "onFailure", "", "onSuccess", "bitmap", "Landroid/graphics/Bitmap;", "dd-sdk-android-session-replay_release"})
    public static interface ResizeBitmapCallback {
        @WorkerThread
        public void onSuccess(@NotNull Bitmap var1);

        @WorkerThread
        public void onFailure();
    }
}

