/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.utils;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.TypedValue;
import android.view.WindowManager;
import android.view.WindowMetrics;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.internal.utils.MiscUtils;
import com.datadog.android.sessionreplay.recorder.SystemInformation;
import com.datadog.android.sessionreplay.utils.DefaultColorStringFormatter;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tJ\u0019\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u0010\u001a\u00060\u0011R\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u001f\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\b\u001aJ'\u0010\u001b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/MiscUtils;", "", "()V", "DESERIALIZE_JSON_ERROR", "", "GET_STRING_FROM_JSON_ERROR", "resolveScreenBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "context", "Landroid/content/Context;", "screenDensity", "", "resolveSystemInformation", "Lcom/datadog/android/sessionreplay/recorder/SystemInformation;", "resolveThemeColor", "", "theme", "Landroid/content/res/Resources$Theme;", "Landroid/content/res/Resources;", "(Landroid/content/res/Resources$Theme;)Ljava/lang/Integer;", "safeDeserializeToJsonObject", "Lcom/google/gson/JsonObject;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "jsonByteArray", "", "safeDeserializeToJsonObject$dd_sdk_android_session_replay_release", "safeGetStringFromJsonObject", "json", "key", "safeGetStringFromJsonObject$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
public final class MiscUtils {
    @NotNull
    public static final MiscUtils INSTANCE = new MiscUtils();
    @NotNull
    private static final String GET_STRING_FROM_JSON_ERROR = "Error getting string property from json";
    @NotNull
    public static final String DESERIALIZE_JSON_ERROR = "Error deserializing json object";

    private MiscUtils() {
    }

    @Nullable
    public final JsonObject safeDeserializeToJsonObject$dd_sdk_android_session_replay_release(@NotNull InternalLogger internalLogger, @NotNull byte[] jsonByteArray) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)jsonByteArray, (String)"jsonByteArray");
        if (jsonByteArray.length == 0) {
            return null;
        }
        String jsonString = new String(jsonByteArray, Charsets.UTF_8);
        try {
            jsonElement = JsonParser.parseString((String)jsonString);
            jsonElement = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
        }
        catch (JsonParseException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)safeDeserializeToJsonObject.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            jsonElement = null;
        }
        return jsonElement;
    }

    @Nullable
    public final String safeGetStringFromJsonObject$dd_sdk_android_session_replay_release(@NotNull InternalLogger internalLogger, @NotNull JsonObject json, @NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        try {
            JsonElement jsonElement = json.get(key);
            string = jsonElement != null ? jsonElement.getAsString() : null;
        }
        catch (ClassCastException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)safeGetStringFromJsonObject.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            string = null;
        }
        catch (IllegalStateException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)safeGetStringFromJsonObject.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            string = null;
        }
        return string;
    }

    @Nullable
    public final Integer resolveThemeColor(@NotNull Resources.Theme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        TypedValue a = new TypedValue();
        theme.resolveAttribute(16842836, a, true);
        return a.type >= 28 && a.type <= 31 ? Integer.valueOf(a.data) : null;
    }

    @NotNull
    public final SystemInformation resolveSystemInformation(@NotNull Context context) {
        String string;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        float screenDensity = context.getResources().getDisplayMetrics().density;
        Resources.Theme theme = context.getTheme();
        Intrinsics.checkNotNullExpressionValue((Object)theme, (String)"context.theme");
        Integer n = this.resolveThemeColor(theme);
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            string = DefaultColorStringFormatter.INSTANCE.formatColorAndAlphaAsHexString(it, 255);
        } else {
            string = null;
        }
        String themeColorAsHexString = string;
        return new SystemInformation(this.resolveScreenBounds(context, screenDensity), context.getResources().getConfiguration().orientation, screenDensity, themeColorAsHexString);
    }

    private final GlobalBounds resolveScreenBounds(Context context, float screenDensity) {
        Object object = context.getSystemService("window");
        WindowManager windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        if (windowManager == null) {
            return new GlobalBounds(0L, 0L, 0L, 0L);
        }
        WindowManager windowManager2 = windowManager;
        long screenHeight = 0L;
        long screenWidth = 0L;
        if (Build.VERSION.SDK_INT >= 30) {
            WindowMetrics windowMetrics = windowManager2.getCurrentWindowMetrics();
            Intrinsics.checkNotNullExpressionValue((Object)windowMetrics, (String)"windowManager.currentWindowMetrics");
            WindowMetrics currentWindowMetrics = windowMetrics;
            Rect rect = currentWindowMetrics.getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"currentWindowMetrics.bounds");
            Rect screenBounds = rect;
            screenHeight = LongExtKt.densityNormalized((long)(screenBounds.bottom - screenBounds.top), (float)screenDensity);
            screenWidth = LongExtKt.densityNormalized((long)(screenBounds.right - screenBounds.left), (float)screenDensity);
        } else {
            Point size = new Point();
            windowManager2.getDefaultDisplay().getSize(size);
            screenHeight = LongExtKt.densityNormalized((long)size.y, (float)screenDensity);
            screenWidth = LongExtKt.densityNormalized((long)size.x, (float)screenDensity);
        }
        return new GlobalBounds(0L, 0L, screenWidth, screenHeight);
    }
}

