/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.internal.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathMeasure;
import android.graphics.RectF;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.internal.recorder.resources.BitmapCachesManager;
import com.datadog.android.sessionreplay.internal.recorder.resources.HashGenerator;
import com.datadog.android.sessionreplay.internal.recorder.resources.MD5HashGenerator;
import com.datadog.android.sessionreplay.internal.utils.PathUtils;
import com.datadog.android.sessionreplay.recorder.wrappers.BitmapWrapper;
import com.datadog.android.sessionreplay.recorder.wrappers.CanvasWrapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ7\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0016J*\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020 H\u0002J*\u0010!\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J5\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001e\u001a\u00020\u00102\b\b\u0002\u0010%\u001a\u00020\u00122\b\b\u0002\u0010&\u001a\u00020'2\b\b\u0002\u0010(\u001a\u00020)H\u0000\u00a2\u0006\u0002\b*J \u0010+\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/PathUtils;", "", "logger", "Lcom/datadog/android/api/InternalLogger;", "bitmapCachesManager", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;", "canvasWrapper", "Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper;", "bitmapWrapper", "Lcom/datadog/android/sessionreplay/recorder/wrappers/BitmapWrapper;", "md5Generator", "Lcom/datadog/android/sessionreplay/internal/recorder/resources/HashGenerator;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/sessionreplay/internal/recorder/resources/BitmapCachesManager;Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper;Lcom/datadog/android/sessionreplay/recorder/wrappers/BitmapWrapper;Lcom/datadog/android/sessionreplay/internal/recorder/resources/HashGenerator;)V", "convertPathToBitmap", "Landroid/graphics/Bitmap;", "checkPath", "Landroid/graphics/Path;", "checkmarkColor", "", "desiredWidth", "desiredHeight", "strokeWidth", "convertPathToBitmap$dd_sdk_android_session_replay_release", "drawPathOntoBitmap", "bitmap", "scaledPath", "drawPathSafe", "", "canvas", "Landroid/graphics/Canvas;", "path", "paint", "Landroid/graphics/Paint;", "drawPathToBitmap", "targetStrokeWidth", "generateKeyForPath", "", "maxPoints", "sampleInterval", "", "pathMeasure", "Landroid/graphics/PathMeasure;", "generateKeyForPath$dd_sdk_android_session_replay_release", "scalePathToTargetDimensions", "targetWidth", "targetHeight", "Companion", "dd-sdk-android-session-replay_release"})
public final class PathUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private final BitmapCachesManager bitmapCachesManager;
    @NotNull
    private final CanvasWrapper canvasWrapper;
    @NotNull
    private final BitmapWrapper bitmapWrapper;
    @NotNull
    private final HashGenerator md5Generator;
    @NotNull
    public static final String PATH_DRAW_ERROR = "Failed to draw Path to Canvas";
    @NotNull
    public static final String EMPTY_POINTS = "0.0,0.0;";
    public static final int DEFAULT_MAX_PATH_LENGTH = 1000;
    public static final float DEFAULT_SAMPLE_INTERVAL = 10.0f;

    public PathUtils(@NotNull InternalLogger logger, @NotNull BitmapCachesManager bitmapCachesManager, @NotNull CanvasWrapper canvasWrapper, @NotNull BitmapWrapper bitmapWrapper, @NotNull HashGenerator md5Generator) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)bitmapCachesManager, (String)"bitmapCachesManager");
        Intrinsics.checkNotNullParameter((Object)canvasWrapper, (String)"canvasWrapper");
        Intrinsics.checkNotNullParameter((Object)bitmapWrapper, (String)"bitmapWrapper");
        Intrinsics.checkNotNullParameter((Object)md5Generator, (String)"md5Generator");
        this.logger = logger;
        this.bitmapCachesManager = bitmapCachesManager;
        this.canvasWrapper = canvasWrapper;
        this.bitmapWrapper = bitmapWrapper;
        this.md5Generator = md5Generator;
    }

    public /* synthetic */ PathUtils(InternalLogger internalLogger, BitmapCachesManager bitmapCachesManager, CanvasWrapper canvasWrapper, BitmapWrapper bitmapWrapper, HashGenerator hashGenerator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            internalLogger = InternalLogger.Companion.getUNBOUND();
        }
        if ((n & 4) != 0) {
            canvasWrapper = new CanvasWrapper(internalLogger);
        }
        if ((n & 8) != 0) {
            bitmapWrapper = new BitmapWrapper(null, 1, null);
        }
        if ((n & 0x10) != 0) {
            hashGenerator = new MD5HashGenerator(internalLogger);
        }
        this(internalLogger, bitmapCachesManager, canvasWrapper, bitmapWrapper, hashGenerator);
    }

    @Nullable
    public final Bitmap convertPathToBitmap$dd_sdk_android_session_replay_release(@NotNull Path checkPath, int checkmarkColor, int desiredWidth, int desiredHeight, int strokeWidth) {
        Intrinsics.checkNotNullParameter((Object)checkPath, (String)"checkPath");
        Path scaledPath = this.scalePathToTargetDimensions(checkPath, desiredWidth, desiredHeight);
        Bitmap bitmap = this.bitmapCachesManager.getBitmapByProperties$dd_sdk_android_session_replay_release(desiredWidth, desiredHeight, Bitmap.Config.ARGB_8888);
        if (bitmap == null && (bitmap = BitmapWrapper.createBitmap$default(this.bitmapWrapper, desiredWidth, desiredHeight, Bitmap.Config.ARGB_8888, null, 8, null)) == null) {
            return null;
        }
        Bitmap mutableBitmap = bitmap;
        return this.drawPathOntoBitmap(mutableBitmap, scaledPath, strokeWidth, checkmarkColor);
    }

    private final void drawPathToBitmap(int checkmarkColor, Path path, int targetStrokeWidth, Canvas canvas) {
        Paint paint;
        Paint $this$drawPathToBitmap_u24lambda_u240 = paint = new Paint();
        boolean bl = false;
        $this$drawPathToBitmap_u24lambda_u240.setColor(checkmarkColor);
        $this$drawPathToBitmap_u24lambda_u240.setStyle(Paint.Style.STROKE);
        $this$drawPathToBitmap_u24lambda_u240.setStrokeWidth((float)targetStrokeWidth);
        $this$drawPathToBitmap_u24lambda_u240.setAntiAlias(true);
        Paint paint2 = paint;
        this.drawPathSafe(canvas, path, paint2);
    }

    private final Path scalePathToTargetDimensions(Path path, int targetWidth, int targetHeight) {
        RectF originalBounds = new RectF();
        path.computeBounds(originalBounds, true);
        float scaleX = (float)targetWidth / originalBounds.width();
        float scaleY = (float)targetHeight / originalBounds.height();
        float scaleFactor = Math.min(scaleX, scaleY);
        float currentCenterX = (originalBounds.left + originalBounds.right) / (float)2;
        float currentCenterY = (originalBounds.top + originalBounds.bottom) / (float)2;
        int newCenterX = targetWidth / 2;
        int newCenterY = targetHeight / 2;
        float scaledCenterX = currentCenterX * scaleFactor;
        float scaledCenterY = currentCenterY * scaleFactor;
        float translateX = (float)newCenterX - scaledCenterX;
        float translateY = (float)newCenterY - scaledCenterY;
        Matrix matrix = new Matrix();
        matrix.preTranslate(translateX, translateY);
        matrix.preScale(scaleFactor, scaleFactor);
        path.transform(matrix);
        return path;
    }

    private final Bitmap drawPathOntoBitmap(Bitmap bitmap, Path scaledPath, int strokeWidth, int checkmarkColor) {
        Canvas canvas = this.canvasWrapper.createCanvas(bitmap);
        if (canvas == null) {
            return null;
        }
        Canvas canvas2 = canvas;
        this.drawPathToBitmap(checkmarkColor, scaledPath, strokeWidth, canvas2);
        return bitmap;
    }

    private final void drawPathSafe(Canvas canvas, Path path, Paint paint) {
        try {
            Canvas canvas2 = canvas;
            if (canvas2 != null) {
                canvas2.drawPath(path, paint);
            }
        }
        catch (IllegalArgumentException e) {
            InternalLogger internalLogger = this.logger;
            InternalLogger.Target target = InternalLogger.Target.MAINTAINER;
            InternalLogger.Level level = InternalLogger.Level.WARN;
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)level, (InternalLogger.Target)target, (Function0)drawPathSafe.1.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    @Nullable
    public final String generateKeyForPath$dd_sdk_android_session_replay_release(@NotNull Path path, int maxPoints, float sampleInterval, @NotNull PathMeasure pathMeasure) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)pathMeasure, (String)"pathMeasure");
        float[] pos = new float[2];
        float[] tan = new float[2];
        StringBuilder sampledPoints = new StringBuilder();
        int pointCount = 0;
        for (float distance = 0.0f; distance < pathMeasure.getLength() && pointCount < maxPoints; ++pointCount, distance += sampleInterval) {
            pathMeasure.getPosTan(distance, pos, tan);
            sampledPoints.append(pos[0] + "," + pos[1] + ";");
            if (pathMeasure.nextContour()) continue;
        }
        String string2 = sampledPoints.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"sampledPoints.toString()");
        String points = string2;
        if (Intrinsics.areEqual((Object)points, (Object)EMPTY_POINTS)) {
            string = null;
        } else {
            String string3 = points;
            byte[] byArray = string3.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            string = this.md5Generator.generate(byArray);
        }
        return string;
    }

    public static /* synthetic */ String generateKeyForPath$dd_sdk_android_session_replay_release$default(PathUtils pathUtils, Path path, int n, float f, PathMeasure pathMeasure, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1000;
        }
        if ((n2 & 4) != 0) {
            f = 10.0f;
        }
        if ((n2 & 8) != 0) {
            pathMeasure = new PathMeasure(path, false);
        }
        return pathUtils.generateKeyForPath$dd_sdk_android_session_replay_release(path, n, f, pathMeasure);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/internal/utils/PathUtils$Companion;", "", "()V", "DEFAULT_MAX_PATH_LENGTH", "", "DEFAULT_SAMPLE_INTERVAL", "", "EMPTY_POINTS", "", "PATH_DRAW_ERROR", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

