/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.view.View;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseWireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DefaultViewIdentifierResolver;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ImageWireframeHelper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 %*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001%B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ3\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00028\u00002\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0017\u00a2\u0006\u0002\u0010\u0019J:\u0010\u001a\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0015J4\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0014J*\u0010$\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0015R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper;", "T", "Landroid/view/View;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "uniqueIdentifierGenerator", "Lcom/datadog/android/sessionreplay/utils/DefaultViewIdentifierResolver;", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/view/View;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;)Ljava/util/List;", "resolveBackgroundAsImageWireframe", "bounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "width", "", "height", "resolveBackgroundAsShapeWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$ShapeWireframe;", "shapeStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "resolveViewBackground", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nBaseAsyncBackgroundWireframeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseAsyncBackgroundWireframeMapper.kt\ncom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,178:1\n1#2:179\n*E\n"})
public abstract class BaseAsyncBackgroundWireframeMapper<T extends View>
extends BaseWireframeMapper<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private DefaultViewIdentifierResolver uniqueIdentifierGenerator;
    @NotNull
    public static final String PREFIX_BACKGROUND_DRAWABLE = "backgroundDrawable";

    public BaseAsyncBackgroundWireframeMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.uniqueIdentifierGenerator = DefaultViewIdentifierResolver.INSTANCE;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull T view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(view, (String)"view");
                Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
                Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
                Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
                MobileSegment.Wireframe backgroundWireframe = this.resolveViewBackground((View)view, mappingContext, asyncJobStatusCallback, internalLogger);
                object = backgroundWireframe;
                if (object == null) break block2;
                MobileSegment.Wireframe it = object;
                boolean bl = false;
                List list = CollectionsKt.listOf((Object)it);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @UiThread
    @Nullable
    protected MobileSegment.Wireframe resolveViewBackground(@NotNull View view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        MobileSegment.ShapeStyle shapeStyle;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Drawable drawable = view.getBackground();
        if (drawable != null) {
            Drawable it = drawable;
            boolean bl = false;
            shapeStyle = this.resolveShapeStyle(it, view.getAlpha(), internalLogger);
        } else {
            shapeStyle = null;
        }
        MobileSegment.ShapeStyle shapeStyle2 = shapeStyle;
        GlobalBounds bounds = this.getViewBoundsResolver().resolveViewGlobalBounds(view, mappingContext.getSystemInformation().getScreenDensity());
        int width = view.getWidth();
        int height = view.getHeight();
        return shapeStyle2 == null ? this.resolveBackgroundAsImageWireframe(view, bounds, width, height, mappingContext, asyncJobStatusCallback) : (MobileSegment.Wireframe)this.resolveBackgroundAsShapeWireframe(view, bounds, width, height, shapeStyle2);
    }

    @Nullable
    protected MobileSegment.Wireframe.ShapeWireframe resolveBackgroundAsShapeWireframe(@NotNull View view, @NotNull GlobalBounds bounds, int width, int height, @Nullable MobileSegment.ShapeStyle shapeStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Long l = this.uniqueIdentifierGenerator.resolveChildUniqueIdentifier(view, PREFIX_BACKGROUND_DRAWABLE);
        if (l == null) {
            return null;
        }
        long id2 = l;
        Resources resources = view.getResources();
        float density = resources.getDisplayMetrics().density;
        return new MobileSegment.Wireframe.ShapeWireframe(id2, bounds.getX(), bounds.getY(), IntExtKt.densityNormalized((int)width, (float)density), IntExtKt.densityNormalized((int)height, (float)density), null, shapeStyle, null, 32, null);
    }

    @UiThread
    @Nullable
    protected MobileSegment.Wireframe resolveBackgroundAsImageWireframe(@NotNull View view, @NotNull GlobalBounds bounds, int width, int height, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Drawable drawable = view.getBackground();
        if (drawable == null) {
            return null;
        }
        Drawable background = drawable;
        return ImageWireframeHelper.DefaultImpls.createImageWireframeByDrawable$default(mappingContext.getImageWireframeHelper(), view, mappingContext.getImagePrivacy(), 0, bounds.getX(), bounds.getY(), width, height, false, background, null, asyncJobStatusCallback, new MobileSegment.WireframeClip(null, null, null, null, 15, null), null, null, PREFIX_BACKGROUND_DRAWABLE, null, 512, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper$Companion;", "", "()V", "PREFIX_BACKGROUND_DRAWABLE", "", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

