/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.graphics.drawable.Drawable;
import android.view.View;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.mapper.WireframeMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0004J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0002H\u0004R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\n\u001a\u00020\u000bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006 "}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/BaseWireframeMapper;", "T", "Landroid/view/View;", "Lcom/datadog/android/sessionreplay/recorder/mapper/WireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "getColorStringFormatter", "()Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "getDrawableToColorMapper", "()Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "getViewBoundsResolver", "()Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "getViewIdentifierResolver", "()Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "resolveShapeStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$ShapeStyle;", "drawable", "Landroid/graphics/drawable/Drawable;", "viewAlpha", "", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "resolveViewId", "", "view", "dd-sdk-android-session-replay_release"})
public abstract class BaseWireframeMapper<T extends View>
implements WireframeMapper<T> {
    @NotNull
    private final ViewIdentifierResolver viewIdentifierResolver;
    @NotNull
    private final ColorStringFormatter colorStringFormatter;
    @NotNull
    private final ViewBoundsResolver viewBoundsResolver;
    @NotNull
    private final DrawableToColorMapper drawableToColorMapper;

    public BaseWireframeMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        this.viewIdentifierResolver = viewIdentifierResolver;
        this.colorStringFormatter = colorStringFormatter;
        this.viewBoundsResolver = viewBoundsResolver;
        this.drawableToColorMapper = drawableToColorMapper;
    }

    @NotNull
    protected final ViewIdentifierResolver getViewIdentifierResolver() {
        return this.viewIdentifierResolver;
    }

    @NotNull
    protected final ColorStringFormatter getColorStringFormatter() {
        return this.colorStringFormatter;
    }

    @NotNull
    protected final ViewBoundsResolver getViewBoundsResolver() {
        return this.viewBoundsResolver;
    }

    @NotNull
    protected final DrawableToColorMapper getDrawableToColorMapper() {
        return this.drawableToColorMapper;
    }

    protected final long resolveViewId(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return this.viewIdentifierResolver.resolveViewId(view);
    }

    @Nullable
    protected final MobileSegment.ShapeStyle resolveShapeStyle(@NotNull Drawable drawable, float viewAlpha, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Integer color = this.drawableToColorMapper.mapDrawableToColor(drawable, internalLogger);
        return color != null ? new MobileSegment.ShapeStyle(this.colorStringFormatter.formatColorAsHexString(color), Float.valueOf(viewAlpha), null, 4, null) : null;
    }
}

