/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.text.Editable;
import android.widget.EditText;
import android.widget.TextView;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.recorder.obfuscator.StringObfuscator;
import com.datadog.android.sessionreplay.recorder.mapper.TextViewMapper;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J \u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/EditTextMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "Landroid/widget/EditText;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "resolveCapturedHint", "", "hint", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "resolveCapturedText", "textView", "isOption", "", "Landroid/widget/TextView;", "text", "Companion", "dd-sdk-android-session-replay_release"})
public final class EditTextMapper
extends TextViewMapper<EditText> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Integer[] SENSITIVE_TEXT_VARIATIONS;
    @NotNull
    private static final Integer[] SENSITIVE_NUMBER_VARIATIONS;

    public EditTextMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @NotNull
    protected String resolveCapturedText(@NotNull EditText textView, @NotNull TextAndInputPrivacy textAndInputPrivacy, boolean isOption) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        Editable editable = textView.getText();
        String string = editable != null ? editable.toString() : null;
        if (string == null) {
            string = "";
        }
        String text = string;
        CharSequence charSequence = textView.getHint();
        String string2 = charSequence != null ? ((Object)charSequence).toString() : null;
        if (string2 == null) {
            string2 = "";
        }
        String hint = string2;
        return ((CharSequence)text).length() > 0 ? this.resolveCapturedText((TextView)textView, text, textAndInputPrivacy) : this.resolveCapturedHint(hint, textAndInputPrivacy);
    }

    private final String resolveCapturedText(TextView textView, String text, TextAndInputPrivacy textAndInputPrivacy) {
        String string;
        int inputTypeVariation = textView.getInputType() & 0xFF0;
        int inputTypeClass = textView.getInputType() & 0xF;
        boolean isSensitiveText = inputTypeClass == 1 && ArraysKt.contains((Object[])SENSITIVE_TEXT_VARIATIONS, (Object)inputTypeVariation);
        boolean isSensitiveNumber = inputTypeClass == 2 && ArraysKt.contains((Object[])SENSITIVE_NUMBER_VARIATIONS, (Object)inputTypeVariation);
        boolean isSensitive = isSensitiveText || isSensitiveNumber || inputTypeClass == 3;
        switch (WhenMappings.$EnumSwitchMapping$0[textAndInputPrivacy.ordinal()]) {
            case 1: {
                if (isSensitive) {
                    string = "***";
                    break;
                }
                string = text;
                break;
            }
            case 2: 
            case 3: {
                string = "***";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String resolveCapturedHint(String hint, TextAndInputPrivacy textAndInputPrivacy) {
        return textAndInputPrivacy == TextAndInputPrivacy.MASK_ALL ? StringObfuscator.Companion.getStringObfuscator().obfuscate(hint) : hint;
    }

    static {
        Integer[] integerArray = new Integer[]{32, 112, 128, 144, 208, 224};
        SENSITIVE_TEXT_VARIATIONS = integerArray;
        integerArray = new Integer[]{16};
        SENSITIVE_NUMBER_VARIATIONS = integerArray;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/EditTextMapper$Companion;", "", "()V", "SENSITIVE_NUMBER_VARIATIONS", "", "", "getSENSITIVE_NUMBER_VARIATIONS$dd_sdk_android_session_replay_release", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "SENSITIVE_TEXT_VARIATIONS", "getSENSITIVE_TEXT_VARIATIONS$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Integer[] getSENSITIVE_TEXT_VARIATIONS$dd_sdk_android_session_replay_release() {
            return SENSITIVE_TEXT_VARIATIONS;
        }

        @NotNull
        public final Integer[] getSENSITIVE_NUMBER_VARIATIONS$dd_sdk_android_session_replay_release() {
            return SENSITIVE_NUMBER_VARIATIONS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAndInputPrivacy.values().length];
            try {
                nArray[TextAndInputPrivacy.MASK_SENSITIVE_INPUTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL_INPUTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

