/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.content.res.Resources;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.ImageViewUtils;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.sessionreplay.internal.utils.RectExtKt;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseAsyncBackgroundWireframeMapper;
import com.datadog.android.sessionreplay.recorder.resources.DrawableCopier;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rB7\b\u0010\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0010J.\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0017R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/ImageViewMapper;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper;", "Landroid/widget/ImageView;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "drawableCopier", "Lcom/datadog/android/sessionreplay/recorder/resources/DrawableCopier;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;Lcom/datadog/android/sessionreplay/recorder/resources/DrawableCopier;)V", "imageViewUtils", "Lcom/datadog/android/internal/utils/ImageViewUtils;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;Lcom/datadog/android/internal/utils/ImageViewUtils;Lcom/datadog/android/sessionreplay/recorder/resources/DrawableCopier;)V", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dd-sdk-android-session-replay_release"})
public class ImageViewMapper
extends BaseAsyncBackgroundWireframeMapper<ImageView> {
    @NotNull
    private final ImageViewUtils imageViewUtils;
    @NotNull
    private final DrawableCopier drawableCopier;

    public ImageViewMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper, @NotNull DrawableCopier drawableCopier) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        Intrinsics.checkNotNullParameter((Object)drawableCopier, (String)"drawableCopier");
        this(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper, ImageViewUtils.INSTANCE, drawableCopier);
    }

    public ImageViewMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper, @NotNull ImageViewUtils imageViewUtils, @NotNull DrawableCopier drawableCopier) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        Intrinsics.checkNotNullParameter((Object)imageViewUtils, (String)"imageViewUtils");
        Intrinsics.checkNotNullParameter((Object)drawableCopier, (String)"drawableCopier");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
        this.imageViewUtils = imageViewUtils;
        this.drawableCopier = drawableCopier;
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull ImageView view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        List wireframes;
        block1: {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
            Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            wireframes = new ArrayList();
            wireframes.addAll((Collection)super.map((View)view, mappingContext, asyncJobStatusCallback, internalLogger));
            Drawable drawable = view.getDrawable();
            if (drawable == null || (drawable = drawable.getCurrent()) == null) {
                return wireframes;
            }
            Drawable drawable2 = drawable;
            Rect parentRect = this.imageViewUtils.resolveParentRectAbsPosition((View)view);
            Rect contentRect = ImageViewUtils.resolveContentRectWithScaling$default((ImageViewUtils)this.imageViewUtils, (ImageView)view, (Drawable)drawable2, null, (int)4, null);
            Resources resources = view.getResources();
            float density = resources.getDisplayMetrics().density;
            MobileSegment.WireframeClip clipping = view.getCropToPadding() ? RectExtKt.toWireframeClip(this.imageViewUtils.calculateClipping(parentRect, contentRect, density)) : null;
            long contentXPosInDp = IntExtKt.densityNormalized((int)contentRect.left, (float)density);
            long contentYPosInDp = IntExtKt.densityNormalized((int)contentRect.top, (float)density);
            int contentWidthPx = contentRect.width();
            int contentHeightPx = contentRect.height();
            MobileSegment.Wireframe wireframe = mappingContext.getImageWireframeHelper().createImageWireframeByDrawable((View)view, mappingContext.getImagePrivacy(), wireframes.size(), contentXPosInDp, contentYPosInDp, contentWidthPx, contentHeightPx, true, drawable2, this.drawableCopier, asyncJobStatusCallback, clipping, null, null, "drawable", null);
            if (wireframe == null) break block1;
            MobileSegment.Wireframe it = wireframe;
            boolean bl = false;
            wireframes.add(it);
        }
        return wireframes;
    }
}

