/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.mapper;

import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.UiThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.internal.utils.IntExtKt;
import com.datadog.android.internal.utils.LongExtKt;
import com.datadog.android.sessionreplay.TextAndInputPrivacy;
import com.datadog.android.sessionreplay.internal.recorder.obfuscator.StringObfuscator;
import com.datadog.android.sessionreplay.model.MobileSegment;
import com.datadog.android.sessionreplay.recorder.MappingContext;
import com.datadog.android.sessionreplay.recorder.mapper.BaseAsyncBackgroundWireframeMapper;
import com.datadog.android.sessionreplay.utils.AsyncJobStatusCallback;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 8*\n\b\u0000\u0010\u0001 \u0000*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u00018B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ%\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0004\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0017\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J%\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014\u00a2\u0006\u0002\u0010'J\u0012\u0010(\u001a\u00020\"2\b\u0010)\u001a\u0004\u0018\u00010*H\u0002J\u0015\u0010+\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\u0015\u0010-\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\u0018\u0010.\u001a\u00020/2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u00100\u001a\u000201H\u0002J\u0015\u00102\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010,J\u0018\u00103\u001a\u0002042\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u00100\u001a\u000201H\u0002J\u001d\u00105\u001a\u0002062\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u00100\u001a\u000201H\u0002\u00a2\u0006\u0002\u00107\u00a8\u00069"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper;", "T", "Landroid/widget/TextView;", "Lcom/datadog/android/sessionreplay/recorder/mapper/BaseAsyncBackgroundWireframeMapper;", "viewIdentifierResolver", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "colorStringFormatter", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "viewBoundsResolver", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "drawableToColorMapper", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;)V", "createTextWireframe", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "textView", "mappingContext", "Lcom/datadog/android/sessionreplay/recorder/MappingContext;", "viewGlobalBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/GlobalBounds;)Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe$TextWireframe;", "map", "", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Wireframe;", "view", "asyncJobStatusCallback", "Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/recorder/MappingContext;Lcom/datadog/android/sessionreplay/utils/AsyncJobStatusCallback;Lcom/datadog/android/api/InternalLogger;)Ljava/util/List;", "resolveAlignment", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Alignment;", "resolveAlignmentFromGravity", "resolveCapturedText", "", "textAndInputPrivacy", "Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;", "isOption", "", "(Landroid/widget/TextView;Lcom/datadog/android/sessionreplay/TextAndInputPrivacy;Z)Ljava/lang/String;", "resolveFontFamily", "typeface", "Landroid/graphics/Typeface;", "resolveHintTextColor", "(Landroid/widget/TextView;)Ljava/lang/String;", "resolveLayoutText", "resolvePadding", "Lcom/datadog/android/sessionreplay/model/MobileSegment$Padding;", "pixelsDensity", "", "resolveTextColor", "resolveTextPosition", "Lcom/datadog/android/sessionreplay/model/MobileSegment$TextPosition;", "resolveTextStyle", "Lcom/datadog/android/sessionreplay/model/MobileSegment$TextStyle;", "(Landroid/widget/TextView;F)Lcom/datadog/android/sessionreplay/model/MobileSegment$TextStyle;", "Companion", "dd-sdk-android-session-replay_release"})
public class TextViewMapper<T extends TextView>
extends BaseAsyncBackgroundWireframeMapper<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String FIXED_INPUT_MASK = "***";
    @NotNull
    public static final String SANS_SERIF_FAMILY_NAME = "roboto, sans-serif";
    @NotNull
    public static final String SERIF_FAMILY_NAME = "serif";
    @NotNull
    public static final String MONOSPACE_FAMILY_NAME = "monospace";

    public TextViewMapper(@NotNull ViewIdentifierResolver viewIdentifierResolver, @NotNull ColorStringFormatter colorStringFormatter, @NotNull ViewBoundsResolver viewBoundsResolver, @NotNull DrawableToColorMapper drawableToColorMapper) {
        Intrinsics.checkNotNullParameter((Object)viewIdentifierResolver, (String)"viewIdentifierResolver");
        Intrinsics.checkNotNullParameter((Object)colorStringFormatter, (String)"colorStringFormatter");
        Intrinsics.checkNotNullParameter((Object)viewBoundsResolver, (String)"viewBoundsResolver");
        Intrinsics.checkNotNullParameter((Object)drawableToColorMapper, (String)"drawableToColorMapper");
        super(viewIdentifierResolver, colorStringFormatter, viewBoundsResolver, drawableToColorMapper);
    }

    @Override
    @UiThread
    @NotNull
    public List<MobileSegment.Wireframe> map(@NotNull T view, @NotNull MappingContext mappingContext, @NotNull AsyncJobStatusCallback asyncJobStatusCallback, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter(view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)asyncJobStatusCallback, (String)"asyncJobStatusCallback");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        List wireframes = new ArrayList();
        wireframes.addAll((Collection)super.map((View)view, mappingContext, asyncJobStatusCallback, internalLogger));
        float density = mappingContext.getSystemInformation().getScreenDensity();
        GlobalBounds viewGlobalBounds = this.getViewBoundsResolver().resolveViewGlobalBounds((View)view, density);
        wireframes.add(this.createTextWireframe(view, mappingContext, viewGlobalBounds));
        wireframes.addAll((Collection)mappingContext.getImageWireframeHelper().createCompoundDrawableWireframes((TextView)view, mappingContext, wireframes.size(), null, asyncJobStatusCallback));
        return wireframes;
    }

    @NotNull
    protected String resolveCapturedText(@NotNull T textView, @NotNull TextAndInputPrivacy textAndInputPrivacy, boolean isOption) {
        String string;
        Intrinsics.checkNotNullParameter(textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)textAndInputPrivacy, (String)"textAndInputPrivacy");
        String originalText = this.resolveLayoutText(textView);
        switch (WhenMappings.$EnumSwitchMapping$0[textAndInputPrivacy.ordinal()]) {
            case 1: {
                string = originalText;
                break;
            }
            case 2: {
                if (isOption) {
                    string = FIXED_INPUT_MASK;
                    break;
                }
                string = StringObfuscator.Companion.getStringObfuscator().obfuscate(originalText);
                break;
            }
            case 3: {
                if (isOption) {
                    string = FIXED_INPUT_MASK;
                    break;
                }
                string = originalText;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    private final String resolveLayoutText(T textView) {
        String string;
        Object object = textView.getLayout();
        if (object == null || (object = object.getText()) == null) {
            object = textView.getText();
        }
        if ((string = object != null ? object.toString() : null) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    protected final MobileSegment.Wireframe.TextWireframe createTextWireframe(@NotNull T textView, @NotNull MappingContext mappingContext, @NotNull GlobalBounds viewGlobalBounds) {
        Intrinsics.checkNotNullParameter(textView, (String)"textView");
        Intrinsics.checkNotNullParameter((Object)mappingContext, (String)"mappingContext");
        Intrinsics.checkNotNullParameter((Object)viewGlobalBounds, (String)"viewGlobalBounds");
        String capturedText = this.resolveCapturedText(textView, mappingContext.getTextAndInputPrivacy(), mappingContext.getHasOptionSelectorParent());
        return new MobileSegment.Wireframe.TextWireframe(this.resolveViewId((View)textView), viewGlobalBounds.getX(), viewGlobalBounds.getY(), viewGlobalBounds.getWidth(), viewGlobalBounds.getHeight(), null, null, null, capturedText, this.resolveTextStyle(textView, mappingContext.getSystemInformation().getScreenDensity()), this.resolveTextPosition((TextView)textView, mappingContext.getSystemInformation().getScreenDensity()), 32, null);
    }

    private final MobileSegment.TextStyle resolveTextStyle(T textView, float pixelsDensity) {
        return new MobileSegment.TextStyle(this.resolveFontFamily(textView.getTypeface()), LongExtKt.densityNormalized((long)((long)textView.getTextSize()), (float)pixelsDensity), this.resolveTextColor(textView));
    }

    private final String resolveTextColor(T textView) {
        CharSequence charSequence = textView.getText();
        return charSequence == null || charSequence.length() == 0 ? this.resolveHintTextColor(textView) : this.getColorStringFormatter().formatColorAndAlphaAsHexString(textView.getCurrentTextColor(), 255);
    }

    private final String resolveHintTextColor(T textView) {
        ColorStateList hintTextColors = textView.getHintTextColors();
        return hintTextColors != null ? this.getColorStringFormatter().formatColorAndAlphaAsHexString(hintTextColors.getDefaultColor(), 255) : this.getColorStringFormatter().formatColorAndAlphaAsHexString(textView.getCurrentTextColor(), 255);
    }

    private final String resolveFontFamily(Typeface typeface) {
        Typeface typeface2 = typeface;
        return Intrinsics.areEqual((Object)typeface2, (Object)Typeface.SANS_SERIF) ? SANS_SERIF_FAMILY_NAME : (Intrinsics.areEqual((Object)typeface2, (Object)Typeface.MONOSPACE) ? MONOSPACE_FAMILY_NAME : (Intrinsics.areEqual((Object)typeface2, (Object)Typeface.SERIF) ? SERIF_FAMILY_NAME : SANS_SERIF_FAMILY_NAME));
    }

    private final MobileSegment.TextPosition resolveTextPosition(TextView textView, float pixelsDensity) {
        return new MobileSegment.TextPosition(this.resolvePadding(textView, pixelsDensity), this.resolveAlignment(textView));
    }

    private final MobileSegment.Padding resolvePadding(TextView textView, float pixelsDensity) {
        return new MobileSegment.Padding(Long.valueOf(IntExtKt.densityNormalized((int)textView.getTotalPaddingTop(), (float)pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized((int)textView.getTotalPaddingBottom(), (float)pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized((int)textView.getTotalPaddingStart(), (float)pixelsDensity)), Long.valueOf(IntExtKt.densityNormalized((int)textView.getTotalPaddingEnd(), (float)pixelsDensity)));
    }

    private final MobileSegment.Alignment resolveAlignment(TextView textView) {
        MobileSegment.Alignment alignment;
        switch (textView.getTextAlignment()) {
            case 4: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.CENTER, MobileSegment.Vertical.CENTER);
                break;
            }
            case 3: 
            case 6: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.RIGHT, MobileSegment.Vertical.CENTER);
                break;
            }
            case 2: 
            case 5: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.LEFT, MobileSegment.Vertical.CENTER);
                break;
            }
            case 1: {
                alignment = this.resolveAlignmentFromGravity(textView);
                break;
            }
            default: {
                alignment = new MobileSegment.Alignment(MobileSegment.Horizontal.LEFT, MobileSegment.Vertical.CENTER);
            }
        }
        return alignment;
    }

    private final MobileSegment.Alignment resolveAlignmentFromGravity(TextView textView) {
        MobileSegment.Vertical vertical;
        MobileSegment.Horizontal horizontal;
        switch (textView.getGravity() & 7) {
            case 3: 
            case 0x800003: {
                horizontal = MobileSegment.Horizontal.LEFT;
                break;
            }
            case 5: 
            case 0x800005: {
                horizontal = MobileSegment.Horizontal.RIGHT;
                break;
            }
            case 17: {
                horizontal = MobileSegment.Horizontal.CENTER;
                break;
            }
            case 1: {
                horizontal = MobileSegment.Horizontal.CENTER;
                break;
            }
            default: {
                horizontal = MobileSegment.Horizontal.LEFT;
            }
        }
        MobileSegment.Horizontal horizontalAlignment = horizontal;
        switch (textView.getGravity() & 0x70) {
            case 48: {
                vertical = MobileSegment.Vertical.TOP;
                break;
            }
            case 80: {
                vertical = MobileSegment.Vertical.BOTTOM;
                break;
            }
            case 16: {
                vertical = MobileSegment.Vertical.CENTER;
                break;
            }
            case 17: {
                vertical = MobileSegment.Vertical.CENTER;
                break;
            }
            default: {
                vertical = MobileSegment.Vertical.CENTER;
            }
        }
        MobileSegment.Vertical verticalAlignment = vertical;
        return new MobileSegment.Alignment(horizontalAlignment, verticalAlignment);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/sessionreplay/recorder/mapper/TextViewMapper$Companion;", "", "()V", "FIXED_INPUT_MASK", "", "MONOSPACE_FAMILY_NAME", "SANS_SERIF_FAMILY_NAME", "SERIF_FAMILY_NAME", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TextAndInputPrivacy.values().length];
            try {
                nArray[TextAndInputPrivacy.MASK_SENSITIVE_INPUTS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TextAndInputPrivacy.MASK_ALL_INPUTS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

