/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.recorder.wrappers;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.lint.InternalApi;
import com.datadog.android.sessionreplay.recorder.wrappers.CanvasWrapper;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper;", "", "logger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/InternalLogger;)V", "createCanvas", "Landroid/graphics/Canvas;", "bitmap", "Landroid/graphics/Bitmap;", "Companion", "dd-sdk-android-session-replay_release"})
@InternalApi
public final class CanvasWrapper {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger logger;
    @NotNull
    private static final String INVALID_BITMAP = "Cannot create canvas: bitmap is either already recycled or immutable";
    @NotNull
    private static final String FAILED_TO_CREATE_CANVAS = "Failed to create canvas";

    public CanvasWrapper(@NotNull InternalLogger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
    }

    @Nullable
    public final Canvas createCanvas(@NotNull Bitmap bitmap) {
        Canvas canvas;
        Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
        if (bitmap.isRecycled() || !bitmap.isMutable()) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)createCanvas.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            return null;
        }
        try {
            canvas = new Canvas(bitmap);
        }
        catch (IllegalStateException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)createCanvas.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            canvas = null;
        }
        catch (RuntimeException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.logger, (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)createCanvas.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            canvas = null;
        }
        return canvas;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/sessionreplay/recorder/wrappers/CanvasWrapper$Companion;", "", "()V", "FAILED_TO_CREATE_CANVAS", "", "INVALID_BITMAP", "dd-sdk-android-session-replay_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

