/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.utils;

import android.graphics.BlendMode;
import android.graphics.BlendModeColorFilter;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.drawable.GradientDrawable;
import androidx.annotation.RequiresApi;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.utils.AndroidMDrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.LegacyDrawableToColorMapper;
import java.lang.reflect.Field;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u001f\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0014\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/datadog/android/sessionreplay/utils/AndroidQDrawableToColorMapper;", "Lcom/datadog/android/sessionreplay/utils/AndroidMDrawableToColorMapper;", "extensionMappers", "", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "(Ljava/util/List;)V", "resolveBlendModeColorFilter", "", "fillColor", "colorFilter", "Landroid/graphics/ColorFilter;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "resolveGradientDrawable", "drawable", "Landroid/graphics/drawable/GradientDrawable;", "(Landroid/graphics/drawable/GradientDrawable;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Integer;", "Companion", "dd-sdk-android-session-replay_release"})
@RequiresApi(value=29)
public class AndroidQDrawableToColorMapper
extends AndroidMDrawableToColorMapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<BlendMode> blendModesReturningBlendColor;
    @NotNull
    private static final List<BlendMode> blendModesReturningOriginalColor;

    public AndroidQDrawableToColorMapper(@NotNull List<? extends DrawableToColorMapper> extensionMappers) {
        Intrinsics.checkNotNullParameter(extensionMappers, (String)"extensionMappers");
        super(extensionMappers);
    }

    public /* synthetic */ AndroidQDrawableToColorMapper(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @Override
    @Nullable
    protected Integer resolveGradientDrawable(@NotNull GradientDrawable drawable, @NotNull InternalLogger internalLogger) {
        Integer n;
        Object object;
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            Field field = LegacyDrawableToColorMapper.Companion.getFillPaintField$dd_sdk_android_session_replay_release();
            object = field != null ? field.get(drawable) : null;
            object = object instanceof Paint ? (Paint)object : null;
        }
        catch (IllegalArgumentException e) {
            object = null;
        }
        catch (IllegalAccessException e) {
            object = null;
        }
        catch (ExceptionInInitializerError e) {
            object = null;
        }
        Object fillPaint = object;
        if (fillPaint == null) {
            return null;
        }
        ColorFilter colorFilter = fillPaint.getColorFilter();
        int fillColor = fillPaint.getColor();
        int fillAlpha = fillPaint.getAlpha() * drawable.getAlpha() / 255;
        if (fillAlpha == 0) {
            n = null;
        } else {
            if (colorFilter != null) {
                fillColor = this.resolveBlendModeColorFilter(fillColor, colorFilter, internalLogger);
            }
            n = this.mergeColorAndAlpha(fillColor, fillAlpha);
        }
        return n;
    }

    private final int resolveBlendModeColorFilter(int fillColor, ColorFilter colorFilter, InternalLogger internalLogger) {
        int n;
        if (colorFilter instanceof BlendModeColorFilter) {
            BlendMode blendMode = ((BlendModeColorFilter)colorFilter).getMode();
            if (blendModesReturningBlendColor.contains(blendMode)) {
                n = ((BlendModeColorFilter)colorFilter).getColor();
            } else if (blendModesReturningOriginalColor.contains(blendMode)) {
                n = fillColor;
            } else {
                internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.TELEMETRY, (Function0)new Function0<String>(colorFilter){
                    final /* synthetic */ ColorFilter $colorFilter;
                    {
                        this.$colorFilter = $colorFilter;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "No mapper found for gradient blend mode " + ((BlendModeColorFilter)this.$colorFilter).getMode();
                    }
                }, null, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"replay.gradient.blend_mode", (Object)((BlendModeColorFilter)colorFilter).getMode())));
                n = fillColor;
            }
        } else {
            internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.TELEMETRY, (Function0)new Function0<String>(colorFilter){
                final /* synthetic */ ColorFilter $colorFilter;
                {
                    this.$colorFilter = $colorFilter;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "No mapper found for gradient color filter " + this.$colorFilter.getClass();
                }
            }, null, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"replay.gradient.filter_type", (Object)colorFilter.getClass().getCanonicalName())));
            n = fillColor;
        }
        return n;
    }

    public AndroidQDrawableToColorMapper() {
        this(null, 1, null);
    }

    static {
        Object[] objectArray = new BlendMode[]{BlendMode.SRC, BlendMode.SRC_ATOP, BlendMode.SRC_IN, BlendMode.SRC_OUT, BlendMode.SRC_OVER};
        blendModesReturningBlendColor = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new BlendMode[]{BlendMode.DST, BlendMode.DST_ATOP, BlendMode.DST_IN, BlendMode.DST_OUT, BlendMode.DST_OVER};
        blendModesReturningOriginalColor = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/utils/AndroidQDrawableToColorMapper$Companion;", "", "()V", "blendModesReturningBlendColor", "", "Landroid/graphics/BlendMode;", "getBlendModesReturningBlendColor$dd_sdk_android_session_replay_release", "()Ljava/util/List;", "blendModesReturningOriginalColor", "getBlendModesReturningOriginalColor$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<BlendMode> getBlendModesReturningBlendColor$dd_sdk_android_session_replay_release() {
            return blendModesReturningBlendColor;
        }

        @NotNull
        public final List<BlendMode> getBlendModesReturningOriginalColor$dd_sdk_android_session_replay_release() {
            return blendModesReturningOriginalColor;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

