/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.utils;

import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.sessionreplay.utils.ColorStringFormatter;
import kotlin.Metadata;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0010\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/datadog/android/sessionreplay/utils/DefaultColorStringFormatter;", "Lcom/datadog/android/sessionreplay/utils/ColorStringFormatter;", "()V", "formatColorAndAlphaAsHexString", "", "color", "", "alpha", "formatColorAsHexString", "dd-sdk-android-session-replay_release"})
public final class DefaultColorStringFormatter
implements ColorStringFormatter {
    @NotNull
    public static final DefaultColorStringFormatter INSTANCE = new DefaultColorStringFormatter();

    private DefaultColorStringFormatter() {
    }

    @Override
    @NotNull
    public String formatColorAsHexString(int color) {
        long alpha = ((long)color & 0xFF000000L) >> 24;
        long colorRGBA = (long)color << 8 | alpha;
        String hexString = NumberExtKt.toHexString((long)(0xFFFFFFFFL & colorRGBA));
        return "#" + StringsKt.padStart((String)hexString, (int)8, (char)'0');
    }

    @Override
    @NotNull
    public String formatColorAndAlphaAsHexString(int color, int alpha) {
        long colorRGBA = (long)color << 8 | (long)alpha;
        String hexString = NumberExtKt.toHexString((long)(0xFFFFFFFFL & colorRGBA));
        return "#" + StringsKt.padStart((String)hexString, (int)8, (char)'0');
    }
}

