/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.utils;

import android.view.View;
import com.datadog.android.sessionreplay.utils.GlobalBounds;
import com.datadog.android.sessionreplay.utils.ViewBoundsResolver;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/datadog/android/sessionreplay/utils/DefaultViewBoundsResolver;", "Lcom/datadog/android/sessionreplay/utils/ViewBoundsResolver;", "()V", "resolveViewGlobalBounds", "Lcom/datadog/android/sessionreplay/utils/GlobalBounds;", "view", "Landroid/view/View;", "screenDensity", "", "resolveViewPaddedBounds", "dd-sdk-android-session-replay_release"})
public final class DefaultViewBoundsResolver
implements ViewBoundsResolver {
    @NotNull
    public static final DefaultViewBoundsResolver INSTANCE = new DefaultViewBoundsResolver();

    private DefaultViewBoundsResolver() {
    }

    @Override
    @NotNull
    public GlobalBounds resolveViewGlobalBounds(@NotNull View view, float screenDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float inverseDensity = screenDensity == 0.0f ? 1.0f : 1.0f / screenDensity;
        int[] coordinates = new int[2];
        view.getLocationOnScreen(coordinates);
        long x = (long)((float)coordinates[0] * inverseDensity);
        long y = (long)((float)coordinates[1] * inverseDensity);
        long width = (long)((float)view.getWidth() * inverseDensity);
        long height = (long)((float)view.getHeight() * inverseDensity);
        return new GlobalBounds(x, y, width, height);
    }

    @Override
    @NotNull
    public GlobalBounds resolveViewPaddedBounds(@NotNull View view, float screenDensity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        float inverseDensity = screenDensity == 0.0f ? 1.0f : 1.0f / screenDensity;
        int[] coordinates = new int[2];
        view.getLocationOnScreen(coordinates);
        long x = (long)((float)(coordinates[0] + view.getPaddingLeft()) * inverseDensity);
        long y = (long)((float)(coordinates[1] + view.getPaddingTop()) * inverseDensity);
        long width = (long)((float)(view.getWidth() - view.getPaddingLeft() - view.getPaddingRight()) * inverseDensity);
        long height = (long)((float)(view.getHeight() - view.getPaddingTop() - view.getPaddingBottom()) * inverseDensity);
        return new GlobalBounds(x, y, width, height);
    }
}

