/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.utils;

import android.view.View;
import com.datadog.android.sessionreplay.utils.ViewIdentifierResolver;
import java.security.SecureRandom;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\nH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/sessionreplay/utils/DefaultViewIdentifierResolver;", "Lcom/datadog/android/sessionreplay/utils/ViewIdentifierResolver;", "()V", "DATADOG_UNIQUE_IDENTIFIER_KEY_PREFIX", "", "secureRandom", "Ljava/security/SecureRandom;", "resolveChildUniqueIdentifier", "", "parent", "Landroid/view/View;", "childName", "(Landroid/view/View;Ljava/lang/String;)Ljava/lang/Long;", "resolveViewId", "view", "dd-sdk-android-session-replay_release"})
public final class DefaultViewIdentifierResolver
implements ViewIdentifierResolver {
    @NotNull
    public static final DefaultViewIdentifierResolver INSTANCE = new DefaultViewIdentifierResolver();
    @NotNull
    public static final String DATADOG_UNIQUE_IDENTIFIER_KEY_PREFIX = "DATADOG_UNIQUE_IDENTIFIER_";
    @NotNull
    private static final SecureRandom secureRandom = new SecureRandom();

    private DefaultViewIdentifierResolver() {
    }

    @Override
    public long resolveViewId(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        return System.identityHashCode(view);
    }

    @Override
    @Nullable
    public Long resolveChildUniqueIdentifier(@NotNull View parent, @NotNull String childName) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)childName, (String)"childName");
        int key = (DATADOG_UNIQUE_IDENTIFIER_KEY_PREFIX + childName).hashCode();
        Object uniqueIdentifier = parent.getTag(key);
        if (uniqueIdentifier != null) {
            l = uniqueIdentifier instanceof Long ? (Long)uniqueIdentifier : null;
        } else {
            long newUniqueIdentifier = secureRandom.nextInt();
            parent.setTag(key, (Object)newUniqueIdentifier);
            l = newUniqueIdentifier;
        }
        return l;
    }
}

