/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.sessionreplay.utils;

import android.annotation.SuppressLint;
import android.graphics.Paint;
import android.graphics.PorterDuffColorFilter;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.InsetDrawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.VectorDrawable;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.sessionreplay.utils.DrawableToColorMapper;
import com.datadog.android.sessionreplay.utils.LegacyDrawableToColorMapper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 #2\u00020\u0001:\u0001#B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0004J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0014\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\u0012\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u0014J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010\u0017J;\u0010\u0018\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u001a\b\u0002\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0002\u0010\u001dJ\u001f\u0010\u001e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\nH\u0014\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\"2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/datadog/android/sessionreplay/utils/LegacyDrawableToColorMapper;", "Lcom/datadog/android/sessionreplay/utils/DrawableToColorMapper;", "extensionMappers", "", "(Ljava/util/List;)V", "mapDrawableToColor", "", "drawable", "Landroid/graphics/drawable/Drawable;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Landroid/graphics/drawable/Drawable;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Integer;", "mergeColorAndAlpha", "color", "alpha", "resolveColorDrawable", "Landroid/graphics/drawable/ColorDrawable;", "(Landroid/graphics/drawable/ColorDrawable;)Ljava/lang/Integer;", "resolveGradientDrawable", "Landroid/graphics/drawable/GradientDrawable;", "(Landroid/graphics/drawable/GradientDrawable;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Integer;", "resolveInsetDrawable", "Landroid/graphics/drawable/InsetDrawable;", "(Landroid/graphics/drawable/InsetDrawable;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Integer;", "resolveLayerDrawable", "Landroid/graphics/drawable/LayerDrawable;", "predicate", "Lkotlin/Function2;", "", "(Landroid/graphics/drawable/LayerDrawable;Lcom/datadog/android/api/InternalLogger;Lkotlin/jvm/functions/Function2;)Ljava/lang/Integer;", "resolveRippleDrawable", "Landroid/graphics/drawable/RippleDrawable;", "(Landroid/graphics/drawable/RippleDrawable;Lcom/datadog/android/api/InternalLogger;)Ljava/lang/Integer;", "resolveShapeDrawable", "Landroid/graphics/drawable/ShapeDrawable;", "Companion", "dd-sdk-android-session-replay_release"})
@SourceDebugExtension(value={"SMAP\nLegacyDrawableToColorMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegacyDrawableToColorMapper.kt\ncom/datadog/android/sessionreplay/utils/LegacyDrawableToColorMapper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n1855#2,2:224\n1549#2:226\n1620#2,3:227\n288#2,2:230\n1#3:232\n*S KotlinDebug\n*F\n+ 1 LegacyDrawableToColorMapper.kt\ncom/datadog/android/sessionreplay/utils/LegacyDrawableToColorMapper\n*L\n34#1:224,2\n112#1:226\n112#1:227,3\n120#1:230,2\n*E\n"})
public class LegacyDrawableToColorMapper
implements DrawableToColorMapper {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<DrawableToColorMapper> extensionMappers;
    @SuppressLint(value={"DiscouragedPrivateApi"})
    @Nullable
    private static final Field fillPaintField;
    @Nullable
    private static final Field mColorField;

    public LegacyDrawableToColorMapper(@NotNull List<? extends DrawableToColorMapper> extensionMappers) {
        Intrinsics.checkNotNullParameter(extensionMappers, (String)"extensionMappers");
        this.extensionMappers = extensionMappers;
    }

    public /* synthetic */ LegacyDrawableToColorMapper(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @Override
    @Nullable
    public Integer mapDrawableToColor(@NotNull Drawable drawable, @NotNull InternalLogger internalLogger) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Iterable $this$forEach$iv = this.extensionMappers;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DrawableToColorMapper it = (DrawableToColorMapper)element$iv;
            boolean bl = false;
            Integer result2 = it.mapDrawableToColor(drawable, internalLogger);
            if (result2 == null) continue;
            return result2;
        }
        Drawable drawable2 = drawable;
        if (drawable2 instanceof ColorDrawable) {
            n = this.resolveColorDrawable((ColorDrawable)drawable);
        } else if (drawable2 instanceof RippleDrawable) {
            n = this.resolveRippleDrawable((RippleDrawable)drawable, internalLogger);
        } else if (drawable2 instanceof LayerDrawable) {
            n = LegacyDrawableToColorMapper.resolveLayerDrawable$default(this, (LayerDrawable)drawable, internalLogger, null, 4, null);
        } else if (drawable2 instanceof InsetDrawable) {
            n = this.resolveInsetDrawable((InsetDrawable)drawable, internalLogger);
        } else if (drawable2 instanceof GradientDrawable) {
            n = this.resolveGradientDrawable((GradientDrawable)drawable, internalLogger);
        } else if (drawable2 instanceof ShapeDrawable) {
            n = this.resolveShapeDrawable((ShapeDrawable)drawable, internalLogger);
        } else if (drawable2 instanceof BitmapDrawable ? true : drawable2 instanceof VectorDrawable) {
            n = null;
        } else {
            String string = drawable.getClass().getCanonicalName();
            if (string == null) {
                string = drawable.getClass().getName();
            }
            String drawableType = string;
            internalLogger.log(InternalLogger.Level.INFO, InternalLogger.Target.TELEMETRY, (Function0)new Function0<String>(drawableType){
                final /* synthetic */ String $drawableType;
                {
                    this.$drawableType = $drawableType;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return "No mapper found for drawable " + this.$drawableType;
                }
            }, null, true, MapsKt.mapOf((Pair)TuplesKt.to((Object)"replay.drawable.type", (Object)drawableType)));
            n = null;
        }
        Integer result3 = n;
        return result3;
    }

    protected int resolveShapeDrawable(@NotNull ShapeDrawable drawable, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return drawable.getPaint().getColor();
    }

    @Nullable
    protected Integer resolveColorDrawable(@NotNull ColorDrawable drawable) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        return this.mergeColorAndAlpha(drawable.getColor(), drawable.getAlpha());
    }

    @Nullable
    protected Integer resolveRippleDrawable(@NotNull RippleDrawable drawable, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        return LegacyDrawableToColorMapper.resolveLayerDrawable$default(this, (LayerDrawable)drawable, internalLogger, null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected Integer resolveLayerDrawable(@NotNull LayerDrawable drawable, @NotNull InternalLogger internalLogger, @NotNull Function2<? super Integer, ? super Drawable, Boolean> predicate) {
        Object v0;
        block2: {
            void $this$firstOrNull$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
            Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
            Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
            Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)drawable.getNumberOfLayers());
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void idx;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Drawable childDrawable = drawable.getDrawable((int)idx);
                collection.add(childDrawable != null && ((Boolean)predicate.invoke((Object)((int)idx), (Object)childDrawable)).booleanValue() ? this.mapDrawableToColor(childDrawable, internalLogger) : null);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Integer it = (Integer)element$iv;
                boolean bl = false;
                if (!(it != null)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ Integer resolveLayerDrawable$default(LegacyDrawableToColorMapper legacyDrawableToColorMapper, LayerDrawable layerDrawable, InternalLogger internalLogger, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveLayerDrawable");
        }
        if ((n & 4) != 0) {
            function2 = resolveLayerDrawable.1.INSTANCE;
        }
        return legacyDrawableToColorMapper.resolveLayerDrawable(layerDrawable, internalLogger, (Function2<? super Integer, ? super Drawable, Boolean>)function2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    protected Integer resolveGradientDrawable(@NotNull GradientDrawable drawable, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        try {
            v0 = LegacyDrawableToColorMapper.fillPaintField;
            var4_3 = v0 != null ? v0.get(drawable) : null;
            var4_3 = var4_3 instanceof Paint != false ? (Paint)var4_3 : null;
        }
        catch (IllegalArgumentException e) {
            var4_3 = null;
        }
        catch (IllegalAccessException e) {
            var4_3 = null;
        }
        catch (ExceptionInInitializerError e) {
            var4_3 = null;
        }
        fillPaint = var4_3;
        if (fillPaint == null) {
            return null;
        }
        try {
            v1 = fillPaint.getColorFilter();
            if (v1 == null) ** GOTO lbl-1000
            it = v1;
            $i$a$-let-LegacyDrawableToColorMapper$resolveGradientDrawable$filterColor$1 = false;
            v2 = LegacyDrawableToColorMapper.mColorField;
            v3 = var9_13 = v2 != null ? v2.get(it) : null;
            v4 = var9_13 instanceof Integer ? (Integer)var9_13 : null;
            v1 = v4;
            if (v4 != null) {
                v5 = v1.intValue();
            } else lbl-1000:
            // 2 sources

            {
                v5 = fillPaint.getColor();
            }
            e = v5;
        }
        catch (IllegalArgumentException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)resolveGradientDrawable.filterColor.2.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            e = fillPaint.getColor();
        }
        catch (IllegalAccessException e) {
            InternalLogger.DefaultImpls.log$default((InternalLogger)internalLogger, (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)resolveGradientDrawable.filterColor.3.INSTANCE, (Throwable)e, (boolean)false, null, (int)48, null);
            e = fillPaint.getColor();
        }
        filterColor = e;
        fillAlpha = fillPaint.getAlpha() * drawable.getAlpha() / 255;
        return fillAlpha == 0 ? null : Integer.valueOf(this.mergeColorAndAlpha(filterColor, fillAlpha));
    }

    @Nullable
    protected Integer resolveInsetDrawable(@NotNull InsetDrawable drawable, @NotNull InternalLogger internalLogger) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)drawable, (String)"drawable");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Drawable drawable2 = drawable.getDrawable();
        if (drawable2 != null) {
            Drawable it = drawable2;
            boolean bl = false;
            n = this.mapDrawableToColor(it, internalLogger);
        } else {
            n = null;
        }
        return n;
    }

    protected final int mergeColorAndAlpha(int color, int alpha) {
        return (int)((long)color & 0xFFFFFFFFL | (long)alpha << 24);
    }

    public LegacyDrawableToColorMapper() {
        this(null, 1, null);
    }

    static {
        Field field;
        Companion = new Companion(null);
        try {
            Field $this$fillPaintField_u24lambda_u245 = field = GradientDrawable.class.getDeclaredField("mFillPaint");
            boolean bl = false;
            $this$fillPaintField_u24lambda_u245.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        catch (SecurityException e) {
            field = null;
        }
        catch (NullPointerException e) {
            field = null;
        }
        fillPaintField = field;
        try {
            Field $this$mColorField_u24lambda_u246 = field = PorterDuffColorFilter.class.getDeclaredField("mColor");
            boolean bl = false;
            $this$mColorField_u24lambda_u246.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            field = null;
        }
        catch (SecurityException e) {
            field = null;
        }
        catch (NullPointerException e) {
            field = null;
        }
        mColorField = field;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0080\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\t\u0010\u0002\u001a\u0004\b\n\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/datadog/android/sessionreplay/utils/LegacyDrawableToColorMapper$Companion;", "", "()V", "fillPaintField", "Ljava/lang/reflect/Field;", "getFillPaintField$dd_sdk_android_session_replay_release$annotations", "getFillPaintField$dd_sdk_android_session_replay_release", "()Ljava/lang/reflect/Field;", "mColorField", "getMColorField$dd_sdk_android_session_replay_release$annotations", "getMColorField$dd_sdk_android_session_replay_release", "dd-sdk-android-session-replay_release"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Field getFillPaintField$dd_sdk_android_session_replay_release() {
            return fillPaintField;
        }

        public static /* synthetic */ void getFillPaintField$dd_sdk_android_session_replay_release$annotations() {
        }

        @Nullable
        public final Field getMColorField$dd_sdk_android_session_replay_release() {
            return mColorField;
        }

        public static /* synthetic */ void getMColorField$dd_sdk_android_session_replay_release$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

