/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.opentelemetry;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.Feature;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.trace.InternalCoreWriterProvider;
import com.datadog.android.trace.TracingHeaderType;
import com.datadog.android.trace.opentelemetry.OtelTracerProvider;
import com.datadog.android.trace.opentelemetry.internal.FeatureSdkCoreExtKt;
import com.datadog.android.trace.opentelemetry.internal.MiscUtilsKt;
import com.datadog.android.trace.opentelemetry.internal.NoOpCoreTracerWriter;
import com.datadog.opentelemetry.trace.OtelTracerBuilder;
import com.datadog.trace.api.IdGenerationStrategy;
import com.datadog.trace.api.scopemanager.ScopeListener;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import com.datadog.trace.common.writer.Writer;
import com.datadog.trace.core.CoreTracer;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;
import io.opentelemetry.api.trace.TracerProvider;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\rH\u0096\u0002J\u0019\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rH\u0096\u0002J\u0014\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\rH\u0002J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\rH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/datadog/android/trace/opentelemetry/OtelTracerProvider;", "Lio/opentelemetry/api/trace/TracerProvider;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "coreTracer", "Lcom/datadog/trace/bootstrap/instrumentation/api/AgentTracer$TracerAPI;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "bundleWithRumEnabled", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/trace/bootstrap/instrumentation/api/AgentTracer$TracerAPI;Lcom/datadog/android/api/InternalLogger;Z)V", "tracers", "", "", "Lio/opentelemetry/api/trace/Tracer;", "get", "instrumentationName", "instrumentationVersion", "resolveDecoratorFromRumContext", "Lkotlin/Function1;", "Lio/opentelemetry/api/trace/SpanBuilder;", "resolveInstrumentationScopeName", "instrumentationScopeName", "resolveSpanBuilderDecorator", "toString", "tracerBuilder", "Lio/opentelemetry/api/trace/TracerBuilder;", "Builder", "Companion", "dd-sdk-android-trace-otel_release"})
@SourceDebugExtension(value={"SMAP\nOtelTracerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtelTracerProvider.kt\ncom/datadog/android/trace/opentelemetry/OtelTracerProvider\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,398:1\n107#2:399\n79#2,22:400\n*S KotlinDebug\n*F\n+ 1 OtelTracerProvider.kt\ncom/datadog/android/trace/opentelemetry/OtelTracerProvider\n*L\n304#1:399\n304#1:400,22\n*E\n"})
public final class OtelTracerProvider
implements TracerProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final AgentTracer.TracerAPI coreTracer;
    @NotNull
    private final InternalLogger internalLogger;
    private final boolean bundleWithRumEnabled;
    @NotNull
    private final Map<String, Tracer> tracers;
    @NotNull
    public static final String IS_OPENTELEMETRY_ENABLED_CONFIG_KEY = "is_opentelemetry_enabled";
    @NotNull
    public static final String OPENTELEMETRY_API_VERSION_CONFIG_KEY = "opentelemetry_api_version";
    @NotNull
    public static final String RUM_APPLICATION_ID_KEY = "application_id";
    @NotNull
    public static final String RUM_SESSION_ID_KEY = "session_id";
    @NotNull
    public static final String RUM_VIEW_ID_KEY = "view_id";
    @NotNull
    public static final String RUM_ACTION_ID_KEY = "action_id";
    @NotNull
    private static final Function1<SpanBuilder, SpanBuilder> NO_OP_SPAN_BUILDER_DECORATOR;
    @NotNull
    public static final String TRACER_ALREADY_EXISTS_WARNING_MESSAGE = "Tracer for %s already exists. Returning existing instance.";
    @NotNull
    public static final String DEFAULT_TRACER_NAME = "android";
    public static final double KEEP_ALL_SAMPLE_RATE_PERCENT = 100.0;
    @NotNull
    public static final String TRACING_NOT_ENABLED_ERROR_MESSAGE = "You're trying to create an OtelTracerProvider instance, but either the SDK was not initialized or the Tracing feature was not registered. No tracing data will be sent.";
    @NotNull
    public static final String WRITER_PROVIDER_INTERFACE_NOT_IMPLEMENTED_ERROR_MESSAGE = "The Tracing feature is not implementing the InternalCoreWriterProvider interface. No tracing data will be sent.";
    @NotNull
    public static final String DEFAULT_SERVICE_NAME_IS_MISSING_ERROR_MESSAGE = "Default service name is missing during OtelTracerProvider creation, did you initialize SDK?";
    @NotNull
    public static final String RUM_CONTEXT_MISSING_ERROR_MESSAGE = "You are trying to bundle the traces with a RUM context, but the RUM context is missing. You should check if the RUM feature is enabled for your SDK instance.";
    public static final int DEFAULT_PARTIAL_MIN_FLUSH = 5;

    public OtelTracerProvider(@NotNull FeatureSdkCore sdkCore, @NotNull AgentTracer.TracerAPI coreTracer, @NotNull InternalLogger internalLogger, boolean bundleWithRumEnabled) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)coreTracer, (String)"coreTracer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.sdkCore = sdkCore;
        this.coreTracer = coreTracer;
        this.internalLogger = internalLogger;
        this.bundleWithRumEnabled = bundleWithRumEnabled;
        this.tracers = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Tracer get(@NotNull String instrumentationName) {
        Tracer tracer;
        Intrinsics.checkNotNullParameter((Object)instrumentationName, (String)"instrumentationName");
        Tracer tracer2 = this.tracers.get(instrumentationName);
        if (tracer2 == null) {
            void var3_3;
            Tracer newTracer = this.tracerBuilder(instrumentationName).build();
            Intrinsics.checkNotNullExpressionValue((Object)newTracer, (String)"newTracer");
            this.tracers.put(instrumentationName, newTracer);
            tracer = var3_3;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(instrumentationName){
                final /* synthetic */ String $instrumentationName;
                {
                    this.$instrumentationName = $instrumentationName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Tracer for %s already exists. Returning existing instance.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$instrumentationName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            tracer = tracer2;
        }
        return tracer;
    }

    @NotNull
    public Tracer get(@NotNull String instrumentationName, @NotNull String instrumentationVersion) {
        Tracer tracer;
        Intrinsics.checkNotNullParameter((Object)instrumentationName, (String)"instrumentationName");
        Intrinsics.checkNotNullParameter((Object)instrumentationVersion, (String)"instrumentationVersion");
        Tracer tracer2 = this.tracers.get(instrumentationName);
        if (tracer2 == null) {
            Tracer newTracer = this.tracerBuilder(instrumentationName).setInstrumentationVersion(instrumentationVersion).build();
            Intrinsics.checkNotNullExpressionValue((Object)newTracer, (String)"newTracer");
            this.tracers.put(instrumentationName, newTracer);
            tracer = newTracer;
        } else {
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.DEBUG, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)((Function0)new Function0<String>(instrumentationName){
                final /* synthetic */ String $instrumentationName;
                {
                    this.$instrumentationName = $instrumentationName;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Tracer for %s already exists. Returning existing instance.";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$instrumentationName};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(locale, this, *args)");
                    return string2;
                }
            }), null, (boolean)false, null, (int)56, null);
            tracer = tracer2;
        }
        return tracer;
    }

    @NotNull
    public TracerBuilder tracerBuilder(@NotNull String instrumentationScopeName) {
        Intrinsics.checkNotNullParameter((Object)instrumentationScopeName, (String)"instrumentationScopeName");
        String resolvedInstrumentationScopeName = this.resolveInstrumentationScopeName(instrumentationScopeName);
        return new OtelTracerBuilder(resolvedInstrumentationScopeName, this.coreTracer, this.internalLogger, arg_0 -> OtelTracerProvider.tracerBuilder$lambda$0(this.resolveSpanBuilderDecorator(), arg_0));
    }

    private final String resolveInstrumentationScopeName(String instrumentationScopeName) {
        String $this$trim$iv = instrumentationScopeName;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0 ? DEFAULT_TRACER_NAME : instrumentationScopeName;
    }

    private final Function1<SpanBuilder, SpanBuilder> resolveSpanBuilderDecorator() {
        return this.bundleWithRumEnabled ? this.resolveDecoratorFromRumContext() : NO_OP_SPAN_BUILDER_DECORATOR;
    }

    private final Function1<SpanBuilder, SpanBuilder> resolveDecoratorFromRumContext() {
        return (Function1)new Function1<SpanBuilder, SpanBuilder>(this){
            final /* synthetic */ OtelTracerProvider this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final SpanBuilder invoke(@NotNull SpanBuilder spanBuilder) {
                String actionId;
                Intrinsics.checkNotNullParameter((Object)spanBuilder, (String)"spanBuilder");
                Map rumContext = OtelTracerProvider.access$getSdkCore$p(this.this$0).getFeatureContext("rum");
                V v = rumContext.get("application_id");
                String applicationId = v instanceof String ? (String)v : null;
                V v2 = rumContext.get("session_id");
                String sessionId = v2 instanceof String ? (String)v2 : null;
                V v3 = rumContext.get("view_id");
                String viewId = v3 instanceof String ? (String)v3 : null;
                V v4 = rumContext.get("action_id");
                String string = actionId = v4 instanceof String ? (String)v4 : null;
                if (applicationId != null && sessionId != null && viewId != null) {
                    spanBuilder.setAttribute("application_id", applicationId);
                    spanBuilder.setAttribute("session_id", sessionId);
                    spanBuilder.setAttribute("view.id", viewId);
                    if (actionId != null) {
                        spanBuilder.setAttribute("user_action.id", actionId);
                    }
                } else {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)OtelTracerProvider.access$getInternalLogger$p(this.this$0), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)resolveDecoratorFromRumContext.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                }
                return spanBuilder;
            }
        };
    }

    @NotNull
    public String toString() {
        return "OtelTracerProvider/" + super.toString();
    }

    private static final SpanBuilder tracerBuilder$lambda$0(Function1 $tmp0, SpanBuilder t) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (SpanBuilder)$tmp0.invoke((Object)t);
    }

    public static final /* synthetic */ FeatureSdkCore access$getSdkCore$p(OtelTracerProvider $this) {
        return $this.sdkCore;
    }

    public static final /* synthetic */ InternalLogger access$getInternalLogger$p(OtelTracerProvider $this) {
        return $this.internalLogger;
    }

    static {
        MiscUtilsKt.executeIfJavaFunctionPackageExists(null, null, Companion.1.INSTANCE);
        NO_OP_SPAN_BUILDER_DECORATOR = Companion.NO_OP_SPAN_BUILDER_DECORATOR.1.INSTANCE;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u000bJ\u0006\u0010\u001b\u001a\u00020\u001cJ\r\u0010\u001d\u001a\u00020\u001eH\u0000\u00a2\u0006\u0002\b\u001fJ\u000e\u0010 \u001a\u00020\u00002\u0006\u0010!\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020\rJ\u0010\u0010$\u001a\u00020\u00002\b\b\u0001\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\u000bJ\u0010\u0010'\u001a\u00020\u00002\b\b\u0001\u0010\u0014\u001a\u00020\rJ\u0014\u0010(\u001a\u00020\u00002\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u00020\u000b8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/datadog/android/trace/opentelemetry/OtelTracerProvider$Builder;", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "(Lcom/datadog/android/api/SdkCore;)V", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;)V", "bundleWithRumEnabled", "", "globalTags", "", "", "partialFlushThreshold", "", "sampleRate", "", "Ljava/lang/Double;", "serviceName", "getServiceName", "()Ljava/lang/String;", "traceRateLimit", "tracingHeaderTypes", "", "Lcom/datadog/android/trace/TracingHeaderType;", "addTag", "key", "value", "build", "Lio/opentelemetry/api/trace/TracerProvider;", "properties", "Ljava/util/Properties;", "properties$dd_sdk_android_trace_otel_release", "setBundleWithRumEnabled", "enabled", "setPartialFlushThreshold", "threshold", "setSampleRate", "setService", "service", "setTraceRateLimit", "setTracingHeaderTypes", "headerTypes", "dd-sdk-android-trace-otel_release"})
    @SourceDebugExtension(value={"SMAP\nOtelTracerProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OtelTracerProvider.kt\ncom/datadog/android/trace/opentelemetry/OtelTracerProvider$Builder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,398:1\n125#2:399\n152#2,3:400\n*S KotlinDebug\n*F\n+ 1 OtelTracerProvider.kt\ncom/datadog/android/trace/opentelemetry/OtelTracerProvider$Builder\n*L\n270#1:399\n270#1:400,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final FeatureSdkCore sdkCore;
        @NotNull
        private Set<? extends TracingHeaderType> tracingHeaderTypes;
        @Nullable
        private Double sampleRate;
        private int traceRateLimit;
        @NotNull
        private String serviceName;
        private int partialFlushThreshold;
        @NotNull
        private final Map<String, String> globalTags;
        private boolean bundleWithRumEnabled;

        public Builder(@NotNull FeatureSdkCore sdkCore) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            this.sdkCore = sdkCore;
            Object[] objectArray = new TracingHeaderType[]{TracingHeaderType.DATADOG, TracingHeaderType.TRACECONTEXT};
            this.tracingHeaderTypes = SetsKt.setOf((Object[])objectArray);
            this.traceRateLimit = Integer.MAX_VALUE;
            this.serviceName = "";
            this.partialFlushThreshold = 5;
            this.globalTags = new LinkedHashMap();
            this.bundleWithRumEnabled = true;
        }

        /*
         * WARNING - void declaration
         */
        private final String getServiceName() {
            CharSequence charSequence;
            CharSequence charSequence2 = this.serviceName;
            if (charSequence2.length() == 0) {
                void var3_3;
                boolean bl = false;
                String service = this.sdkCore.getService();
                if (((CharSequence)service).length() == 0) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)serviceName.1.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                }
                charSequence = var3_3;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        @JvmOverloads
        public Builder(@NotNull SdkCore sdkCore) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            this((FeatureSdkCore)sdkCore);
        }

        public /* synthetic */ Builder(SdkCore sdkCore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                sdkCore = Datadog.getInstance$default(null, (int)1, null);
            }
            this(sdkCore);
        }

        @NotNull
        public final TracerProvider build() {
            TracerProvider tracerProvider = MiscUtilsKt.executeIfJavaFunctionPackageExists(this.sdkCore.getInternalLogger(), TracerProvider.noop(), (Function0)new Function0<TracerProvider>(this){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final TracerProvider invoke() {
                    InternalCoreWriterProvider internalCoreWriterProvider;
                    FeatureScope featureScope = Builder.access$getSdkCore$p(this.this$0).getFeature("tracing");
                    Feature tracingFeature = featureScope != null ? featureScope.unwrap() : null;
                    InternalCoreWriterProvider internalCoreWriterProvider2 = internalCoreWriterProvider = tracingFeature instanceof InternalCoreWriterProvider ? (InternalCoreWriterProvider)tracingFeature : null;
                    if (tracingFeature == null) {
                        InternalLogger.DefaultImpls.log$default((InternalLogger)Builder.access$getSdkCore$p(this.this$0).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)build.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                    } else if (internalCoreWriterProvider == null) {
                        InternalLogger.DefaultImpls.log$default((InternalLogger)Builder.access$getSdkCore$p(this.this$0).getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.MAINTAINER, (Function0)build.2.INSTANCE, null, (boolean)false, null, (int)56, null);
                    } else {
                        Builder.access$getSdkCore$p(this.this$0).updateFeatureContext("tracing", (Function1)build.3.INSTANCE);
                    }
                    CoreTracer.CoreTracerBuilder coreTracerBuilder = new CoreTracer.CoreTracerBuilder(Builder.access$getSdkCore$p(this.this$0).getInternalLogger()).withProperties(this.this$0.properties$dd_sdk_android_trace_otel_release()).serviceName(Builder.access$getServiceName(this.this$0));
                    InternalCoreWriterProvider internalCoreWriterProvider3 = internalCoreWriterProvider;
                    if (internalCoreWriterProvider3 == null || (internalCoreWriterProvider3 = internalCoreWriterProvider3.getCoreTracerWriter()) == null) {
                        internalCoreWriterProvider3 = new NoOpCoreTracerWriter();
                    }
                    CoreTracer coreTracer = coreTracerBuilder.writer((Writer)internalCoreWriterProvider3).partialFlushMinSpans(Builder.access$getPartialFlushThreshold$p(this.this$0)).idGenerationStrategy(IdGenerationStrategy.fromName((String)"SECURE_RANDOM", (boolean)false)).build();
                    coreTracer.addScopeListener(new ScopeListener(coreTracer, this.this$0){
                        final /* synthetic */ CoreTracer $coreTracer;
                        final /* synthetic */ Builder this$0;
                        {
                            this.$coreTracer = $coreTracer;
                            this.this$0 = $receiver;
                        }

                        public void afterScopeActivated() {
                            AgentSpan.Context activeSpanContext;
                            AgentSpan agentSpan = this.$coreTracer.activeSpan();
                            Object object = activeSpanContext = agentSpan != null ? agentSpan.context() : null;
                            if (activeSpanContext != null) {
                                String activeSpanId = String.valueOf(activeSpanContext.getSpanId());
                                String string = activeSpanContext.getTraceId().toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"activeSpanContext.traceId.toString()");
                                String activeTraceId = string;
                                FeatureSdkCoreExtKt.addActiveTraceToContext(Builder.access$getSdkCore$p(this.this$0), activeTraceId, activeSpanId);
                            }
                        }

                        public void afterScopeClosed() {
                            FeatureSdkCoreExtKt.removeActiveTraceFromContext(Builder.access$getSdkCore$p(this.this$0));
                        }
                    });
                    FeatureSdkCore featureSdkCore = Builder.access$getSdkCore$p(this.this$0);
                    Intrinsics.checkNotNullExpressionValue((Object)coreTracer, (String)"coreTracer");
                    return new OtelTracerProvider(featureSdkCore, (AgentTracer.TracerAPI)coreTracer, Builder.access$getSdkCore$p(this.this$0).getInternalLogger(), Builder.access$getBundleWithRumEnabled$p(this.this$0));
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)tracerProvider, (String)"fun build(): TracerProvi\u2026)\n            }\n        }");
            return tracerProvider;
        }

        @NotNull
        public final Builder setTracingHeaderTypes(@NotNull Set<? extends TracingHeaderType> headerTypes) {
            Intrinsics.checkNotNullParameter(headerTypes, (String)"headerTypes");
            this.tracingHeaderTypes = headerTypes;
            return this;
        }

        @NotNull
        public final Builder setService(@NotNull String service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.serviceName = service;
            return this;
        }

        @NotNull
        public final Builder setPartialFlushThreshold(int threshold) {
            this.partialFlushThreshold = threshold;
            return this;
        }

        @NotNull
        public final Builder addTag(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.globalTags.put(key, value);
            return this;
        }

        @NotNull
        public final Builder setSampleRate(@FloatRange(from=0.0, to=100.0) double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @NotNull
        public final Builder setTraceRateLimit(@IntRange(from=1L, to=0x7FFFFFFFL) int traceRateLimit) {
            this.traceRateLimit = traceRateLimit;
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Properties properties$dd_sdk_android_trace_otel_release() {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Properties properties = new Properties();
            Map<String, String> map = this.globalTags;
            String string = "trace.span.tags";
            Properties properties2 = properties;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((CallSite)((Object)(it.getKey() + ":" + it.getValue())));
            }
            collection = (List)destination$iv$iv;
            properties2.setProperty(string, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            properties.setProperty("trace.rate.limit", String.valueOf(this.traceRateLimit));
            Double d = this.sampleRate;
            if (d != null) {
                double it = ((Number)d).doubleValue();
                boolean bl = false;
                properties.setProperty("trace.sample.rate", String.valueOf(it / 100.0));
            }
            String propagationStyles = CollectionsKt.joinToString$default((Iterable)this.tracingHeaderTypes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            properties.setProperty("propagation.style.extract", propagationStyles);
            properties.setProperty("propagation.style.inject", propagationStyles);
            return properties;
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }

        public static final /* synthetic */ FeatureSdkCore access$getSdkCore$p(Builder $this) {
            return $this.sdkCore;
        }

        public static final /* synthetic */ String access$getServiceName(Builder $this) {
            return $this.getServiceName();
        }

        public static final /* synthetic */ int access$getPartialFlushThreshold$p(Builder $this) {
            return $this.partialFlushThreshold;
        }

        public static final /* synthetic */ boolean access$getBundleWithRumEnabled$p(Builder $this) {
            return $this.bundleWithRumEnabled;
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0080T\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/trace/opentelemetry/OtelTracerProvider$Companion;", "", "()V", "DEFAULT_PARTIAL_MIN_FLUSH", "", "DEFAULT_SERVICE_NAME_IS_MISSING_ERROR_MESSAGE", "", "DEFAULT_TRACER_NAME", "IS_OPENTELEMETRY_ENABLED_CONFIG_KEY", "KEEP_ALL_SAMPLE_RATE_PERCENT", "", "NO_OP_SPAN_BUILDER_DECORATOR", "Lkotlin/Function1;", "Lio/opentelemetry/api/trace/SpanBuilder;", "getNO_OP_SPAN_BUILDER_DECORATOR$dd_sdk_android_trace_otel_release", "()Lkotlin/jvm/functions/Function1;", "OPENTELEMETRY_API_VERSION_CONFIG_KEY", "RUM_ACTION_ID_KEY", "RUM_APPLICATION_ID_KEY", "RUM_CONTEXT_MISSING_ERROR_MESSAGE", "RUM_SESSION_ID_KEY", "RUM_VIEW_ID_KEY", "TRACER_ALREADY_EXISTS_WARNING_MESSAGE", "TRACING_NOT_ENABLED_ERROR_MESSAGE", "WRITER_PROVIDER_INTERFACE_NOT_IMPLEMENTED_ERROR_MESSAGE", "dd-sdk-android-trace-otel_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Function1<SpanBuilder, SpanBuilder> getNO_OP_SPAN_BUILDER_DECORATOR$dd_sdk_android_trace_otel_release() {
            return NO_OP_SPAN_BUILDER_DECORATOR;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

