/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.opentelemetry.internal;

import com.datadog.android.trace.opentelemetry.internal.OtelScope;
import com.datadog.opentelemetry.trace.OtelSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J$\u0010\f\u001a\u0004\u0018\u0001H\r\"\u0004\b\u0000\u0010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J)\u0010\u0013\u001a\u00020\u0001\"\u0004\b\u0000\u0010\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\r0\u000f2\u0006\u0010\u0015\u001a\u0002H\rH\u0016\u00a2\u0006\u0002\u0010\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/trace/opentelemetry/internal/OtelContext;", "Lio/opentelemetry/context/Context;", "wrapped", "currentSpan", "Lio/opentelemetry/api/trace/Span;", "rootSpan", "(Lio/opentelemetry/context/Context;Lio/opentelemetry/api/trace/Span;Lio/opentelemetry/api/trace/Span;)V", "getCurrentSpan$dd_sdk_android_trace_otel_release", "()Lio/opentelemetry/api/trace/Span;", "getRootSpan$dd_sdk_android_trace_otel_release", "getWrapped$dd_sdk_android_trace_otel_release", "()Lio/opentelemetry/context/Context;", "get", "V", "key", "Lio/opentelemetry/context/ContextKey;", "(Lio/opentelemetry/context/ContextKey;)Ljava/lang/Object;", "makeCurrent", "Lio/opentelemetry/context/Scope;", "with", "k1", "v1", "(Lio/opentelemetry/context/ContextKey;Ljava/lang/Object;)Lio/opentelemetry/context/Context;", "Companion", "dd-sdk-android-trace-otel_release"})
public final class OtelContext
implements Context {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context wrapped;
    @NotNull
    private final Span currentSpan;
    @NotNull
    private final Span rootSpan;
    @NotNull
    public static final String OTEL_CONTEXT_SPAN_KEY = "opentelemetry-trace-span-key";
    @NotNull
    public static final String OTEL_CONTEXT_ROOT_SPAN_KEY = "opentelemetry-traces-local-root-span";

    public OtelContext(@NotNull Context wrapped, @NotNull Span currentSpan, @NotNull Span rootSpan) {
        Intrinsics.checkNotNullParameter((Object)wrapped, (String)"wrapped");
        Intrinsics.checkNotNullParameter((Object)currentSpan, (String)"currentSpan");
        Intrinsics.checkNotNullParameter((Object)rootSpan, (String)"rootSpan");
        this.wrapped = wrapped;
        this.currentSpan = currentSpan;
        this.rootSpan = rootSpan;
    }

    public /* synthetic */ OtelContext(Context context, Span span, Span span2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Span span3 = Span.getInvalid();
            Intrinsics.checkNotNullExpressionValue((Object)span3, (String)"getInvalid()");
            span = span3;
        }
        if ((n & 4) != 0) {
            Span span4 = Span.getInvalid();
            Intrinsics.checkNotNullExpressionValue((Object)span4, (String)"getInvalid()");
            span2 = span4;
        }
        this(context, span, span2);
    }

    @NotNull
    public final Context getWrapped$dd_sdk_android_trace_otel_release() {
        return this.wrapped;
    }

    @NotNull
    public final Span getCurrentSpan$dd_sdk_android_trace_otel_release() {
        return this.currentSpan;
    }

    @NotNull
    public final Span getRootSpan$dd_sdk_android_trace_otel_release() {
        return this.rootSpan;
    }

    @Nullable
    public <V> V get(@NotNull ContextKey<V> key) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        if (Intrinsics.areEqual((Object)OTEL_CONTEXT_SPAN_KEY, (Object)key.toString())) {
            Span span = this.currentSpan;
            if (span == null) {
                span = null;
            }
            return (V)span;
        }
        if (Intrinsics.areEqual((Object)OTEL_CONTEXT_ROOT_SPAN_KEY, (Object)key.toString())) {
            Span span = this.rootSpan;
            if (span == null) {
                span = null;
            }
            return (V)span;
        }
        return (V)this.wrapped.get(key);
    }

    @NotNull
    public <V> Context with(@NotNull ContextKey<V> k1, V v1) {
        Intrinsics.checkNotNullParameter(k1, (String)"k1");
        if (Intrinsics.areEqual((Object)OTEL_CONTEXT_SPAN_KEY, (Object)k1.toString())) {
            Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type io.opentelemetry.api.trace.Span");
            return new OtelContext(this.wrapped, (Span)v1, this.rootSpan);
        }
        if (Intrinsics.areEqual((Object)OTEL_CONTEXT_ROOT_SPAN_KEY, (Object)k1.toString())) {
            Intrinsics.checkNotNull(v1, (String)"null cannot be cast to non-null type io.opentelemetry.api.trace.Span");
            return new OtelContext(this.wrapped, this.currentSpan, (Span)v1);
        }
        Context context = this.wrapped.with(k1, v1);
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"wrapped.with(k1, v1)");
        return new OtelContext(context, this.currentSpan, this.rootSpan);
    }

    @NotNull
    public Scope makeCurrent() {
        Scope scope = super.makeCurrent();
        if (this.currentSpan instanceof OtelSpan) {
            AgentScope agentScope = ((OtelSpan)this.currentSpan).activate();
            Scope scope2 = scope;
            Intrinsics.checkNotNullExpressionValue((Object)scope2, (String)"scope");
            Intrinsics.checkNotNullExpressionValue((Object)agentScope, (String)"agentScope");
            scope = new OtelScope(scope2, agentScope);
        }
        Scope scope3 = scope;
        Intrinsics.checkNotNullExpressionValue((Object)scope3, (String)"scope");
        return scope3;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/trace/opentelemetry/internal/OtelContext$Companion;", "", "()V", "OTEL_CONTEXT_ROOT_SPAN_KEY", "", "OTEL_CONTEXT_SPAN_KEY", "dd-sdk-android-trace-otel_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

