/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import com.datadog.android.api.InternalLogger;
import com.datadog.opentelemetry.trace.OtelSpanContext;
import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTrace;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import com.datadog.trace.bootstrap.instrumentation.api.PathwayContext;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import java.util.Locale;
import java.util.Map;

public class OtelExtractedContext
implements AgentSpan.Context {
    private final DDTraceId traceId;
    private final long spanId;
    private final int prioritySampling;

    private OtelExtractedContext(SpanContext context) {
        this.traceId = DDTraceId.fromHex((String)context.getTraceId());
        this.spanId = DDSpanId.fromHex((String)context.getSpanId());
        this.prioritySampling = context.isSampled() ? 1 : -128;
    }

    public static AgentSpan.Context extract(Context context, InternalLogger logger) {
        Span span = Span.fromContext((Context)context);
        SpanContext spanContext = span.getSpanContext();
        if (spanContext instanceof OtelSpanContext) {
            return ((OtelSpanContext)spanContext).delegate;
        }
        if (spanContext.isValid()) {
            try {
                return new OtelExtractedContext(spanContext);
            }
            catch (NumberFormatException e) {
                logger.log(InternalLogger.Level.DEBUG, InternalLogger.Target.MAINTAINER, () -> String.format(Locale.US, "Failed to convert span context with trace id = {%1s} and span id = {%2s}", spanContext.getSpanId(), spanContext.getTraceId()), null, false, null);
            }
        }
        return null;
    }

    public DDTraceId getTraceId() {
        return this.traceId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public AgentTrace getTrace() {
        return AgentTracer.NoopAgentTrace.INSTANCE;
    }

    public int getSamplingPriority() {
        return this.prioritySampling;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return null;
    }

    public PathwayContext getPathwayContext() {
        return null;
    }
}

