/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import com.datadog.opentelemetry.trace.OtelConventions;
import com.datadog.opentelemetry.trace.OtelSpanContext;
import com.datadog.trace.bootstrap.instrumentation.api.AgentScope;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import com.datadog.trace.bootstrap.instrumentation.api.ScopeSource;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class OtelSpan
implements Span {
    private final AgentSpan delegate;
    private StatusCode statusCode;
    private boolean recording;
    private final AgentTracer.TracerAPI agentTracer;

    public OtelSpan(AgentSpan delegate, AgentTracer.TracerAPI agentTracer) {
        this.delegate = delegate;
        this.statusCode = StatusCode.UNSET;
        this.recording = true;
        this.agentTracer = agentTracer;
    }

    public static Span invalid() {
        return NoopSpan.INSTANCE;
    }

    public <T> Span setAttribute(AttributeKey<T> key, T value) {
        if (this.recording && !OtelConventions.applyReservedAttribute(this.delegate, key, value)) {
            switch (key.getType()) {
                case STRING_ARRAY: 
                case BOOLEAN_ARRAY: 
                case LONG_ARRAY: 
                case DOUBLE_ARRAY: {
                    if (!(value instanceof List)) break;
                    List valueList = (List)value;
                    if (valueList.isEmpty()) {
                        this.delegate.setTag(key.getKey(), (Object)"");
                        break;
                    }
                    for (int index = 0; index < valueList.size(); ++index) {
                        this.delegate.setTag(key.getKey() + "." + index, valueList.get(index));
                    }
                    break;
                }
                default: {
                    this.delegate.setTag(key.getKey(), value);
                }
            }
        }
        return this;
    }

    public Span addEvent(String name, Attributes attributes) {
        return this;
    }

    public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        return this;
    }

    public Span setStatus(StatusCode statusCode, String description) {
        if (this.recording) {
            if (this.statusCode == StatusCode.UNSET) {
                this.statusCode = statusCode;
                this.delegate.setError(statusCode == StatusCode.ERROR);
                this.delegate.setErrorMessage(statusCode == StatusCode.ERROR ? description : null);
            } else if (this.statusCode == StatusCode.ERROR && statusCode == StatusCode.OK) {
                this.delegate.setError(false);
                this.delegate.setErrorMessage(null);
            }
        }
        return this;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Span recordException(Throwable exception, Attributes additionalAttributes) {
        if (this.recording) {
            this.delegate.addThrowable(exception, (byte)-128);
        }
        return this;
    }

    public Span updateName(String name) {
        if (this.recording) {
            this.delegate.setResourceName((CharSequence)name);
        }
        return this;
    }

    public void end() {
        this.recording = false;
        OtelConventions.applyNamingConvention(this.delegate);
        this.delegate.finish();
    }

    public void end(long timestamp, TimeUnit unit) {
        this.recording = false;
        OtelConventions.applyNamingConvention(this.delegate);
        this.delegate.finish(unit.toMicros(timestamp));
    }

    public SpanContext getSpanContext() {
        return OtelSpanContext.fromLocalSpan(this.delegate);
    }

    public boolean isRecording() {
        return this.recording;
    }

    public AgentScope activate() {
        return this.agentTracer.activateSpan(this.delegate, ScopeSource.INSTRUMENTATION, true);
    }

    public AgentSpan.Context getAgentSpanContext() {
        return this.delegate.context();
    }

    static class NoopSpan
    implements Span {
        static final Span INSTANCE = new NoopSpan();

        NoopSpan() {
        }

        public <T> Span setAttribute(AttributeKey<T> key, T value) {
            return this;
        }

        public Span addEvent(String name, Attributes attributes) {
            return this;
        }

        public Span addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
            return this;
        }

        public Span setStatus(StatusCode statusCode, String description) {
            return this;
        }

        public Span recordException(Throwable exception, Attributes additionalAttributes) {
            return this;
        }

        public Span updateName(String name) {
            return this;
        }

        public void end() {
        }

        public void end(long timestamp, TimeUnit unit) {
        }

        public SpanContext getSpanContext() {
            return NoopSpanContext.INSTANCE;
        }

        public boolean isRecording() {
            return false;
        }
    }

    private static class NoopSpanContext
    implements SpanContext {
        private static final SpanContext INSTANCE = new NoopSpanContext();

        private NoopSpanContext() {
        }

        public String getTraceId() {
            return "00000000000000000000000000000000";
        }

        public String getSpanId() {
            return "0000000000000000";
        }

        public TraceFlags getTraceFlags() {
            return TraceFlags.getDefault();
        }

        public TraceState getTraceState() {
            return TraceState.getDefault();
        }

        public boolean isRemote() {
            return false;
        }
    }
}

