/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import androidx.annotation.NonNull;
import com.datadog.android.api.InternalLogger;
import com.datadog.opentelemetry.trace.OtelConventions;
import com.datadog.opentelemetry.trace.OtelExtractedContext;
import com.datadog.opentelemetry.trace.OtelSpan;
import com.datadog.opentelemetry.trace.OtelSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpan;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.context.Context;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class OtelSpanBuilder
implements SpanBuilder {
    private final AgentTracer.SpanBuilder delegate;
    private final AgentTracer.TracerAPI agentTracer;
    private boolean spanKindSet;
    private String overriddenOperationName;
    private int overriddenAnalyticsSampleRate;
    @NonNull
    private final InternalLogger logger;

    public OtelSpanBuilder(AgentTracer.SpanBuilder delegate, AgentTracer.TracerAPI agentTracer, @NonNull InternalLogger logger) {
        this.delegate = delegate;
        this.spanKindSet = false;
        this.overriddenOperationName = null;
        this.overriddenAnalyticsSampleRate = -1;
        this.logger = logger;
        this.agentTracer = agentTracer;
    }

    public SpanBuilder setParent(Context context) {
        AgentSpan.Context extractedContext = OtelExtractedContext.extract(context, this.logger);
        if (extractedContext != null) {
            this.delegate.asChildOf(extractedContext);
        }
        return this;
    }

    public SpanBuilder setNoParent() {
        this.delegate.asChildOf(null);
        this.delegate.ignoreActiveSpan();
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        if (spanContext.isValid()) {
            this.delegate.withLink((AgentSpanLink)new OtelSpanLink(spanContext));
        }
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        if (spanContext.isValid()) {
            this.delegate.withLink((AgentSpanLink)new OtelSpanLink(spanContext, attributes));
        }
        return this;
    }

    public SpanBuilder setAttribute(String key, String value) {
        if ("operation.name".equals(key) && value != null) {
            this.overriddenOperationName = value.toLowerCase(Locale.ROOT);
            return this;
        }
        if ("analytics.event".equals(key) && value != null) {
            this.overriddenAnalyticsSampleRate = Boolean.parseBoolean(value) ? 1 : 0;
            return this;
        }
        this.delegate.withTag(key, (Object)value);
        return this;
    }

    public SpanBuilder setAttribute(String key, long value) {
        this.delegate.withTag(key, (Number)value);
        return this;
    }

    public SpanBuilder setAttribute(String key, double value) {
        this.delegate.withTag(key, (Number)value);
        return this;
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        if ("analytics.event".equals(key)) {
            this.overriddenAnalyticsSampleRate = value ? 1 : 0;
            return this;
        }
        this.delegate.withTag(key, value);
        return this;
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        switch (key.getType()) {
            case STRING_ARRAY: 
            case BOOLEAN_ARRAY: 
            case LONG_ARRAY: 
            case DOUBLE_ARRAY: {
                if (!(value instanceof List)) break;
                List valueList = (List)value;
                if (valueList.isEmpty()) {
                    this.delegate.withTag(key.getKey(), (Object)"");
                    break;
                }
                for (int index = 0; index < valueList.size(); ++index) {
                    this.delegate.withTag(key.getKey() + "." + index, valueList.get(index));
                }
                break;
            }
            default: {
                this.delegate.withTag(key.getKey(), value);
            }
        }
        return this;
    }

    public SpanBuilder setSpanKind(SpanKind spanKind) {
        if (spanKind != null) {
            this.delegate.withTag("span.kind", OtelConventions.toSpanKindTagValue(spanKind));
            this.spanKindSet = true;
        }
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        this.delegate.withStartTimestamp(unit.toMicros(startTimestamp));
        return this;
    }

    public Span startSpan() {
        if (!this.spanKindSet) {
            this.setSpanKind(SpanKind.INTERNAL);
        }
        AgentSpan delegate = this.delegate.start();
        if (this.overriddenOperationName != null) {
            delegate.setOperationName((CharSequence)this.overriddenOperationName);
        }
        if (this.overriddenAnalyticsSampleRate != -1) {
            delegate.setMetric((CharSequence)"_dd1.sr.eausr", this.overriddenAnalyticsSampleRate);
        }
        return new OtelSpan(delegate, this.agentTracer);
    }
}

