/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import com.datadog.opentelemetry.context.propagation.TraceStateHelper;
import com.datadog.trace.api.DDSpanId;
import com.datadog.trace.api.DDTraceId;
import com.datadog.trace.bootstrap.instrumentation.api.AgentSpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.SpanLink;
import com.datadog.trace.bootstrap.instrumentation.api.SpanLinkAttributes;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.SpanContext;
import java.util.List;

public class OtelSpanLink
extends SpanLink {
    public OtelSpanLink(SpanContext spanContext) {
        this(spanContext, Attributes.empty());
    }

    public OtelSpanLink(SpanContext spanContext, Attributes attributes) {
        super(DDTraceId.fromHex((String)spanContext.getTraceId()), DDSpanId.fromHex((String)spanContext.getSpanId()), spanContext.isSampled() ? (byte)1 : 0, TraceStateHelper.encodeHeader(spanContext.getTraceState()), OtelSpanLink.convertAttributes(attributes));
    }

    private static AgentSpanLink.Attributes convertAttributes(Attributes attributes) {
        if (attributes.isEmpty()) {
            return SpanLinkAttributes.EMPTY;
        }
        SpanLinkAttributes.Builder builder = SpanLinkAttributes.builder();
        attributes.forEach((attributeKey, value) -> {
            String key = attributeKey.getKey();
            switch (attributeKey.getType()) {
                case STRING: {
                    builder.put(key, (String)value);
                    break;
                }
                case BOOLEAN: {
                    builder.put(key, ((Boolean)value).booleanValue());
                    break;
                }
                case LONG: {
                    builder.put(key, ((Long)value).longValue());
                    break;
                }
                case DOUBLE: {
                    builder.put(key, ((Double)value).doubleValue());
                    break;
                }
                case STRING_ARRAY: {
                    builder.putStringArray(key, (List)value);
                    break;
                }
                case BOOLEAN_ARRAY: {
                    builder.putBooleanArray(key, (List)value);
                    break;
                }
                case LONG_ARRAY: {
                    builder.putLongArray(key, (List)value);
                    break;
                }
                case DOUBLE_ARRAY: {
                    builder.putDoubleArray(key, (List)value);
                }
            }
        });
        return builder.build();
    }
}

