/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import androidx.annotation.NonNull;
import com.datadog.android.api.InternalLogger;
import com.datadog.opentelemetry.compat.function.Function;
import com.datadog.opentelemetry.trace.OtelSpanBuilder;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;

public class OtelTracer
implements Tracer {
    private static final Function<SpanBuilder, SpanBuilder> NO_OP_DECORATOR = spanBuilder -> spanBuilder;
    @NonNull
    private final AgentTracer.TracerAPI tracer;
    @NonNull
    private final String instrumentationScopeName;
    @NonNull
    private final InternalLogger logger;
    @NonNull
    private final Function<SpanBuilder, SpanBuilder> spanBuilderDecorator;

    public OtelTracer(@NonNull String instrumentationScopeName, @NonNull AgentTracer.TracerAPI tracer, @NonNull InternalLogger logger, @NonNull Function<SpanBuilder, SpanBuilder> spanBuilderDecorator) {
        this.instrumentationScopeName = instrumentationScopeName;
        this.tracer = tracer;
        this.logger = logger;
        this.spanBuilderDecorator = spanBuilderDecorator;
    }

    public OtelTracer(@NonNull String instrumentationScopeName, @NonNull AgentTracer.TracerAPI tracer, @NonNull InternalLogger logger) {
        this(instrumentationScopeName, tracer, logger, NO_OP_DECORATOR);
    }

    public SpanBuilder spanBuilder(String spanName) {
        AgentTracer.SpanBuilder delegate = this.tracer.buildSpan(this.instrumentationScopeName, (CharSequence)"internal").withResourceName(spanName);
        return this.spanBuilderDecorator.apply(new OtelSpanBuilder(delegate, this.tracer, this.logger));
    }
}

