/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentelemetry.trace;

import androidx.annotation.NonNull;
import com.datadog.android.api.InternalLogger;
import com.datadog.opentelemetry.compat.function.Function;
import com.datadog.opentelemetry.trace.OtelTracer;
import com.datadog.trace.bootstrap.instrumentation.api.AgentTracer;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerBuilder;

public class OtelTracerBuilder
implements TracerBuilder {
    @NonNull
    private final String instrumentationScopeName;
    @NonNull
    private final AgentTracer.TracerAPI coreTracer;
    @NonNull
    private final InternalLogger logger;
    @NonNull
    private final Function<SpanBuilder, SpanBuilder> spanBuilderDecorator;

    public OtelTracerBuilder(@NonNull String instrumentationScopeName, @NonNull AgentTracer.TracerAPI coreTracer, @NonNull InternalLogger logger, @NonNull Function<SpanBuilder, SpanBuilder> spanBuilderDecorator) {
        this.coreTracer = coreTracer;
        this.instrumentationScopeName = instrumentationScopeName;
        this.logger = logger;
        this.spanBuilderDecorator = spanBuilderDecorator;
    }

    public TracerBuilder setSchemaUrl(String schemaUrl) {
        return this;
    }

    public TracerBuilder setInstrumentationVersion(String instrumentationScopeVersion) {
        return this;
    }

    public Tracer build() {
        return new OtelTracer(this.instrumentationScopeName, this.coreTracer, this.logger, this.spanBuilderDecorator);
    }
}

