package com.datadog.trace.api.interceptor;

import androidx.annotation.Nullable;

import com.datadog.trace.api.DDTags;

import java.util.Map;

public interface MutableSpan {

  /** @return Start time with nanosecond scale, but millisecond resolution. */
  long getStartTime();

  /** @return Duration with nanosecond scale. */
  long getDurationNano();

  CharSequence getOperationName();

  MutableSpan setOperationName(final CharSequence serviceName);

  String getServiceName();

  MutableSpan setServiceName(final String serviceName);

  CharSequence getResourceName();

  MutableSpan setResourceName(final CharSequence resourceName);

  @Nullable
  Integer getSamplingPriority();

  /**
   * @param newPriority
   * @return
   * @deprecated Use {@link io.opentracing.Span#setTag(String, boolean)} instead using either tag
   *     names {@link DDTags#MANUAL_KEEP} or {@link
   *     DDTags#MANUAL_DROP}.
   */
  @Deprecated
  MutableSpan setSamplingPriority(final int newPriority);

  String getSpanType();

  MutableSpan setSpanType(final CharSequence type);

  Map<String, Object> getTags();

  default Object getTag(String key) {
    Map<String, Object> tags = getTags();
    return tags == null ? null : tags.get(key);
  }

  MutableSpan setTag(final String tag, final String value);

  MutableSpan setTag(final String tag, final boolean value);

  MutableSpan setTag(final String tag, final Number value);

  MutableSpan setMetric(final CharSequence metric, final int value);

  MutableSpan setMetric(final CharSequence metric, final long value);

  MutableSpan setMetric(final CharSequence metric, final double value);

  boolean isError();

  MutableSpan setError(boolean value);

  /** @deprecated Use {@link #getLocalRootSpan()} instead. */
  @Deprecated
  MutableSpan getRootSpan();

  /**
   * Returns the root span for current the trace fragment. In the context of distributed tracing
   * this method returns the root span only for the fragment generated by the currently traced
   * application.
   *
   * @return The root span for the current trace fragment.
   */
  MutableSpan getLocalRootSpan();
}
