/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace;

import androidx.annotation.FloatRange;
import com.datadog.android.Datadog;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.SdkCore;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.trace.AndroidTracer;
import com.datadog.android.trace.TracingHeaderType;
import com.datadog.android.trace.internal.FeatureSdkCoreExtKt;
import com.datadog.android.trace.internal.TracingFeature;
import com.datadog.android.trace.internal.data.NoOpWriter;
import com.datadog.android.trace.internal.handlers.AndroidSpanLogsHandler;
import com.datadog.android.trace.internal.utils.SpanContextExtKt;
import com.datadog.legacy.trace.api.Config;
import com.datadog.legacy.trace.common.writer.Writer;
import com.datadog.legacy.trace.context.ScopeListener;
import com.datadog.opentracing.DDTracer;
import com.datadog.opentracing.LogHandler;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import java.lang.invoke.CallSite;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0014\u0010\u000f\u001a\u00060\u0010R\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\u0014\u0010\u0014\u001a\u00060\u0010R\u00020\u0001*\u00060\u0010R\u00020\u0001H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/datadog/android/trace/AndroidTracer;", "Lcom/datadog/opentracing/DDTracer;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "config", "Lcom/datadog/legacy/trace/api/Config;", "writer", "Lcom/datadog/legacy/trace/common/writer/Writer;", "random", "Ljava/util/Random;", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "bundleWithRum", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/legacy/trace/api/Config;Lcom/datadog/legacy/trace/common/writer/Writer;Ljava/util/Random;Lcom/datadog/opentracing/LogHandler;Z)V", "buildSpan", "Lcom/datadog/opentracing/DDTracer$DDSpanBuilder;", "operationName", "", "toString", "withRumContext", "Builder", "Companion", "dd-sdk-android-trace_release"})
public final class AndroidTracer
extends DDTracer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final LogHandler logsHandler;
    private final boolean bundleWithRum;
    public static final double DEFAULT_SAMPLE_RATE = 100.0;
    @NotNull
    public static final String TRACING_NOT_ENABLED_ERROR_MESSAGE = "You're trying to create an AndroidTracer instance, but either the SDK was not initialized or the Tracing feature was not registered/initialized. No tracing data will be sent.";
    @NotNull
    public static final String RUM_NOT_ENABLED_ERROR_MESSAGE = "You're trying to bundle the traces with a RUM context, but the RUM feature was not registered/initialized. No RUM context will be attached to your traces in this case.";
    @NotNull
    public static final String DEFAULT_SERVICE_NAME_IS_MISSING_ERROR_MESSAGE = "Default service name is missing during AndroidTracer.Builder creation, did you initialize SDK?";
    public static final int DEFAULT_PARTIAL_MIN_FLUSH = 5;
    public static final int SPAN_ID_BIT_SIZE = 63;

    public AndroidTracer(@NotNull FeatureSdkCore sdkCore, @NotNull Config config, @NotNull Writer writer, @NotNull Random random, @NotNull LogHandler logsHandler, boolean bundleWithRum) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
        super(config, writer, random);
        this.sdkCore = sdkCore;
        this.logsHandler = logsHandler;
        this.bundleWithRum = bundleWithRum;
        this.addScopeListener(new ScopeListener(){

            @Override
            public void afterScopeActivated() {
                SpanContext activeContext;
                Span span = this.activeSpan();
                Object object = activeContext = span != null ? span.context() : null;
                if (activeContext != null) {
                    String activeSpanId = activeContext.toSpanId();
                    String activeTraceId = SpanContextExtKt.traceIdAsHexString(activeContext);
                    FeatureSdkCore featureSdkCore = sdkCore;
                    Intrinsics.checkNotNullExpressionValue((Object)activeSpanId, (String)"activeSpanId");
                    FeatureSdkCoreExtKt.addActiveTraceToContext(featureSdkCore, activeTraceId, activeSpanId);
                }
            }

            @Override
            public void afterScopeClosed() {
                FeatureSdkCoreExtKt.removeActiveTraceFromContext(sdkCore);
            }
        });
    }

    @Override
    @NotNull
    public DDTracer.DDSpanBuilder buildSpan(@NotNull String operationName) {
        Intrinsics.checkNotNullParameter((Object)operationName, (String)"operationName");
        DDTracer.DDSpanBuilder dDSpanBuilder = new DDTracer.DDSpanBuilder(this, operationName, this.scopeManager()).withLogHandler(this.logsHandler).withInternalLogger(this.sdkCore.getInternalLogger());
        Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder, (String)"DDSpanBuilder(operationN\u2026r(sdkCore.internalLogger)");
        return this.withRumContext(dDSpanBuilder);
    }

    private final DDTracer.DDSpanBuilder withRumContext(DDTracer.DDSpanBuilder $this$withRumContext) {
        DDTracer.DDSpanBuilder dDSpanBuilder;
        if (this.bundleWithRum) {
            Map rumContext = this.sdkCore.getFeatureContext("rum");
            Object v = rumContext.get("application_id");
            DDTracer.DDSpanBuilder dDSpanBuilder2 = $this$withRumContext.withTag("application_id", v instanceof String ? (String)v : null);
            v = rumContext.get("session_id");
            DDTracer.DDSpanBuilder dDSpanBuilder3 = dDSpanBuilder2.withTag("session_id", v instanceof String ? (String)v : null);
            v = rumContext.get("view_id");
            DDTracer.DDSpanBuilder dDSpanBuilder4 = dDSpanBuilder3.withTag("view.id", v instanceof String ? (String)v : null);
            v = rumContext.get("action_id");
            DDTracer.DDSpanBuilder dDSpanBuilder5 = dDSpanBuilder4.withTag("user_action.id", v instanceof String ? (String)v : null);
            Intrinsics.checkNotNullExpressionValue((Object)dDSpanBuilder5, (String)"{\n            val rumCon\u2026d\"] as? String)\n        }");
            dDSpanBuilder = dDSpanBuilder5;
        } else {
            dDSpanBuilder = $this$withRumContext;
        }
        return dDSpanBuilder;
    }

    @Override
    @NotNull
    public String toString() {
        return "AndroidTracer/" + super.toString();
    }

    @JvmStatic
    public static final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
        Companion.logThrowable(span, throwable);
    }

    @JvmStatic
    public static final void logErrorMessage(@NotNull Span span, @NotNull String message) {
        Companion.logErrorMessage(span, message);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001B\u0011\b\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0007J\u0016\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0002J\r\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020\nJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u000fJ\u0010\u0010)\u001a\u00020\u00002\b\b\u0001\u0010\u0012\u001a\u00020\u0013J\u000e\u0010*\u001a\u00020\u00002\u0006\u0010+\u001a\u00020\rJ\u0014\u0010,\u001a\u00020\u00002\f\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018J\u0015\u0010.\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b/R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\u00020\r8BX\u0082\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/datadog/android/trace/AndroidTracer$Builder;", "", "sdkCore", "Lcom/datadog/android/api/SdkCore;", "(Lcom/datadog/android/api/SdkCore;)V", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "logsHandler", "Lcom/datadog/opentracing/LogHandler;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/opentracing/LogHandler;)V", "bundleWithRumEnabled", "", "globalTags", "", "", "partialFlushThreshold", "", "random", "Ljava/util/Random;", "sampleRate", "", "serviceName", "getServiceName", "()Ljava/lang/String;", "tracingHeaderTypes", "", "Lcom/datadog/android/trace/TracingHeaderType;", "addGlobalTag", "key", "value", "addTag", "build", "Lcom/datadog/android/trace/AndroidTracer;", "config", "Lcom/datadog/legacy/trace/api/Config;", "properties", "Ljava/util/Properties;", "properties$dd_sdk_android_trace_release", "setBundleWithRumEnabled", "enabled", "setPartialFlushThreshold", "threshold", "setSampleRate", "setService", "service", "setTracingHeaderTypes", "headerTypes", "withRandom", "withRandom$dd_sdk_android_trace_release", "dd-sdk-android-trace_release"})
    @SourceDebugExtension(value={"SMAP\nAndroidTracer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidTracer.kt\ncom/datadog/android/trace/AndroidTracer$Builder\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,339:1\n125#2:340\n152#2,3:341\n*S KotlinDebug\n*F\n+ 1 AndroidTracer.kt\ncom/datadog/android/trace/AndroidTracer$Builder\n*L\n251#1:340\n251#1:341,3\n*E\n"})
    public static final class Builder {
        @NotNull
        private final FeatureSdkCore sdkCore;
        @NotNull
        private final LogHandler logsHandler;
        @NotNull
        private Set<? extends TracingHeaderType> tracingHeaderTypes;
        private boolean bundleWithRumEnabled;
        private double sampleRate;
        @NotNull
        private String serviceName;
        private int partialFlushThreshold;
        @NotNull
        private Random random;
        @NotNull
        private final Map<String, String> globalTags;

        public Builder(@NotNull FeatureSdkCore sdkCore, @NotNull LogHandler logsHandler) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            Intrinsics.checkNotNullParameter((Object)logsHandler, (String)"logsHandler");
            this.sdkCore = sdkCore;
            this.logsHandler = logsHandler;
            Object[] objectArray = new TracingHeaderType[]{TracingHeaderType.DATADOG, TracingHeaderType.TRACECONTEXT};
            this.tracingHeaderTypes = SetsKt.setOf((Object[])objectArray);
            this.bundleWithRumEnabled = true;
            this.sampleRate = 100.0;
            this.serviceName = "";
            this.partialFlushThreshold = 5;
            this.random = new SecureRandom();
            this.globalTags = new LinkedHashMap();
        }

        /*
         * WARNING - void declaration
         */
        private final String getServiceName() {
            CharSequence charSequence;
            CharSequence charSequence2 = this.serviceName;
            if (charSequence2.length() == 0) {
                void var3_3;
                boolean bl = false;
                String service = this.sdkCore.getService();
                if (((CharSequence)service).length() == 0) {
                    InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)serviceName.1.1.INSTANCE, null, (boolean)false, null, (int)56, null);
                }
                charSequence = var3_3;
            } else {
                charSequence = charSequence2;
            }
            return (String)charSequence;
        }

        @JvmOverloads
        public Builder(@NotNull SdkCore sdkCore) {
            Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
            this((FeatureSdkCore)sdkCore, new AndroidSpanLogsHandler((FeatureSdkCore)sdkCore));
        }

        public /* synthetic */ Builder(SdkCore sdkCore, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                sdkCore = Datadog.getInstance$default(null, (int)1, null);
            }
            this(sdkCore);
        }

        @NotNull
        public final AndroidTracer build() {
            FeatureScope featureScope = this.sdkCore.getFeature("tracing");
            TracingFeature tracingFeature = featureScope != null ? (TracingFeature)featureScope.unwrap() : null;
            FeatureScope rumFeature = this.sdkCore.getFeature("rum");
            if (tracingFeature == null) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.ERROR, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)build.1.INSTANCE, null, (boolean)false, null, (int)56, null);
            }
            if (this.bundleWithRumEnabled && rumFeature == null) {
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.sdkCore.getInternalLogger(), (InternalLogger.Level)InternalLogger.Level.WARN, (InternalLogger.Target)InternalLogger.Target.USER, (Function0)build.2.INSTANCE, null, (boolean)false, null, (int)56, null);
                this.bundleWithRumEnabled = false;
            }
            Config config = this.config();
            Object object = tracingFeature;
            if (object == null || (object = ((TracingFeature)object).getLegacyTracerWriter$dd_sdk_android_trace_release()) == null) {
                object = new NoOpWriter();
            }
            return new AndroidTracer(this.sdkCore, config, (Writer)object, this.random, this.logsHandler, this.bundleWithRumEnabled);
        }

        @NotNull
        public final Builder setTracingHeaderTypes(@NotNull Set<? extends TracingHeaderType> headerTypes) {
            Intrinsics.checkNotNullParameter(headerTypes, (String)"headerTypes");
            this.tracingHeaderTypes = headerTypes;
            return this;
        }

        @NotNull
        public final Builder setService(@NotNull String service) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            this.serviceName = service;
            return this;
        }

        @NotNull
        public final Builder setPartialFlushThreshold(int threshold) {
            this.partialFlushThreshold = threshold;
            return this;
        }

        @Deprecated(message="addGlobalTag is deprecated, please use addTag instead", replaceWith=@ReplaceWith(expression="addTag", imports={}), level=DeprecationLevel.WARNING)
        @NotNull
        public final Builder addGlobalTag(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return this.addTag(key, value);
        }

        @NotNull
        public final Builder addTag(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.globalTags.put(key, value);
            return this;
        }

        @NotNull
        public final Builder setBundleWithRumEnabled(boolean enabled) {
            this.bundleWithRumEnabled = enabled;
            return this;
        }

        @NotNull
        public final Builder setSampleRate(@FloatRange(from=0.0, to=100.0) double sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        @NotNull
        public final Builder withRandom$dd_sdk_android_trace_release(@NotNull Random random) {
            Intrinsics.checkNotNullParameter((Object)random, (String)"random");
            this.random = random;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Properties properties$dd_sdk_android_trace_release() {
            Collection<CallSite> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Properties properties = new Properties();
            properties.setProperty("service.name", this.getServiceName());
            properties.setProperty("trace.partial.flush.min.spans", String.valueOf(this.partialFlushThreshold));
            Map<String, String> map2 = this.globalTags;
            String string = "tags";
            Properties properties2 = properties;
            boolean $i$f$map = false;
            void var4_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add((CallSite)((Object)(it.getKey() + ":" + it.getValue())));
            }
            collection = (List)destination$iv$iv;
            properties2.setProperty(string, CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            properties.setProperty("trace.sample.rate", String.valueOf(this.sampleRate / 100.0));
            String propagationStyles = CollectionsKt.joinToString$default((Iterable)this.tracingHeaderTypes, (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            properties.setProperty("propagation.style.extract", propagationStyles);
            properties.setProperty("propagation.style.inject", propagationStyles);
            return properties;
        }

        private final Config config() {
            Config config = Config.get(this.properties$dd_sdk_android_trace_release());
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"get(properties())");
            return config;
        }

        @JvmOverloads
        public Builder() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0007J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/trace/AndroidTracer$Companion;", "", "()V", "DEFAULT_PARTIAL_MIN_FLUSH", "", "DEFAULT_SAMPLE_RATE", "", "DEFAULT_SERVICE_NAME_IS_MISSING_ERROR_MESSAGE", "", "RUM_NOT_ENABLED_ERROR_MESSAGE", "SPAN_ID_BIT_SIZE", "TRACING_NOT_ENABLED_ERROR_MESSAGE", "logErrorMessage", "", "span", "Lio/opentracing/Span;", "message", "logThrowable", "throwable", "", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void logThrowable(@NotNull Span span, @NotNull Throwable throwable) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"error.object", (Object)throwable));
            span.log(fieldsMap);
        }

        @JvmStatic
        public final void logErrorMessage(@NotNull Span span, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)span, (String)"span");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Map fieldsMap = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
            span.log(fieldsMap);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

