/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal;

import android.content.Context;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.feature.StorageBackedFeature;
import com.datadog.android.api.net.RequestFactory;
import com.datadog.android.api.storage.FeatureStorageConfiguration;
import com.datadog.android.event.EventMapper;
import com.datadog.android.trace.InternalCoreWriterProvider;
import com.datadog.android.trace.event.SpanEventMapper;
import com.datadog.android.trace.internal.data.NoOpCoreTracerWriter;
import com.datadog.android.trace.internal.data.NoOpWriter;
import com.datadog.android.trace.internal.data.OtelTraceWriter;
import com.datadog.android.trace.internal.data.TraceWriter;
import com.datadog.android.trace.internal.domain.event.CoreTracerSpanToSpanEventMapper;
import com.datadog.android.trace.internal.domain.event.DdSpanToSpanEventMapper;
import com.datadog.android.trace.internal.domain.event.SpanEventMapperWrapper;
import com.datadog.android.trace.internal.domain.event.SpanEventSerializer;
import com.datadog.android.trace.internal.net.TracesRequestFactory;
import com.datadog.android.trace.model.SpanEvent;
import com.datadog.legacy.trace.common.writer.Writer;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010-\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010.\u001a\u00020\r2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010/\u001a\u00020\rH\u0016J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000201H\u0016R\u001a\u0010\f\u001a\u00020\rX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\t\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020*X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,\u00a8\u00066"}, d2={"Lcom/datadog/android/trace/internal/TracingFeature;", "Lcom/datadog/android/trace/InternalCoreWriterProvider;", "Lcom/datadog/android/api/feature/StorageBackedFeature;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "customEndpointUrl", "", "spanEventMapper", "Lcom/datadog/android/trace/event/SpanEventMapper;", "networkInfoEnabled", "", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Ljava/lang/String;Lcom/datadog/android/trace/event/SpanEventMapper;Z)V", "coreTracerDataWriter", "Lcom/datadog/trace/common/writer/Writer;", "getCoreTracerDataWriter$dd_sdk_android_trace_release", "()Lcom/datadog/trace/common/writer/Writer;", "setCoreTracerDataWriter$dd_sdk_android_trace_release", "(Lcom/datadog/trace/common/writer/Writer;)V", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getInitialized$dd_sdk_android_trace_release", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "legacyTracerWriter", "Lcom/datadog/legacy/trace/common/writer/Writer;", "getLegacyTracerWriter$dd_sdk_android_trace_release", "()Lcom/datadog/legacy/trace/common/writer/Writer;", "setLegacyTracerWriter$dd_sdk_android_trace_release", "(Lcom/datadog/legacy/trace/common/writer/Writer;)V", "name", "getName", "()Ljava/lang/String;", "getNetworkInfoEnabled$dd_sdk_android_trace_release", "()Z", "requestFactory", "Lcom/datadog/android/api/net/RequestFactory;", "getRequestFactory", "()Lcom/datadog/android/api/net/RequestFactory;", "requestFactory$delegate", "Lkotlin/Lazy;", "getSpanEventMapper$dd_sdk_android_trace_release", "()Lcom/datadog/android/trace/event/SpanEventMapper;", "storageConfiguration", "Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "getStorageConfiguration", "()Lcom/datadog/android/api/storage/FeatureStorageConfiguration;", "createDataWriter", "createOtelDataWriter", "getCoreTracerWriter", "onInitialize", "", "appContext", "Landroid/content/Context;", "onStop", "Companion", "dd-sdk-android-trace_release"})
public final class TracingFeature
implements InternalCoreWriterProvider,
StorageBackedFeature {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final SpanEventMapper spanEventMapper;
    private final boolean networkInfoEnabled;
    @NotNull
    private Writer legacyTracerWriter;
    @NotNull
    private com.datadog.trace.common.writer.Writer coreTracerDataWriter;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final String name;
    @NotNull
    private final Lazy requestFactory$delegate;
    @NotNull
    private final FeatureStorageConfiguration storageConfiguration;
    @NotNull
    public static final String IS_OPENTELEMETRY_ENABLED_CONFIG_KEY = "is_opentelemetry_enabled";
    @NotNull
    public static final String OPENTELEMETRY_API_VERSION_CONFIG_KEY = "opentelemetry_api_version";

    public TracingFeature(@NotNull FeatureSdkCore sdkCore, @Nullable String customEndpointUrl, @NotNull SpanEventMapper spanEventMapper, boolean networkInfoEnabled) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter((Object)spanEventMapper, (String)"spanEventMapper");
        this.sdkCore = sdkCore;
        this.spanEventMapper = spanEventMapper;
        this.networkInfoEnabled = networkInfoEnabled;
        this.legacyTracerWriter = new NoOpWriter();
        this.coreTracerDataWriter = new NoOpCoreTracerWriter();
        this.initialized = new AtomicBoolean(false);
        this.name = "tracing";
        this.requestFactory$delegate = LazyKt.lazy((Function0)((Function0)new Function0<TracesRequestFactory>(customEndpointUrl, this){
            final /* synthetic */ String $customEndpointUrl;
            final /* synthetic */ TracingFeature this$0;
            {
                this.$customEndpointUrl = $customEndpointUrl;
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final TracesRequestFactory invoke() {
                return new TracesRequestFactory(this.$customEndpointUrl, TracingFeature.access$getSdkCore$p(this.this$0).getInternalLogger());
            }
        }));
        this.storageConfiguration = FeatureStorageConfiguration.Companion.getDEFAULT();
    }

    @NotNull
    public final SpanEventMapper getSpanEventMapper$dd_sdk_android_trace_release() {
        return this.spanEventMapper;
    }

    public final boolean getNetworkInfoEnabled$dd_sdk_android_trace_release() {
        return this.networkInfoEnabled;
    }

    @NotNull
    public final Writer getLegacyTracerWriter$dd_sdk_android_trace_release() {
        return this.legacyTracerWriter;
    }

    public final void setLegacyTracerWriter$dd_sdk_android_trace_release(@NotNull Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"<set-?>");
        this.legacyTracerWriter = writer;
    }

    @NotNull
    public final com.datadog.trace.common.writer.Writer getCoreTracerDataWriter$dd_sdk_android_trace_release() {
        return this.coreTracerDataWriter;
    }

    public final void setCoreTracerDataWriter$dd_sdk_android_trace_release(@NotNull com.datadog.trace.common.writer.Writer writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"<set-?>");
        this.coreTracerDataWriter = writer;
    }

    @NotNull
    public final AtomicBoolean getInitialized$dd_sdk_android_trace_release() {
        return this.initialized;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public void onInitialize(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.legacyTracerWriter = this.createDataWriter(this.sdkCore);
        this.coreTracerDataWriter = this.createOtelDataWriter(this.sdkCore);
        this.initialized.set(true);
    }

    @NotNull
    public RequestFactory getRequestFactory() {
        Lazy lazy = this.requestFactory$delegate;
        return (RequestFactory)lazy.getValue();
    }

    @NotNull
    public FeatureStorageConfiguration getStorageConfiguration() {
        return this.storageConfiguration;
    }

    public void onStop() {
        this.legacyTracerWriter = new NoOpWriter();
        this.initialized.set(false);
    }

    @Override
    @NotNull
    public com.datadog.trace.common.writer.Writer getCoreTracerWriter() {
        return this.coreTracerDataWriter;
    }

    private final Writer createDataWriter(FeatureSdkCore sdkCore) {
        InternalLogger internalLogger = sdkCore.getInternalLogger();
        return new TraceWriter(sdkCore, new DdSpanToSpanEventMapper(this.networkInfoEnabled, null, 2, null), (EventMapper<SpanEvent>)((EventMapper)new SpanEventMapperWrapper(this.spanEventMapper, internalLogger)), new SpanEventSerializer(internalLogger, null, 2, null), internalLogger);
    }

    private final com.datadog.trace.common.writer.Writer createOtelDataWriter(FeatureSdkCore sdkCore) {
        InternalLogger internalLogger = sdkCore.getInternalLogger();
        return new OtelTraceWriter(sdkCore, new CoreTracerSpanToSpanEventMapper(this.networkInfoEnabled), (EventMapper<SpanEvent>)((EventMapper)new SpanEventMapperWrapper(this.spanEventMapper, internalLogger)), new SpanEventSerializer(internalLogger, null, 2, null), internalLogger);
    }

    public static final /* synthetic */ FeatureSdkCore access$getSdkCore$p(TracingFeature $this) {
        return $this.sdkCore;
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/datadog/android/trace/internal/TracingFeature$Companion;", "", "()V", "IS_OPENTELEMETRY_ENABLED_CONFIG_KEY", "", "OPENTELEMETRY_API_VERSION_CONFIG_KEY", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

