/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.data;

import androidx.annotation.WorkerThread;
import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.feature.FeatureScope;
import com.datadog.android.api.feature.FeatureSdkCore;
import com.datadog.android.api.storage.EventBatchWriter;
import com.datadog.android.api.storage.EventType;
import com.datadog.android.api.storage.RawBatchEvent;
import com.datadog.android.event.EventMapper;
import com.datadog.android.event.NoOpEventMapper;
import com.datadog.android.trace.internal.domain.event.ContextAwareMapper;
import com.datadog.android.trace.internal.storage.ContextAwareSerializer;
import com.datadog.android.trace.model.SpanEvent;
import com.datadog.trace.common.writer.Writer;
import com.datadog.trace.core.DDSpan;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 $2\u00020\u0001:\u0001$BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0018\u0010\u001b\u001a\u00020\u00142\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u001dH\u0016J \u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0006H\u0003R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/datadog/android/trace/internal/data/OtelTraceWriter;", "Lcom/datadog/trace/common/writer/Writer;", "sdkCore", "Lcom/datadog/android/api/feature/FeatureSdkCore;", "ddSpanToSpanEventMapper", "Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;", "Lcom/datadog/trace/core/DDSpan;", "Lcom/datadog/android/trace/model/SpanEvent;", "eventMapper", "Lcom/datadog/android/event/EventMapper;", "serializer", "Lcom/datadog/android/trace/internal/storage/ContextAwareSerializer;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "(Lcom/datadog/android/api/feature/FeatureSdkCore;Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;Lcom/datadog/android/event/EventMapper;Lcom/datadog/android/trace/internal/storage/ContextAwareSerializer;Lcom/datadog/android/api/InternalLogger;)V", "getDdSpanToSpanEventMapper$dd_sdk_android_trace_release", "()Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;", "getEventMapper$dd_sdk_android_trace_release", "()Lcom/datadog/android/event/EventMapper;", "close", "", "flush", "", "incrementDropCounts", "p0", "", "start", "write", "trace", "", "writeSpan", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "writer", "Lcom/datadog/android/api/storage/EventBatchWriter;", "span", "Companion", "dd-sdk-android-trace_release"})
public final class OtelTraceWriter
implements Writer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FeatureSdkCore sdkCore;
    @NotNull
    private final ContextAwareMapper<DDSpan, SpanEvent> ddSpanToSpanEventMapper;
    @NotNull
    private final EventMapper<SpanEvent> eventMapper;
    @NotNull
    private final ContextAwareSerializer<SpanEvent> serializer;
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    public static final String ERROR_SERIALIZING = "Error serializing %s model";

    public OtelTraceWriter(@NotNull FeatureSdkCore sdkCore, @NotNull ContextAwareMapper<DDSpan, SpanEvent> ddSpanToSpanEventMapper, @NotNull EventMapper<SpanEvent> eventMapper, @NotNull ContextAwareSerializer<SpanEvent> serializer, @NotNull InternalLogger internalLogger) {
        Intrinsics.checkNotNullParameter((Object)sdkCore, (String)"sdkCore");
        Intrinsics.checkNotNullParameter(ddSpanToSpanEventMapper, (String)"ddSpanToSpanEventMapper");
        Intrinsics.checkNotNullParameter(eventMapper, (String)"eventMapper");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        this.sdkCore = sdkCore;
        this.ddSpanToSpanEventMapper = ddSpanToSpanEventMapper;
        this.eventMapper = eventMapper;
        this.serializer = serializer;
        this.internalLogger = internalLogger;
    }

    public /* synthetic */ OtelTraceWriter(FeatureSdkCore featureSdkCore, ContextAwareMapper contextAwareMapper, EventMapper eventMapper, ContextAwareSerializer contextAwareSerializer, InternalLogger internalLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            eventMapper = (EventMapper)new NoOpEventMapper();
        }
        this(featureSdkCore, contextAwareMapper, (EventMapper<SpanEvent>)eventMapper, contextAwareSerializer, internalLogger);
    }

    @NotNull
    public final ContextAwareMapper<DDSpan, SpanEvent> getDdSpanToSpanEventMapper$dd_sdk_android_trace_release() {
        return this.ddSpanToSpanEventMapper;
    }

    @NotNull
    public final EventMapper<SpanEvent> getEventMapper$dd_sdk_android_trace_release() {
        return this.eventMapper;
    }

    @Override
    public void start() {
    }

    @Override
    public void write(@Nullable List<DDSpan> trace) {
        if (trace == null) {
            return;
        }
        FeatureScope featureScope = this.sdkCore.getFeature("tracing");
        if (featureScope != null) {
            FeatureScope.DefaultImpls.withWriteContext$default((FeatureScope)featureScope, (boolean)false, (Function2)((Function2)new Function2<DatadogContext, EventBatchWriter, Unit>(trace, this){
                final /* synthetic */ List<DDSpan> $trace;
                final /* synthetic */ OtelTraceWriter this$0;
                {
                    this.$trace = $trace;
                    this.this$0 = $receiver;
                    super(2);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(@NotNull DatadogContext datadogContext, @NotNull EventBatchWriter eventBatchWriter) {
                    void $this$forEach$iv;
                    Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
                    Intrinsics.checkNotNullParameter((Object)eventBatchWriter, (String)"eventBatchWriter");
                    Iterable iterable = this.$trace;
                    OtelTraceWriter otelTraceWriter = this.this$0;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        DDSpan span = (DDSpan)element$iv;
                        boolean bl = false;
                        OtelTraceWriter.access$writeSpan(otelTraceWriter, datadogContext, eventBatchWriter, span);
                    }
                }
            }), (int)1, null);
        }
    }

    @Override
    public boolean flush() {
        return true;
    }

    @Override
    public void incrementDropCounts(int p0) {
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private final void writeSpan(DatadogContext datadogContext, EventBatchWriter writer, DDSpan span) {
        SpanEvent spanEvent = this.ddSpanToSpanEventMapper.map(datadogContext, span);
        SpanEvent spanEvent2 = (SpanEvent)this.eventMapper.map((Object)spanEvent);
        if (spanEvent2 == null) {
            return;
        }
        SpanEvent mapped = spanEvent2;
        try {
            byte[] byArray;
            Object object;
            block11: {
                block10: {
                    object = this.serializer.serialize(datadogContext, mapped);
                    if (object == null) break block10;
                    byte[] byArray2 = ((String)object).getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
                    byArray = byArray2;
                    if (byArray != null) break block11;
                }
                return;
            }
            byte[] serialized = byArray;
            object = this;
            synchronized (object) {
                boolean bl = false;
                boolean bl2 = writer.write(new RawBatchEvent(serialized, null, 2, null), null, EventType.DEFAULT);
            }
        }
        catch (Throwable e) {
            Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
            InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>(mapped){
                final /* synthetic */ SpanEvent $mapped;
                {
                    this.$mapped = $mapped;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    String string = "Error serializing %s model";
                    Locale locale = Locale.US;
                    Object[] objectArray = new Object[]{this.$mapped.getClass().getSimpleName()};
                    String string2 = String.format(locale, string, Arrays.copyOf(objectArray, objectArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
                    return string2;
                }
            }), (Throwable)e, (boolean)false, null, (int)48, null);
        }
    }

    public static final /* synthetic */ void access$writeSpan(OtelTraceWriter $this, DatadogContext datadogContext, EventBatchWriter writer, DDSpan span) {
        $this.writeSpan(datadogContext, writer, span);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/datadog/android/trace/internal/data/OtelTraceWriter$Companion;", "", "()V", "ERROR_SERIALIZING", "", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

