/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import com.datadog.android.api.context.DeviceInfo;
import com.datadog.android.api.context.DeviceType;
import com.datadog.android.api.context.NetworkInfo;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.trace.internal.domain.event.ContextAwareMapper;
import com.datadog.android.trace.model.SpanEvent;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\u0004\b\u0000\u0010\u00012\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0004J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0004\u00a8\u0006\u0019"}, d2={"Lcom/datadog/android/trace/internal/domain/event/BaseSpanEventMapper;", "T", "Lcom/datadog/android/trace/internal/domain/event/ContextAwareMapper;", "Lcom/datadog/android/trace/model/SpanEvent;", "()V", "resolveDeviceInfo", "Lcom/datadog/android/trace/model/SpanEvent$Device;", "deviceInfo", "Lcom/datadog/android/api/context/DeviceInfo;", "resolveDeviceType", "Lcom/datadog/android/trace/model/SpanEvent$Type;", "deviceType", "Lcom/datadog/android/api/context/DeviceType;", "resolveNetworkInfo", "Lcom/datadog/android/trace/model/SpanEvent$Network;", "networkInfo", "Lcom/datadog/android/api/context/NetworkInfo;", "resolveOsInfo", "Lcom/datadog/android/trace/model/SpanEvent$Os;", "resolveSimCarrier", "Lcom/datadog/android/trace/model/SpanEvent$SimCarrier;", "resolveUserInfo", "Lcom/datadog/android/trace/model/SpanEvent$Usr;", "userInfo", "Lcom/datadog/android/api/context/UserInfo;", "dd-sdk-android-trace_release"})
public abstract class BaseSpanEventMapper<T>
implements ContextAwareMapper<T, SpanEvent> {
    @NotNull
    protected final SpanEvent.Usr resolveUserInfo(@NotNull UserInfo userInfo) {
        Intrinsics.checkNotNullParameter((Object)userInfo, (String)"userInfo");
        return new SpanEvent.Usr(userInfo.getId(), userInfo.getName(), userInfo.getEmail(), MapsKt.toMutableMap((Map)userInfo.getAdditionalProperties()));
    }

    @NotNull
    protected final SpanEvent.Device resolveDeviceInfo(@NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        return new SpanEvent.Device(this.resolveDeviceType(deviceInfo.getDeviceType()), deviceInfo.getDeviceName(), deviceInfo.getDeviceModel(), deviceInfo.getDeviceBrand(), deviceInfo.getArchitecture());
    }

    @NotNull
    protected final SpanEvent.Network resolveNetworkInfo(@NotNull NetworkInfo networkInfo) {
        Intrinsics.checkNotNullParameter((Object)networkInfo, (String)"networkInfo");
        SpanEvent.SimCarrier simCarrier = this.resolveSimCarrier(networkInfo);
        Long l = networkInfo.getStrength();
        Long l2 = networkInfo.getDownKbps();
        Long l3 = networkInfo.getUpKbps();
        SpanEvent.Client networkInfoClient = new SpanEvent.Client(simCarrier, l != null ? l.toString() : null, l2 != null ? l2.toString() : null, l3 != null ? l3.toString() : null, networkInfo.getConnectivity().toString());
        return new SpanEvent.Network(networkInfoClient);
    }

    @NotNull
    protected final SpanEvent.Os resolveOsInfo(@NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        return new SpanEvent.Os(deviceInfo.getOsName(), deviceInfo.getOsVersion(), null, deviceInfo.getOsMajorVersion(), 4, null);
    }

    private final SpanEvent.SimCarrier resolveSimCarrier(NetworkInfo networkInfo) {
        SpanEvent.SimCarrier simCarrier;
        if (networkInfo.getCarrierId() != null || networkInfo.getCarrierName() != null) {
            Long l = networkInfo.getCarrierId();
            simCarrier = new SpanEvent.SimCarrier(l != null ? l.toString() : null, networkInfo.getCarrierName());
        } else {
            simCarrier = null;
        }
        return simCarrier;
    }

    private final SpanEvent.Type resolveDeviceType(DeviceType deviceType) {
        SpanEvent.Type type;
        switch (WhenMappings.$EnumSwitchMapping$0[deviceType.ordinal()]) {
            case 1: {
                type = SpanEvent.Type.MOBILE;
                break;
            }
            case 2: {
                type = SpanEvent.Type.TABLET;
                break;
            }
            case 3: {
                type = SpanEvent.Type.TV;
                break;
            }
            case 4: {
                type = SpanEvent.Type.DESKTOP;
                break;
            }
            default: {
                type = SpanEvent.Type.OTHER;
            }
        }
        return type;
    }

    @Metadata(mv={1, 7, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DeviceType.values().length];
            try {
                nArray[DeviceType.MOBILE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.TABLET.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.TV.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DeviceType.DESKTOP.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

