/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/datadog/android/trace/internal/domain/event/BigIntegerUtils;", "", "()V", "HEX_RADIX", "", "LONG_BITS_SIZE", "LONG_MASK", "Ljava/math/BigInteger;", "getLONG_MASK$annotations", "REQUIRED_ID_HEX_LENGTH", "leastSignificant64BitsAsDecimal", "", "traceId", "leastSignificant64BitsAsHex", "mostSignificant64BitsAsHex", "dd-sdk-android-trace_release"})
public final class BigIntegerUtils {
    @NotNull
    public static final BigIntegerUtils INSTANCE = new BigIntegerUtils();
    private static final int LONG_BITS_SIZE = 64;
    private static final int HEX_RADIX = 16;
    private static final int REQUIRED_ID_HEX_LENGTH = 16;
    @NotNull
    private static final BigInteger LONG_MASK = new BigInteger("ffffffffffffffff", 16);

    private BigIntegerUtils() {
    }

    private static /* synthetic */ void getLONG_MASK$annotations() {
    }

    @NotNull
    public final String leastSignificant64BitsAsHex(@NotNull BigInteger traceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        try {
            String string2 = traceId.and(LONG_MASK).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"traceId.and(LONG_MASK).toString(HEX_RADIX)");
            string = StringsKt.padStart((String)string2, (int)16, (char)'0');
        }
        catch (NumberFormatException e) {
            string = "";
        }
        catch (ArithmeticException e) {
            string = "";
        }
        catch (IllegalArgumentException e) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String leastSignificant64BitsAsDecimal(@NotNull BigInteger traceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        try {
            String string2 = traceId.and(LONG_MASK).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            traceId.an\u2026ASK).toString()\n        }");
            string = string2;
        }
        catch (NumberFormatException e) {
            string = "";
        }
        catch (ArithmeticException e) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String mostSignificant64BitsAsHex(@NotNull BigInteger traceId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)traceId, (String)"traceId");
        try {
            String string2 = traceId.shiftRight(64).toString(16);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"traceId.shiftRight(LONG_\u2026SIZE).toString(HEX_RADIX)");
            string = StringsKt.padStart((String)string2, (int)16, (char)'0');
        }
        catch (NumberFormatException e) {
            string = "";
        }
        catch (ArithmeticException e) {
            string = "";
        }
        catch (IllegalArgumentException e) {
            string = "";
        }
        return string;
    }
}

