/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.api.context.UserInfo;
import com.datadog.android.core.internal.utils.NumberExtKt;
import com.datadog.android.trace.internal.domain.event.BaseSpanEventMapper;
import com.datadog.android.trace.internal.domain.event.BigIntegerUtils;
import com.datadog.android.trace.model.SpanEvent;
import com.datadog.opentracing.DDSpan;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0002H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\u0002H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"Lcom/datadog/android/trace/internal/domain/event/DdSpanToSpanEventMapper;", "Lcom/datadog/android/trace/internal/domain/event/BaseSpanEventMapper;", "Lcom/datadog/opentracing/DDSpan;", "networkInfoEnabled", "", "bigIntegerUtils", "Lcom/datadog/android/trace/internal/domain/event/BigIntegerUtils;", "(ZLcom/datadog/android/trace/internal/domain/event/BigIntegerUtils;)V", "getNetworkInfoEnabled$dd_sdk_android_trace_release", "()Z", "map", "Lcom/datadog/android/trace/model/SpanEvent;", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "model", "resolveMeta", "Lcom/datadog/android/trace/model/SpanEvent$Meta;", "event", "resolveMetrics", "Lcom/datadog/android/trace/model/SpanEvent$Metrics;", "dd-sdk-android-trace_release"})
@SourceDebugExtension(value={"SMAP\nDdSpanToSpanEventMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DdSpanToSpanEventMapper.kt\ncom/datadog/android/trace/internal/domain/event/DdSpanToSpanEventMapper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,85:1\n1#2:86\n*E\n"})
public final class DdSpanToSpanEventMapper
extends BaseSpanEventMapper<DDSpan> {
    private final boolean networkInfoEnabled;
    @NotNull
    private final BigIntegerUtils bigIntegerUtils;

    public DdSpanToSpanEventMapper(boolean networkInfoEnabled, @NotNull BigIntegerUtils bigIntegerUtils) {
        Intrinsics.checkNotNullParameter((Object)bigIntegerUtils, (String)"bigIntegerUtils");
        this.networkInfoEnabled = networkInfoEnabled;
        this.bigIntegerUtils = bigIntegerUtils;
    }

    public /* synthetic */ DdSpanToSpanEventMapper(boolean bl, BigIntegerUtils bigIntegerUtils, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bigIntegerUtils = BigIntegerUtils.INSTANCE;
        }
        this(bl, bigIntegerUtils);
    }

    public final boolean getNetworkInfoEnabled$dd_sdk_android_trace_release() {
        return this.networkInfoEnabled;
    }

    @Override
    @NotNull
    public SpanEvent map(@NotNull DatadogContext datadogContext, @NotNull DDSpan model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        long serverOffset = datadogContext.getTime().getServerTimeOffsetNs();
        SpanEvent.Metrics metrics = this.resolveMetrics(model);
        SpanEvent.Meta metadata = this.resolveMeta(datadogContext, model);
        BigInteger bigInteger = model.getTraceId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"model.traceId");
        String leastSignificantTraceId = this.bigIntegerUtils.leastSignificant64BitsAsHex(bigInteger);
        BigInteger bigInteger2 = model.getSpanId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"model.spanId");
        String string = NumberExtKt.toHexString((BigInteger)bigInteger2);
        BigInteger bigInteger3 = model.getParentId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger3, (String)"model.parentId");
        String string2 = NumberExtKt.toHexString((BigInteger)bigInteger3);
        String string3 = model.getResourceName();
        String string4 = model.getOperationName();
        String string5 = model.getServiceName();
        long l = model.getDurationNano();
        long l2 = model.getStartTime() + serverOffset;
        Boolean bl = model.isError();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"model.isError");
        long l3 = bl != false ? 1L : 0L;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"resourceName");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"operationName");
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"serviceName");
        return new SpanEvent(leastSignificantTraceId, string, string2, string3, string4, string5, l, l2, l3, metrics, metadata);
    }

    private final SpanEvent.Metrics resolveMetrics(DDSpan event) {
        Long l = event.getParentId().longValue() == 0L ? Long.valueOf(1L) : null;
        Map<String, Number> map2 = event.getMetrics();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"event.metrics");
        return new SpanEvent.Metrics(l, map2);
    }

    private final SpanEvent.Meta resolveMeta(DatadogContext datadogContext, DDSpan event) {
        SpanEvent.View view;
        SpanEvent.Session session;
        SpanEvent.Session session2;
        SpanEvent.Application application;
        SpanEvent.Application application2;
        Object it;
        String string;
        SpanEvent.Network networkInfoMeta = this.networkInfoEnabled ? this.resolveNetworkInfo(datadogContext.getNetworkInfo()) : null;
        SpanEvent.Device deviceInfo = this.resolveDeviceInfo(datadogContext.getDeviceInfo());
        SpanEvent.Os osInfo = this.resolveOsInfo(datadogContext.getDeviceInfo());
        UserInfo userInfo = datadogContext.getUserInfo();
        BigInteger bigInteger = event.getTraceId();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"event.traceId");
        String mostSignificantTraceId = this.bigIntegerUtils.mostSignificant64BitsAsHex(bigInteger);
        Map additionalProperties = new LinkedHashMap();
        additionalProperties.put("_dd.p.id", mostSignificantTraceId);
        additionalProperties.put("variant", datadogContext.getVariant());
        Map map2 = additionalProperties;
        Map<String, String> map3 = event.getMeta();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"event.meta");
        map2.putAll(map3);
        SpanEvent.Usr usrMeta = this.resolveUserInfo(userInfo);
        String string2 = datadogContext.getSource();
        Object object = event.getTags().get("application_id");
        if (object != null) {
            Object object2 = object;
            string = string2;
            boolean bl = false;
            application2 = new SpanEvent.Application(it instanceof String ? (String)it : null);
            string2 = string;
        } else {
            application2 = null;
        }
        Object object3 = event.getTags().get("session_id");
        if (object3 != null) {
            it = object3;
            application = application2;
            string = string2;
            boolean bl = false;
            session2 = new SpanEvent.Session(it instanceof String ? (String)it : null);
            string2 = string;
            application2 = application;
            session = session2;
        } else {
            session = null;
        }
        Object object4 = event.getTags().get("view.id");
        if (object4 != null) {
            it = object4;
            session2 = session;
            application = application2;
            string = string2;
            boolean bl = false;
            SpanEvent.View view2 = new SpanEvent.View(it instanceof String ? (String)it : null);
            string2 = string;
            application2 = application;
            session = session2;
            view = view2;
        } else {
            view = null;
        }
        SpanEvent.View view3 = view;
        SpanEvent.Session session3 = session;
        SpanEvent.Application application3 = application2;
        String string3 = string2;
        SpanEvent.Dd dd = new SpanEvent.Dd(string3, application3, session3, view3);
        return new SpanEvent.Meta(datadogContext.getVersion(), dd, new SpanEvent.Span(), new SpanEvent.Tracer(datadogContext.getSdkVersion()), usrMeta, networkInfoMeta, deviceInfo, osInfo, additionalProperties);
    }
}

