/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.android.trace.internal.domain.event;

import com.datadog.android.api.InternalLogger;
import com.datadog.android.api.context.DatadogContext;
import com.datadog.android.core.constraints.DataConstraints;
import com.datadog.android.core.constraints.DatadogDataConstraints;
import com.datadog.android.core.internal.utils.MapUtilsKt;
import com.datadog.android.trace.internal.storage.ContextAwareSerializer;
import com.datadog.android.trace.model.SpanEvent;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00172\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0017B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u00112\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/datadog/android/trace/internal/domain/event/SpanEventSerializer;", "Lcom/datadog/android/trace/internal/storage/ContextAwareSerializer;", "Lcom/datadog/android/trace/model/SpanEvent;", "internalLogger", "Lcom/datadog/android/api/InternalLogger;", "dataConstraints", "Lcom/datadog/android/core/constraints/DataConstraints;", "(Lcom/datadog/android/api/InternalLogger;Lcom/datadog/android/core/constraints/DataConstraints;)V", "sanitizeKeys", "model", "sanitizeMetrics", "Lcom/datadog/android/trace/model/SpanEvent$Metrics;", "metrics", "sanitizeUserAttributes", "Lcom/datadog/android/trace/model/SpanEvent$Usr;", "usr", "serialize", "", "datadogContext", "Lcom/datadog/android/api/context/DatadogContext;", "toMetaString", "element", "", "Companion", "dd-sdk-android-trace_release"})
@SourceDebugExtension(value={"SMAP\nSpanEventSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpanEventSerializer.kt\ncom/datadog/android/trace/internal/domain/event/SpanEventSerializer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,109:1\n453#2:110\n403#2:111\n494#2,7:116\n1238#3,4:112\n*S KotlinDebug\n*F\n+ 1 SpanEventSerializer.kt\ncom/datadog/android/trace/internal/domain/event/SpanEventSerializer\n*L\n55#1:110\n55#1:111\n73#1:116,7\n55#1:112,4\n*E\n"})
public final class SpanEventSerializer
implements ContextAwareSerializer<SpanEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final InternalLogger internalLogger;
    @NotNull
    private final DataConstraints dataConstraints;
    @NotNull
    public static final String TAG_SPANS = "spans";
    @NotNull
    public static final String TAG_ENV = "env";
    @NotNull
    public static final String META_USR_KEY_PREFIX = "meta.usr";
    @NotNull
    public static final String METRICS_KEY_PREFIX = "metrics";

    public SpanEventSerializer(@NotNull InternalLogger internalLogger, @NotNull DataConstraints dataConstraints) {
        Intrinsics.checkNotNullParameter((Object)internalLogger, (String)"internalLogger");
        Intrinsics.checkNotNullParameter((Object)dataConstraints, (String)"dataConstraints");
        this.internalLogger = internalLogger;
        this.dataConstraints = dataConstraints;
    }

    public /* synthetic */ SpanEventSerializer(InternalLogger internalLogger, DataConstraints dataConstraints, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dataConstraints = (DataConstraints)new DatadogDataConstraints(internalLogger);
        }
        this(internalLogger, dataConstraints);
    }

    @Override
    @NotNull
    public String serialize(@NotNull DatadogContext datadogContext, @NotNull SpanEvent model) {
        Intrinsics.checkNotNullParameter((Object)datadogContext, (String)"datadogContext");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        JsonElement span = this.sanitizeKeys(model).toJson();
        JsonArray spans = new JsonArray(1);
        spans.add(span);
        JsonObject jsonObject = new JsonObject();
        jsonObject.add(TAG_SPANS, (JsonElement)spans);
        jsonObject.addProperty(TAG_ENV, datadogContext.getEnv());
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        return string;
    }

    private final SpanEvent sanitizeKeys(SpanEvent model) {
        SpanEvent.Usr newUserObject = this.sanitizeUserAttributes(model.getMeta().getUsr());
        SpanEvent.Metrics newMetricsObject = this.sanitizeMetrics(model.getMetrics());
        SpanEvent.Meta meta = SpanEvent.Meta.copy$default(model.getMeta(), null, null, null, null, newUserObject, null, null, null, null, 495, null);
        return SpanEvent.copy$default(model, null, null, null, null, null, null, 0L, 0L, 0L, newMetricsObject, meta, 511, null);
    }

    /*
     * WARNING - void declaration
     */
    private final SpanEvent.Usr sanitizeUserAttributes(SpanEvent.Usr usr) {
        void $this$mapValuesTo$iv$iv;
        Map $this$mapValues$iv = DataConstraints.DefaultImpls.validateAttributes$default((DataConstraints)this.dataConstraints, usr.getAdditionalProperties(), (String)META_USR_KEY_PREFIX, null, null, (int)12, null);
        boolean $i$f$mapValues = false;
        Map map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            String string;
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            try {
                string = this.toMetaString(it.getValue());
            }
            catch (Exception e) {
                Object[] objectArray = new InternalLogger.Target[]{InternalLogger.Target.USER, InternalLogger.Target.TELEMETRY};
                InternalLogger.DefaultImpls.log$default((InternalLogger)this.internalLogger, (InternalLogger.Level)InternalLogger.Level.ERROR, (List)CollectionsKt.listOf((Object[])objectArray), (Function0)((Function0)new Function0<String>((Map.Entry<String, ? extends Object>)it){
                    final /* synthetic */ Map.Entry<String, Object> $it;
                    {
                        this.$it = $it;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Error converting value for key " + this.$it.getKey() + " to meta string, it will be dropped.";
                    }
                }), (Throwable)e, (boolean)false, null, (int)48, null);
                string = null;
            }
            String string2 = string;
            map4.put(k, string2);
        }
        Map $this$filterValues$iv = destination$iv$iv;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            String it = (String)entry$iv.getValue();
            boolean bl = false;
            if (!(it != null)) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Map transformedAttributes2 = result$iv;
        return SpanEvent.Usr.copy$default(usr, null, null, null, MapsKt.toMutableMap((Map)transformedAttributes2), 7, null);
    }

    private final SpanEvent.Metrics sanitizeMetrics(SpanEvent.Metrics metrics) {
        Map transformedMetrics = DataConstraints.DefaultImpls.validateAttributes$default((DataConstraints)this.dataConstraints, metrics.getAdditionalProperties(), (String)METRICS_KEY_PREFIX, null, null, (int)12, null);
        return SpanEvent.Metrics.copy$default(metrics, null, transformedMetrics, 1, null);
    }

    private final String toMetaString(Object element) {
        Object object = element;
        return Intrinsics.areEqual((Object)object, (Object)MapUtilsKt.getNULL_MAP_VALUE()) ? null : (object == null ? null : (object instanceof Date ? String.valueOf(((Date)element).getTime()) : (object instanceof JsonPrimitive ? ((JsonPrimitive)element).getAsString() : element.toString())));
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/datadog/android/trace/internal/domain/event/SpanEventSerializer$Companion;", "", "()V", "META_USR_KEY_PREFIX", "", "METRICS_KEY_PREFIX", "TAG_ENV", "TAG_SPANS", "dd-sdk-android-trace_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

