/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing;

import android.os.StrictMode;
import com.datadog.android.api.InternalLogger;
import com.datadog.legacy.trace.api.Config;
import com.datadog.legacy.trace.api.interceptor.MutableSpan;
import com.datadog.legacy.trace.api.interceptor.TraceInterceptor;
import com.datadog.legacy.trace.common.sampling.PrioritySampler;
import com.datadog.legacy.trace.common.sampling.Sampler;
import com.datadog.legacy.trace.common.writer.LoggingWriter;
import com.datadog.legacy.trace.common.writer.Writer;
import com.datadog.legacy.trace.context.ScopeListener;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.DefaultLogHandler;
import com.datadog.opentracing.LogHandler;
import com.datadog.opentracing.PendingTrace;
import com.datadog.opentracing.StringCachingBigInteger;
import com.datadog.opentracing.decorators.AbstractDecorator;
import com.datadog.opentracing.decorators.DDDecoratorsFactory;
import com.datadog.opentracing.jfr.DDNoopScopeEventFactory;
import com.datadog.opentracing.jfr.DDScopeEventFactory;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import com.datadog.opentracing.scopemanager.ContextualScopeManager;
import com.datadog.opentracing.scopemanager.ScopeContext;
import com.datadog.trace.api.IdGenerationStrategy;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import io.opentracing.tag.Tag;
import java.io.Closeable;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public class DDTracer
implements Tracer,
Closeable,
com.datadog.legacy.trace.api.Tracer {
    public static final BigInteger TRACE_ID_128_BITS_MAX = BigInteger.valueOf(2L).pow(128).subtract(BigInteger.ONE);
    public static final BigInteger TRACE_ID_64_BITS_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    public static final BigInteger TRACE_ID_MIN = BigInteger.ZERO;
    final String serviceName;
    final Writer writer;
    final Sampler sampler;
    final ScopeManager scopeManager;
    private final Map<String, String> localRootSpanTags;
    private final Map<String, String> defaultSpanTags;
    private final Map<String, String> serviceNameMappings;
    private final int partialFlushMinSpans;
    private final Thread shutdownCallback;
    private final Map<String, List<AbstractDecorator>> spanContextDecorators = new ConcurrentHashMap<String, List<AbstractDecorator>>();
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(new Comparator<TraceInterceptor>(){

        @Override
        public int compare(TraceInterceptor o1, TraceInterceptor o2) {
            return Integer.compare(o1.priority(), o2.priority());
        }
    });
    private final HttpCodec.Injector injector;
    private final HttpCodec.Extractor extractor;
    private final IdGenerationStrategy idGenerationStrategy = IdGenerationStrategy.fromName("SECURE_RANDOM", true);
    private final Random random;

    protected DDTracer(Config config, Writer writer, Random random) {
        this(config.getServiceName(), writer, Sampler.Builder.forConfig(config), HttpCodec.createInjector(config), HttpCodec.createExtractor(config, config.getHeaderTags()), new ContextualScopeManager(Config.get().getScopeDepthLimit(), DDTracer.createScopeEventFactory()), random, config.getLocalRootSpanTags(), config.getMergedSpanTags(), config.getServiceMapping(), config.getHeaderTags(), config.getPartialFlushMinSpans());
    }

    private DDTracer(String serviceName2, Writer writer, Sampler sampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, ScopeManager scopeManager, Random random, Map<String, String> localRootSpanTags, Map<String, String> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, int partialFlushMinSpans) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        this.random = random;
        this.serviceName = serviceName2;
        this.writer = writer == null ? new LoggingWriter() : writer;
        this.sampler = sampler;
        this.injector = injector;
        this.extractor = extractor;
        this.scopeManager = scopeManager;
        this.localRootSpanTags = localRootSpanTags;
        this.defaultSpanTags = defaultSpanTags;
        this.serviceNameMappings = serviceNameMappings;
        this.partialFlushMinSpans = partialFlushMinSpans;
        this.writer.start();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        List<AbstractDecorator> decorators = DDDecoratorsFactory.createBuiltinDecorators();
        for (AbstractDecorator decorator : decorators) {
            this.addDecorator(decorator);
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        PendingTrace.initialize();
    }

    public void finalize() {
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
            this.shutdownCallback.run();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public List<AbstractDecorator> getSpanContextDecorators(String tag) {
        return this.spanContextDecorators.get(tag);
    }

    public void addDecorator(AbstractDecorator decorator) {
        List<AbstractDecorator> list = this.spanContextDecorators.get(decorator.getMatchingTag());
        if (list == null) {
            list = new ArrayList<AbstractDecorator>();
        }
        list.add(decorator);
        this.spanContextDecorators.put(decorator.getMatchingTag(), list);
    }

    @Deprecated
    public void addScopeContext(ScopeContext context) {
        if (this.scopeManager instanceof ContextualScopeManager) {
            ((ContextualScopeManager)this.scopeManager).addScopeContext(context);
        }
    }

    public void registerClassLoader(ClassLoader classLoader) {
        try {
            StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
            ServiceLoader<TraceInterceptor> serviceLoader = ServiceLoader.load(TraceInterceptor.class, classLoader);
            for (TraceInterceptor interceptor : serviceLoader) {
                this.addTraceInterceptor(interceptor);
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)oldPolicy);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            // empty catch block
        }
    }

    public ScopeManager scopeManager() {
        return this.scopeManager;
    }

    public Span activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public Scope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new DDSpanBuilder(operationName, this.scopeManager);
    }

    public <T> void inject(SpanContext spanContext, Format<T> format, T carrier) {
        if (carrier instanceof TextMapInject) {
            DDSpanContext ddSpanContext = (DDSpanContext)spanContext;
            DDSpan rootSpan = ddSpanContext.getTrace().getRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            this.injector.inject(ddSpanContext, (TextMapInject)carrier);
        }
    }

    public <T> SpanContext extract(Format<T> format, T carrier) {
        if (carrier instanceof TextMapExtract) {
            return this.extractor.extract((TextMapExtract)carrier);
        }
        return null;
    }

    void write(Collection<DDSpan> trace) {
        ArrayList<DDSpan> writtenTrace;
        if (trace.isEmpty()) {
            return;
        }
        if (this.interceptors.isEmpty()) {
            writtenTrace = new ArrayList<DDSpan>(trace);
        } else {
            Collection<MutableSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
            }
            writtenTrace = new ArrayList(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                writtenTrace.add((DDSpan)mutableSpan);
            }
        }
        this.incrementTraceCount();
        if (!writtenTrace.isEmpty()) {
            DDSpan spanToSample;
            DDSpan rootSpan = (DDSpan)writtenTrace.get(0).getLocalRootSpan();
            this.setSamplingPriorityIfNecessary(rootSpan);
            DDSpan dDSpan = spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
            if (this.sampler.sample(spanToSample)) {
                this.writer.write(writtenTrace);
            }
        }
    }

    void setSamplingPriorityIfNecessary(DDSpan rootSpan) {
        if (this.sampler instanceof PrioritySampler && rootSpan != null && rootSpan.context().getSamplingPriority() == Integer.MIN_VALUE) {
            ((PrioritySampler)((Object)this.sampler)).setSamplingPriority(rootSpan);
        }
    }

    void incrementTraceCount() {
        this.writer.incrementTraceCount();
    }

    @Override
    public String getTraceId() {
        Span activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getTraceId().toString();
        }
        return "0";
    }

    @Override
    public String getSpanId() {
        Span activeSpan = this.activeSpan();
        if (activeSpan instanceof DDSpan) {
            return ((DDSpan)activeSpan).getSpanId().toString();
        }
        return "0";
    }

    @Override
    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        return this.interceptors.add(interceptor);
    }

    @Override
    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContextualScopeManager) {
            ((ContextualScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void close() {
        PendingTrace.close();
        this.writer.close();
    }

    public String toString() {
        return "DDTracer-" + Integer.toHexString(this.hashCode()) + "{ serviceName=" + this.serviceName + ", writer=" + this.writer + ", sampler=" + this.sampler + ", defaultSpanTags=" + this.defaultSpanTags + '}';
    }

    @Deprecated
    private static Map<String, String> customRuntimeTags(String runtimeId, Map<String, String> applicationRootSpanTags) {
        HashMap<String, String> runtimeTags = new HashMap<String, String>(applicationRootSpanTags);
        runtimeTags.put("runtime-id", runtimeId);
        return Collections.unmodifiableMap(runtimeTags);
    }

    private static DDScopeEventFactory createScopeEventFactory() {
        try {
            return (DDScopeEventFactory)Class.forName("com.datadog.opentracing.jfr.openjdk.ScopeEventFactory").newInstance();
        }
        catch (ClassFormatError | NoClassDefFoundError | ReflectiveOperationException throwable) {
            return new DDNoopScopeEventFactory();
        }
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<DDTracer> reference;

        private ShutdownHook(DDTracer tracer) {
            super("dd-tracer-shutdown-hook");
            this.reference = new WeakReference<DDTracer>(tracer);
        }

        @Override
        public void run() {
            DDTracer tracer = (DDTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class DDSpanBuilder
    implements Tracer.SpanBuilder {
        private final ScopeManager scopeManager;
        private final String operationName;
        private final Map<String, Object> tags;
        private long timestampMicro;
        private SpanContext parent;
        private String serviceName;
        private String resourceName;
        private String origin;
        private boolean errorFlag;
        private String spanType;
        private boolean ignoreScope;
        private LogHandler logHandler;
        private InternalLogger internalLogger;

        public DDSpanBuilder(String operationName, ScopeManager scopeManager) {
            this.tags = new LinkedHashMap<String, String>(DDTracer.this.defaultSpanTags);
            this.ignoreScope = false;
            this.logHandler = new DefaultLogHandler();
            this.internalLogger = InternalLogger.Companion.getUNBOUND();
            this.operationName = operationName;
            this.scopeManager = scopeManager;
        }

        public Tracer.SpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private Span startSpan() {
            return new DDSpan(this.timestampMicro, this.buildSpanContext(), this.logHandler, this.internalLogger);
        }

        public Scope startActive(boolean finishSpanOnClose) {
            Span span = this.startSpan();
            Scope scope = this.scopeManager.activate(span, finishSpanOnClose);
            return scope;
        }

        @Deprecated
        public Span startManual() {
            return this.start();
        }

        public Span start() {
            Span span = this.startSpan();
            return span;
        }

        public DDSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        public DDSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)string);
        }

        public DDSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        public <T> Tracer.SpanBuilder withTag(Tag<T> tag, T value) {
            return this.withTag(tag.getKey(), value);
        }

        public DDSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        public DDSpanBuilder withServiceName(String serviceName2) {
            this.serviceName = serviceName2;
            return this;
        }

        public DDSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public DDSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        public DDSpanBuilder withSpanType(String spanType) {
            this.spanType = spanType;
            return this;
        }

        public Iterable<Map.Entry<String, String>> baggageItems() {
            if (this.parent == null) {
                return Collections.emptyList();
            }
            return this.parent.baggageItems();
        }

        public DDSpanBuilder withLogHandler(LogHandler logHandler) {
            if (logHandler != null) {
                this.logHandler = logHandler;
            }
            return this;
        }

        public DDSpanBuilder withInternalLogger(InternalLogger internalLogger) {
            if (internalLogger != null) {
                this.internalLogger = internalLogger;
            }
            return this;
        }

        public DDSpanBuilder asChildOf(Span span) {
            return this.asChildOf(span == null ? null : span.context());
        }

        public DDSpanBuilder asChildOf(SpanContext spanContext) {
            this.parent = spanContext;
            return this;
        }

        public DDSpanBuilder addReference(String referenceType, SpanContext spanContext) {
            if (spanContext == null) {
                return this;
            }
            if (!(spanContext instanceof ExtractedContext) && !(spanContext instanceof DDSpanContext)) {
                return this;
            }
            if ("child_of".equals(referenceType) || "follows_from".equals(referenceType)) {
                return this.asChildOf(spanContext);
            }
            return this;
        }

        public DDSpanBuilder withOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        private DDSpanBuilder withTag(String tag, Object value) {
            if (value == null || value instanceof String && ((String)value).isEmpty()) {
                this.tags.remove(tag);
            } else {
                this.tags.put(tag, value);
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BigInteger generateNewSpanId() {
            StringCachingBigInteger value;
            do {
                Random random = DDTracer.this.random;
                synchronized (random) {
                    value = new StringCachingBigInteger(63, DDTracer.this.random);
                }
            } while (value.signum() == 0);
            return value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BigInteger generateNewTraceId() {
            BigInteger value;
            do {
                IdGenerationStrategy idGenerationStrategy = DDTracer.this.idGenerationStrategy;
                synchronized (idGenerationStrategy) {
                    value = new BigInteger(DDTracer.this.idGenerationStrategy.generateTraceId().toHexString(), 16);
                }
            } while (value.signum() == 0);
            return value;
        }

        private DDSpanContext buildSpanContext() {
            String origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            BigInteger parentSpanId;
            BigInteger traceId;
            Span activeSpan;
            BigInteger spanId = this.generateNewSpanId();
            SpanContext parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            if (parentContext instanceof DDSpanContext) {
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = Integer.MIN_VALUE;
                origin = null;
                if (this.serviceName == null) {
                    this.serviceName = ddsc.getServiceName();
                }
            } else {
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    baggage = extractedContext.getBaggage();
                } else {
                    traceId = this.generateNewTraceId();
                    parentSpanId = BigInteger.ZERO;
                    samplingPriority = Integer.MIN_VALUE;
                    baggage = null;
                }
                if (parentContext instanceof TagContext) {
                    this.tags.putAll(((TagContext)parentContext).getTags());
                    origin = ((TagContext)parentContext).getOrigin();
                } else {
                    origin = this.origin;
                }
                this.tags.putAll(DDTracer.this.localRootSpanTags);
                parentTrace = new PendingTrace(DDTracer.this, traceId, this.internalLogger);
            }
            if (this.serviceName == null) {
                this.serviceName = DDTracer.this.serviceName;
            }
            String operationName = this.operationName != null ? this.operationName : this.resourceName;
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, this.tags, parentTrace, DDTracer.this, DDTracer.this.serviceNameMappings, this.internalLogger);
            for (Map.Entry<String, Object> tag : this.tags.entrySet()) {
                if (tag.getValue() == null) {
                    context.setTag(tag.getKey(), null);
                    continue;
                }
                boolean addTag = true;
                List<AbstractDecorator> decorators = DDTracer.this.getSpanContextDecorators(tag.getKey());
                if (decorators != null) {
                    for (AbstractDecorator decorator : decorators) {
                        try {
                            addTag &= decorator.shouldSetTag(context, tag.getKey(), tag.getValue());
                        }
                        catch (Throwable throwable) {}
                    }
                }
                if (addTag) continue;
                context.setTag(tag.getKey(), null);
            }
            return context;
        }
    }
}

