/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing;

import com.datadog.android.api.InternalLogger;
import com.datadog.exec.CommonTaskExecutor;
import com.datadog.legacy.trace.common.util.Clock;
import com.datadog.opentracing.DDSpan;
import com.datadog.opentracing.DDTracer;
import com.datadog.opentracing.scopemanager.ContinuableScope;
import java.io.Closeable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class PendingTrace
extends LinkedList<DDSpan> {
    private static final AtomicReference<SpanCleaner> SPAN_CLEANER = new AtomicReference();
    private final DDTracer tracer;
    private final BigInteger traceId;
    private final long startTimeNano;
    private final long startNanoTicks;
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final Set<WeakReference<?>> weakReferences = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicInteger pendingReferenceCount = new AtomicInteger(0);
    private final AtomicInteger completedSpanCount = new AtomicInteger(0);
    private final AtomicReference<WeakReference<DDSpan>> rootSpan = new AtomicReference();
    private final AtomicBoolean isWritten = new AtomicBoolean(false);
    private final InternalLogger internalLogger;

    PendingTrace(DDTracer tracer, BigInteger traceId, InternalLogger internalLogger) {
        this.tracer = tracer;
        this.traceId = traceId;
        this.internalLogger = internalLogger;
        this.startTimeNano = Clock.currentNanoTime();
        this.startNanoTicks = Clock.currentNanoTicks();
        this.addPendingTrace();
    }

    public long getCurrentTimeNano() {
        return this.startTimeNano + Math.max(0L, Clock.currentNanoTicks() - this.startNanoTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSpan(DDSpan span) {
        if (this.traceId == null || span.context() == null) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not registered because of null traceId or context; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
            return;
        }
        BigInteger spanTraceId = span.context().getTraceId();
        if (!this.traceId.equals(spanTraceId)) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not registered because of traceId mismatch; spanId:" + span.getSpanId() + " span.traceid:" + spanTraceId + " traceid:" + this.traceId, null, false, new HashMap());
            return;
        }
        this.rootSpan.compareAndSet(null, new WeakReference<DDSpan>(span));
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (null == span.ref) {
                span.ref = new WeakReference<DDSpan>(span, this.referenceQueue);
                this.weakReferences.add(span.ref);
                int n = this.pendingReferenceCount.incrementAndGet();
            } else {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not registered because it is already registered; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireSpan(DDSpan span, boolean write2) {
        if (this.traceId == null || span.context() == null) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not expired because of null traceId or context; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
            return;
        }
        BigInteger spanTraceId = span.context().getTraceId();
        if (!this.traceId.equals(spanTraceId)) {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not expired because of traceId mismatch; spanId:" + span.getSpanId() + " span.traceid:" + spanTraceId + " traceid:" + this.traceId, null, false, new HashMap());
            return;
        }
        DDSpan dDSpan = span;
        synchronized (dDSpan) {
            if (span.ref == null) {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not expired because it's not registered; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
                return;
            }
            this.weakReferences.remove(span.ref);
            span.ref.clear();
            span.ref = null;
            if (write2) {
                this.expireReference();
            } else {
                this.pendingReferenceCount.decrementAndGet();
            }
        }
    }

    public void dropSpan(DDSpan span) {
        this.expireSpan(span, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSpan(DDSpan span) {
        PendingTrace pendingTrace = this;
        synchronized (pendingTrace) {
            if (span.getDurationNano() == 0L) {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not added because duration is zero; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
                return;
            }
            if (this.traceId == null || span.context() == null) {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not added because of null traceId or context; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
                return;
            }
            if (!this.traceId.equals(span.getTraceId())) {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not added because of traceId mismatch; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
                return;
            }
            if (!this.isWritten.get()) {
                this.addFirst(span);
            } else {
                this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Span " + span.getOperationName() + " not added because trace already written; spanId:" + span.getSpanId() + " traceid:" + this.traceId, null, false, new HashMap());
            }
            this.expireSpan(span, true);
        }
    }

    public DDSpan getRootSpan() {
        WeakReference<DDSpan> rootRef = this.rootSpan.get();
        return rootRef == null ? null : (DDSpan)rootRef.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref == null) {
                continuation.ref = new WeakReference<ContinuableScope.Continuation>(continuation, this.referenceQueue);
                this.weakReferences.add(continuation.ref);
                int n = this.pendingReferenceCount.incrementAndGet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelContinuation(ContinuableScope.Continuation continuation) {
        ContinuableScope.Continuation continuation2 = continuation;
        synchronized (continuation2) {
            if (continuation.ref != null) {
                this.weakReferences.remove(continuation.ref);
                continuation.ref.clear();
                continuation.ref = null;
                this.expireReference();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireReference() {
        int count = this.pendingReferenceCount.decrementAndGet();
        if (count == 0) {
            this.write();
        } else if (this.tracer.getPartialFlushMinSpans() > 0 && this.size() > this.tracer.getPartialFlushMinSpans()) {
            PendingTrace pendingTrace = this;
            synchronized (pendingTrace) {
                if (this.size() > this.tracer.getPartialFlushMinSpans()) {
                    DDSpan rootSpan = this.getRootSpan();
                    ArrayList<DDSpan> partialTrace = new ArrayList<DDSpan>(this.size());
                    Iterator it = this.iterator();
                    while (it.hasNext()) {
                        DDSpan span = (DDSpan)it.next();
                        if (span == rootSpan) continue;
                        partialTrace.add(span);
                        this.completedSpanCount.decrementAndGet();
                        it.remove();
                    }
                    this.tracer.write(partialTrace);
                }
            }
        }
    }

    private synchronized void write() {
        if (this.isWritten.compareAndSet(false, true)) {
            this.removePendingTrace();
            if (!this.isEmpty()) {
                this.tracer.write(this);
            }
        } else {
            this.internalLogger.log(InternalLogger.Level.ERROR, InternalLogger.Target.USER, () -> "Trace " + this.traceId + " write ignored: isWritten already true", null, false, new HashMap());
        }
    }

    public synchronized boolean clean() {
        Reference ref;
        int count = 0;
        while ((ref = this.referenceQueue.poll()) != null) {
            this.weakReferences.remove(ref);
            if (this.isWritten.compareAndSet(false, true)) {
                this.removePendingTrace();
                this.tracer.incrementTraceCount();
            }
            ++count;
            this.expireReference();
        }
        if (count > 0) {
            // empty if block
        }
        return count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addFirst(DDSpan span) {
        PendingTrace pendingTrace = this;
        synchronized (pendingTrace) {
            super.addFirst(span);
        }
        this.completedSpanCount.incrementAndGet();
    }

    @Override
    public int size() {
        return this.completedSpanCount.get();
    }

    private void addPendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.add(this);
        }
    }

    private void removePendingTrace() {
        SpanCleaner cleaner = SPAN_CLEANER.get();
        if (cleaner != null) {
            cleaner.pendingTraces.remove(this);
        }
    }

    static void initialize() {
        SpanCleaner oldCleaner = SPAN_CLEANER.getAndSet(new SpanCleaner());
        if (oldCleaner != null) {
            oldCleaner.close();
        }
    }

    static void close() {
        SpanCleaner cleaner = SPAN_CLEANER.getAndSet(null);
        if (cleaner != null) {
            cleaner.close();
        }
    }

    private static class SpanCleaner
    implements Runnable,
    Closeable {
        private static final long CLEAN_FREQUENCY = 1L;
        private final Set<PendingTrace> pendingTraces = Collections.newSetFromMap(new ConcurrentHashMap());

        public SpanCleaner() {
            CommonTaskExecutor.INSTANCE.scheduleAtFixedRate(SpanCleanerTask.INSTANCE, this, 0L, 1L, TimeUnit.SECONDS, "Pending trace cleaner");
        }

        @Override
        public void run() {
            for (PendingTrace trace : this.pendingTraces) {
                trace.clean();
            }
        }

        @Override
        public void close() {
            this.run();
        }
    }

    private static class SpanCleanerTask
    implements CommonTaskExecutor.Task<SpanCleaner> {
        static final SpanCleanerTask INSTANCE = new SpanCleanerTask();

        private SpanCleanerTask() {
        }

        @Override
        public void run(SpanCleaner target) {
            target.run();
        }
    }
}

