/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class B3HttpCodec {
    private static final String HEADER_KEY = "b3";
    private static final String HEADER_VALUE = "%s-%s";
    private static final String HEADER_VALUE_WITH_SAMPLING = "%s-%s-%s";
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;

    private B3HttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (B3HttpCodec.HEADER_KEY.equalsIgnoreCase(key)) {
                        String[] valueParts = value.split("-");
                        if (valueParts.length < 2 || valueParts.length > 4) continue;
                        int traceIdLength = valueParts[0].length();
                        if (traceIdLength > 32) {
                            traceId = BigInteger.ZERO;
                            continue;
                        }
                        String trimmedValue = traceIdLength > 16 ? valueParts[0].substring(traceIdLength - 16) : valueParts[0];
                        traceId = HttpCodec.validateUInt128BitsID(trimmedValue, 16);
                        spanId = HttpCodec.validateUInt64BitsID(valueParts[1], 16);
                        if (valueParts.length >= 3) {
                            samplingPriority = this.convertSamplingPriority(valueParts[2]);
                        }
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, null, Collections.emptyMap(), tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (!tags.isEmpty()) {
                    return new TagContext(null, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            try {
                String traceId = context.getTraceId().toString(16).toLowerCase(Locale.US);
                String spanId = context.getSpanId().toString(16).toLowerCase(Locale.US);
                if (context.lockSamplingPriority()) {
                    carrier.put(B3HttpCodec.HEADER_KEY, String.format(B3HttpCodec.HEADER_VALUE_WITH_SAMPLING, traceId, spanId, this.convertSamplingPriority(context.getSamplingPriority())));
                } else {
                    carrier.put(B3HttpCodec.HEADER_KEY, String.format(B3HttpCodec.HEADER_VALUE, traceId, spanId));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }
    }
}

