/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.android.trace.internal.domain.event.BigIntegerUtils;
import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import com.datadog.trace.api.internal.util.LongStringUtils;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

class DatadogHttpCodec {
    public static final String OT_BAGGAGE_PREFIX = "ot-baggage-";
    public static final String LEAST_SIGNIFICANT_TRACE_ID_KEY = "x-datadog-trace-id";
    public static final String MOST_SIGNIFICANT_TRACE_ID_KEY = "_dd.p.tid";
    public static final String DATADOG_TAGS_KEY = "x-datadog-tags";
    public static final String SPAN_ID_KEY = "x-datadog-parent-id";
    public static final String SAMPLING_PRIORITY_KEY = "x-datadog-sampling-priority";
    public static final String ORIGIN_KEY = "x-datadog-origin";

    private DatadogHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> baggage = Collections.emptyMap();
                Map<String, String> tags = Collections.emptyMap();
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                String origin = null;
                String mostSignificant64BitsTraceIdAsHex = null;
                String leastSignificant64BitsTraceIdAsDecimal = null;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (DatadogHttpCodec.LEAST_SIGNIFICANT_TRACE_ID_KEY.equalsIgnoreCase(key)) {
                        leastSignificant64BitsTraceIdAsDecimal = value;
                    } else if (DatadogHttpCodec.DATADOG_TAGS_KEY.equalsIgnoreCase(key)) {
                        mostSignificant64BitsTraceIdAsHex = this.extractMostSignificant64BitsTraceId(value);
                    } else if (DatadogHttpCodec.SPAN_ID_KEY.equalsIgnoreCase(key)) {
                        spanId = HttpCodec.validateUInt64BitsID(value, 10);
                    } else if (DatadogHttpCodec.SAMPLING_PRIORITY_KEY.equalsIgnoreCase(key)) {
                        samplingPriority = Integer.parseInt(value);
                    } else if (DatadogHttpCodec.ORIGIN_KEY.equalsIgnoreCase(key)) {
                        origin = value;
                    } else if (key.startsWith(DatadogHttpCodec.OT_BAGGAGE_PREFIX)) {
                        if (baggage.isEmpty()) {
                            baggage = new HashMap<String, String>();
                        }
                        baggage.put(key.replace(DatadogHttpCodec.OT_BAGGAGE_PREFIX, ""), HttpCodec.decode(value));
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (leastSignificant64BitsTraceIdAsDecimal == null || mostSignificant64BitsTraceIdAsHex == null) {
                    return new TagContext(origin, tags);
                }
                long leastSignificantTraceId = LongStringUtils.parseUnsignedLong(leastSignificant64BitsTraceIdAsDecimal);
                String traceIdAsHex = mostSignificant64BitsTraceIdAsHex + LongStringUtils.toHexStringPadded(leastSignificantTraceId, 16);
                BigInteger traceId = HttpCodec.validateUInt128BitsID(traceIdAsHex, 16);
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, origin, baggage, tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (origin != null || !tags.isEmpty()) {
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        private String extractMostSignificant64BitsTraceId(String tags) {
            String[] tagArray;
            if (tags == null) {
                return null;
            }
            for (String tag : tagArray = tags.split(",")) {
                String[] tagKeyValue = tag.split("=");
                if (tagKeyValue.length < 2 || !DatadogHttpCodec.MOST_SIGNIFICANT_TRACE_ID_KEY.equals(tagKeyValue[0])) continue;
                return tagKeyValue[1];
            }
            return null;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        private final BigIntegerUtils bigIntegerUtils;

        public Injector(BigIntegerUtils bigIntegerUtils) {
            this.bigIntegerUtils = bigIntegerUtils;
        }

        public Injector() {
            this(BigIntegerUtils.INSTANCE);
        }

        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            BigInteger traceId = context.getTraceId();
            String leastSignificantTraceId = this.bigIntegerUtils.leastSignificant64BitsAsDecimal(traceId);
            String mostSignificantTraceId = this.bigIntegerUtils.mostSignificant64BitsAsHex(traceId);
            carrier.put(DatadogHttpCodec.LEAST_SIGNIFICANT_TRACE_ID_KEY, leastSignificantTraceId);
            carrier.put(DatadogHttpCodec.SPAN_ID_KEY, context.getSpanId().toString());
            String origin = context.getOrigin();
            if (origin != null) {
                carrier.put(DatadogHttpCodec.ORIGIN_KEY, origin);
            }
            for (Map.Entry<String, String> entry : context.baggageItems()) {
                carrier.put(DatadogHttpCodec.OT_BAGGAGE_PREFIX + entry.getKey(), HttpCodec.encode(entry.getValue()));
            }
            carrier.put(DatadogHttpCodec.DATADOG_TAGS_KEY, "_dd.p.tid=" + mostSignificantTraceId);
            carrier.put(DatadogHttpCodec.SAMPLING_PRIORITY_KEY, "1");
        }
    }
}

