/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.legacy.trace.api.Config;
import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.DDTracer;
import com.datadog.opentracing.StringCachingBigInteger;
import com.datadog.opentracing.propagation.B3HttpCodec;
import com.datadog.opentracing.propagation.B3MHttpCodec;
import com.datadog.opentracing.propagation.DatadogHttpCodec;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HaystackHttpCodec;
import com.datadog.opentracing.propagation.W3CHttpCodec;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HttpCodec {
    public static Injector createInjector(Config config) {
        ArrayList<Injector> injectors = new ArrayList<Injector>();
        for (Config.PropagationStyle style : config.getPropagationStylesToInject()) {
            if (style == Config.PropagationStyle.DATADOG) {
                injectors.add(new DatadogHttpCodec.Injector());
                continue;
            }
            if (style == Config.PropagationStyle.B3) {
                injectors.add(new B3HttpCodec.Injector());
                continue;
            }
            if (style == Config.PropagationStyle.B3MULTI) {
                injectors.add(new B3MHttpCodec.Injector());
                continue;
            }
            if (style == Config.PropagationStyle.TRACECONTEXT) {
                injectors.add(new W3CHttpCodec.Injector());
                continue;
            }
            if (style != Config.PropagationStyle.HAYSTACK) continue;
            injectors.add(new HaystackHttpCodec.Injector());
        }
        return new CompoundInjector(injectors);
    }

    public static Extractor createExtractor(Config config, Map<String, String> taggedHeaders) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        for (Config.PropagationStyle style : config.getPropagationStylesToExtract()) {
            if (style == Config.PropagationStyle.DATADOG) {
                extractors.add(new DatadogHttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style == Config.PropagationStyle.B3) {
                extractors.add(new B3HttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style == Config.PropagationStyle.B3MULTI) {
                extractors.add(new B3MHttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style == Config.PropagationStyle.TRACECONTEXT) {
                extractors.add(new W3CHttpCodec.Extractor(taggedHeaders));
                continue;
            }
            if (style != Config.PropagationStyle.HAYSTACK) continue;
            extractors.add(new HaystackHttpCodec.Extractor(taggedHeaders));
        }
        return new CompoundExtractor(extractors);
    }

    static BigInteger validateUInt64BitsID(String value, int radix) throws IllegalArgumentException {
        StringCachingBigInteger parsedValue = new StringCachingBigInteger(value, radix);
        if (parsedValue.compareTo(DDTracer.TRACE_ID_MIN) < 0 || parsedValue.compareTo(DDTracer.TRACE_ID_64_BITS_MAX) > 0) {
            throw new IllegalArgumentException("ID out of range, must be between 0 and 2^64-1, got: " + value);
        }
        return parsedValue;
    }

    static BigInteger validateUInt128BitsID(String value, int radix) throws IllegalArgumentException {
        StringCachingBigInteger parsedValue = new StringCachingBigInteger(value, radix);
        if (parsedValue.compareTo(DDTracer.TRACE_ID_MIN) < 0 || parsedValue.compareTo(DDTracer.TRACE_ID_128_BITS_MAX) > 0) {
            throw new IllegalArgumentException("ID out of range, must be between 0 and 2^128-1, got: " + value);
        }
        return parsedValue;
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return decoded;
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier);
            }
        }
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;

        public CompoundExtractor(List<Extractor> extractors) {
            this.extractors = extractors;
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            SpanContext context = null;
            for (Extractor extractor : this.extractors) {
                context = extractor.extract(carrier);
                if (context == null || !(context instanceof ExtractedContext)) continue;
                return context;
            }
            return context;
        }
    }

    public static interface Extractor {
        public SpanContext extract(TextMapExtract var1);
    }

    public static interface Injector {
        public void inject(DDSpanContext var1, TextMapInject var2);
    }
}

