/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.propagation;

import com.datadog.opentracing.DDSpanContext;
import com.datadog.opentracing.propagation.ExtractedContext;
import com.datadog.opentracing.propagation.HttpCodec;
import com.datadog.opentracing.propagation.TagContext;
import io.opentracing.SpanContext;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.text.StringsKt;

class W3CHttpCodec {
    private static final String TRACEPARENT_KEY = "traceparent";
    private static final String TRACESTATE_KEY = "tracestate";
    private static final String TRACEPARENT_VALUE = "00-%s-%s-0%s";
    private static final int TRACECONTEXT_PARENT_ID_LENGTH = 16;
    private static final int TRACECONTEXT_TRACE_ID_LENGTH = 32;
    private static final String SAMPLING_PRIORITY_ACCEPT = String.valueOf(1);
    private static final String SAMPLING_PRIORITY_DROP = String.valueOf(0);
    private static final int HEX_RADIX = 16;
    private static final String ORIGIN_TRACESTATE_TAG_VALUE = "o";
    private static final String SAMPLING_PRIORITY_TRACESTATE_TAG_VALUE = "s";
    private static final String PARENT_SPAN_ID_TRACESTATE_TAG_VALUE = "p";
    private static final String DATADOG_VENDOR_TRACESTATE_PREFIX = "dd=";

    private W3CHttpCodec() {
    }

    public static class Extractor
    implements HttpCodec.Extractor {
        private final Map<String, String> taggedHeaders = new HashMap<String, String>();

        public Extractor(Map<String, String> taggedHeaders) {
            for (Map.Entry<String, String> mapping : taggedHeaders.entrySet()) {
                this.taggedHeaders.put(mapping.getKey().trim().toLowerCase(Locale.US), mapping.getValue());
            }
        }

        @Override
        public SpanContext extract(TextMapExtract carrier) {
            try {
                Map<String, String> tags = Collections.emptyMap();
                BigInteger traceId = BigInteger.ZERO;
                BigInteger spanId = BigInteger.ZERO;
                int samplingPriority = Integer.MIN_VALUE;
                String origin = null;
                for (Map.Entry entry : carrier) {
                    String key = ((String)entry.getKey()).toLowerCase(Locale.US);
                    String value = (String)entry.getValue();
                    if (value == null) continue;
                    if (W3CHttpCodec.TRACEPARENT_KEY.equalsIgnoreCase(key)) {
                        String[] valueParts = value.split("-");
                        if (valueParts.length != 4 || "ff".equalsIgnoreCase(valueParts[0])) continue;
                        int traceIdLength = valueParts[1].length();
                        if (traceIdLength > 32) {
                            traceId = BigInteger.ZERO;
                            continue;
                        }
                        String trimmedValue = traceIdLength > 16 ? valueParts[1].substring(traceIdLength - 16) : valueParts[1];
                        traceId = HttpCodec.validateUInt128BitsID(trimmedValue, 16);
                        spanId = HttpCodec.validateUInt64BitsID(valueParts[2], 16);
                        samplingPriority = this.convertSamplingPriority(valueParts[3]);
                    } else if (W3CHttpCodec.TRACESTATE_KEY.equalsIgnoreCase(key)) {
                        Map<String, String> datadogTraceStateTags = this.extractDatadogTagsFromTraceState(value);
                        origin = datadogTraceStateTags.get(W3CHttpCodec.ORIGIN_TRACESTATE_TAG_VALUE);
                    }
                    if (!this.taggedHeaders.containsKey(key)) continue;
                    if (tags.isEmpty()) {
                        tags = new HashMap<String, String>();
                    }
                    tags.put(this.taggedHeaders.get(key), HttpCodec.decode(value));
                }
                if (!BigInteger.ZERO.equals(traceId)) {
                    ExtractedContext context = new ExtractedContext(traceId, spanId, samplingPriority, origin, Collections.emptyMap(), tags);
                    context.lockSamplingPriority();
                    return context;
                }
                if (!tags.isEmpty()) {
                    return new TagContext(origin, tags);
                }
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            return null;
        }

        private int convertSamplingPriority(String samplingPriority) {
            return Integer.parseInt(samplingPriority) == 1 ? 1 : 0;
        }

        private Map<String, String> extractDatadogTagsFromTraceState(String traceState) {
            String[] vendors = traceState.split(",");
            HashMap<String, String> tags = new HashMap<String, String>();
            for (String vendor : vendors) {
                String[] vendorTags;
                if (!vendor.startsWith(W3CHttpCodec.DATADOG_VENDOR_TRACESTATE_PREFIX)) continue;
                for (String vendorTag : vendorTags = vendor.substring(W3CHttpCodec.DATADOG_VENDOR_TRACESTATE_PREFIX.length()).split(";")) {
                    String[] keyAndValue = vendorTag.split(":");
                    if (keyAndValue.length != 2) continue;
                    tags.put(keyAndValue[0], keyAndValue[1]);
                }
            }
            return tags;
        }
    }

    public static class Injector
    implements HttpCodec.Injector {
        @Override
        public void inject(DDSpanContext context, TextMapInject carrier) {
            try {
                String traceId = context.getTraceId().toString(16).toLowerCase(Locale.US);
                String spanId = context.getSpanId().toString(16).toLowerCase(Locale.US);
                String samplingPriority = this.convertSamplingPriority(context.getSamplingPriority());
                String origin = context.getOrigin();
                carrier.put(W3CHttpCodec.TRACEPARENT_KEY, String.format(W3CHttpCodec.TRACEPARENT_VALUE, StringsKt.padStart((String)traceId, (int)32, (char)'0'), StringsKt.padStart((String)spanId, (int)16, (char)'0'), samplingPriority));
                carrier.put(W3CHttpCodec.TRACESTATE_KEY, this.createTraceStateHeader(samplingPriority, origin, spanId));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }

        private String convertSamplingPriority(int samplingPriority) {
            return samplingPriority > 0 ? SAMPLING_PRIORITY_ACCEPT : SAMPLING_PRIORITY_DROP;
        }

        private String createTraceStateHeader(String samplingPriority, String origin, String parentSpanId) {
            StringBuilder sb = new StringBuilder(W3CHttpCodec.DATADOG_VENDOR_TRACESTATE_PREFIX).append(W3CHttpCodec.SAMPLING_PRIORITY_TRACESTATE_TAG_VALUE).append(":").append(samplingPriority).append(";").append(W3CHttpCodec.PARENT_SPAN_ID_TRACESTATE_TAG_VALUE).append(":").append(parentSpanId);
            if (origin != null) {
                sb.append(";").append(W3CHttpCodec.ORIGIN_TRACESTATE_TAG_VALUE).append(":").append(origin.toLowerCase(Locale.US));
            }
            return sb.toString();
        }
    }
}

