/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.opentracing.scopemanager;

import com.datadog.legacy.trace.context.ScopeListener;
import com.datadog.opentracing.scopemanager.ContextualScopeManager;
import com.datadog.opentracing.scopemanager.DDScope;
import io.opentracing.Span;

public class SimpleScope
implements DDScope {
    private final ContextualScopeManager scopeManager;
    private final Span spanUnderScope;
    private final boolean finishOnClose;
    private final DDScope toRestore;
    private final int depth;

    public SimpleScope(ContextualScopeManager scopeManager, Span spanUnderScope, boolean finishOnClose) {
        assert (spanUnderScope != null) : "span must not be null";
        this.scopeManager = scopeManager;
        this.spanUnderScope = spanUnderScope;
        this.finishOnClose = finishOnClose;
        this.toRestore = scopeManager.tlsScope.get();
        scopeManager.tlsScope.set(this);
        this.depth = this.toRestore == null ? 0 : this.toRestore.depth() + 1;
        for (ScopeListener listener : scopeManager.scopeListeners) {
            listener.afterScopeActivated();
        }
    }

    public void close() {
        if (this.finishOnClose) {
            this.spanUnderScope.finish();
        }
        for (ScopeListener listener : this.scopeManager.scopeListeners) {
            listener.afterScopeClosed();
        }
        if (this.scopeManager.tlsScope.get() == this) {
            this.scopeManager.tlsScope.set(this.toRestore);
            if (this.toRestore != null) {
                for (ScopeListener listener : this.scopeManager.scopeListeners) {
                    listener.afterScopeActivated();
                }
            }
        }
    }

    @Override
    public Span span() {
        return this.spanUnderScope;
    }

    @Override
    public int depth() {
        return this.depth;
    }
}

