/*
 * Decompiled with CFR 0.152.
 */
package com.datadog.trace.api;

import com.datadog.trace.api.ConfigOrigin;
import com.datadog.trace.api.ConfigSetting;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class ConfigCollector {
    private static final ConfigCollector INSTANCE = new ConfigCollector();
    private static final AtomicReferenceFieldUpdater<ConfigCollector, Map> COLLECTED_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ConfigCollector.class, Map.class, "collected");
    private volatile Map<String, ConfigSetting> collected = new ConcurrentHashMap<String, ConfigSetting>();

    public static ConfigCollector get() {
        return INSTANCE;
    }

    public void put(String key, Object value, ConfigOrigin origin) {
        ConfigSetting setting = new ConfigSetting(key, value, origin);
        this.collected.put(key, setting);
    }

    public void putAll(Map<String, Object> keysAndValues, ConfigOrigin origin) {
        ConcurrentHashMap<String, ConfigSetting> merged = new ConcurrentHashMap<String, ConfigSetting>(keysAndValues.size() + this.collected.size());
        for (Map.Entry<String, Object> entry : keysAndValues.entrySet()) {
            ConfigSetting setting = new ConfigSetting(entry.getKey(), entry.getValue(), origin);
            merged.put(entry.getKey(), setting);
        }
        while (true) {
            Map<String, ConfigSetting> current = this.collected;
            for (Map.Entry<String, ConfigSetting> entry : current.entrySet()) {
                if (keysAndValues.containsKey(entry.getKey())) continue;
                merged.put(entry.getKey(), entry.getValue());
            }
            if (COLLECTED_UPDATER.compareAndSet(this, current, merged)) break;
            merged.keySet().retainAll(keysAndValues.keySet());
        }
    }
}

